/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.kenai;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.kenai.ui.spi.BuildHandle;
import org.openide.util.RequestProcessor;

class BuildHandleImpl
extends BuildHandle {
    private final HudsonJob job;

    public BuildHandleImpl(HudsonJob job) {
        this.job = job;
    }

    public String getDisplayName() {
        return this.job.getDisplayName();
    }

    public BuildHandle.Status getStatus() {
        switch (this.job.getColor()) {
            case blue_anime: 
            case yellow_anime: 
            case red_anime: 
            case aborted_anime: 
            case grey_anime: {
                return BuildHandle.Status.RUNNING;
            }
            case blue: {
                return BuildHandle.Status.STABLE;
            }
            case yellow: {
                return BuildHandle.Status.UNSTABLE;
            }
            case red: {
                return BuildHandle.Status.FAILED;
            }
        }
        return BuildHandle.Status.UNKNOWN;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public Action getDefaultAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                final int build = BuildHandleImpl.this.job.getLastBuild();
                if (build == -1) {
                    UI.selectNode((String[])new String[]{BuildHandleImpl.this.job.getInstance().getUrl(), BuildHandleImpl.this.job.getName()});
                } else {
                    UI.selectNode((String[])new String[]{BuildHandleImpl.this.job.getInstance().getUrl(), BuildHandleImpl.this.job.getName(), Integer.toString(build)});
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        if (build == -1) {
                            BuildHandleImpl.this.job.start();
                            return;
                        }
                        block8: for (HudsonJobBuild b : BuildHandleImpl.this.job.getBuilds()) {
                            if (b.getNumber() != build) continue;
                            switch (b.getResult()) {
                                case FAILURE: 
                                case ABORTED: {
                                    UI.showConsoleAction((HudsonJobBuild)b).actionPerformed(e);
                                    break;
                                }
                                case UNSTABLE: {
                                    if (b.getMavenModules().isEmpty()) {
                                        UI.showFailuresAction((HudsonJobBuild)b).actionPerformed(e);
                                        break;
                                    }
                                    for (HudsonMavenModuleBuild module : b.getMavenModules()) {
                                        switch (module.getColor()) {
                                            case yellow_anime: 
                                            case yellow: {
                                                UI.showFailuresAction((HudsonMavenModuleBuild)module).actionPerformed(e);
                                            }
                                        }
                                    }
                                    break block8;
                                }
                                case SUCCESS: 
                                case NOT_BUILT: {
                                    UI.showChangesAction((HudsonJobBuild)b).actionPerformed(e);
                                }
                            }
                            break;
                        }
                    }
                });
            }
        };
    }
}

