/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import groovy.ui.GroovyMain;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyShell
extends GroovyObjectSupport {
    public static final String[] EMPTY_ARGS = new String[0];
    private Binding context;
    private int counter;
    private CompilerConfiguration config;
    private GroovyClassLoader loader;

    public static void main(String[] args) {
        GroovyMain.main(args);
    }

    public GroovyShell() {
        this(null, new Binding());
    }

    public GroovyShell(Binding binding) {
        this(null, binding);
    }

    public GroovyShell(CompilerConfiguration config) {
        this(new Binding(), config);
    }

    public GroovyShell(Binding binding, CompilerConfiguration config) {
        this(null, binding, config);
    }

    public GroovyShell(ClassLoader parent, Binding binding) {
        this(parent, binding, CompilerConfiguration.DEFAULT);
    }

    public GroovyShell(ClassLoader parent) {
        this(parent, new Binding(), CompilerConfiguration.DEFAULT);
    }

    public GroovyShell(ClassLoader parent, Binding binding, final CompilerConfiguration config) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must not be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("Compiler configuration must not be null.");
        }
        final ClassLoader parentLoader = parent != null ? parent : GroovyShell.class.getClassLoader();
        this.loader = (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyClassLoader(parentLoader, config);
            }
        });
        this.context = binding;
        this.config = config;
    }

    public void initializeBinding() {
        Map map = this.context.getVariables();
        if (map.get("shell") == null) {
            map.put("shell", this);
        }
    }

    public void resetLoadedClasses() {
        this.loader.clearCache();
    }

    public GroovyShell(GroovyShell shell) {
        this(shell.loader, shell.context);
    }

    public Binding getContext() {
        return this.context;
    }

    public GroovyClassLoader getClassLoader() {
        return this.loader;
    }

    public Object getProperty(String property) {
        Object answer = this.getVariable(property);
        if (answer == null) {
            answer = super.getProperty(property);
        }
        return answer;
    }

    public void setProperty(String property, Object newValue) {
        this.setVariable(property, newValue);
        try {
            super.setProperty(property, newValue);
        }
        catch (GroovyRuntimeException groovyRuntimeException) {
            // empty catch block
        }
    }

    public Object run(File scriptFile, List list) throws CompilationFailedException, IOException {
        String[] args = new String[list.size()];
        return this.run(scriptFile, list.toArray(args));
    }

    public Object run(String scriptText, String fileName, List list) throws CompilationFailedException {
        String[] args = new String[list.size()];
        list.toArray(args);
        return this.run(scriptText, fileName, args);
    }

    public Object run(final File scriptFile, String[] args) throws CompilationFailedException, IOException {
        Class scriptClass;
        String scriptName = scriptFile.getName();
        int p = scriptName.lastIndexOf(".");
        if (p++ >= 0 && scriptName.substring(p).equals("java")) {
            System.err.println("error: cannot compile file with .java extension: " + scriptName);
            throw new CompilationFailedException(0, null);
        }
        final Thread thread = Thread.currentThread();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DoSetContext
        implements PrivilegedAction {
            ClassLoader classLoader;

            public DoSetContext(ClassLoader loader) {
                this.classLoader = loader;
            }

            public Object run() {
                thread.setContextClassLoader(this.classLoader);
                return null;
            }
        }
        AccessController.doPrivileged(new DoSetContext(this.loader));
        try {
            scriptClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws CompilationFailedException, IOException {
                    return GroovyShell.this.loader.parseClass(scriptFile);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof CompilationFailedException) {
                throw (CompilationFailedException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)pae.getException();
        }
        return this.runScriptOrMainOrTestOrRunnable(scriptClass, args);
    }

    private Object runScriptOrMainOrTestOrRunnable(Class scriptClass, String[] args) {
        if (scriptClass == null) {
            return null;
        }
        try {
            if (Script.class.isAssignableFrom(scriptClass)) {
                Script script = null;
                try {
                    script = (Script)scriptClass.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (script != null) {
                    script.setBinding(this.context);
                    script.setProperty("args", args);
                    return script.run();
                }
            }
            scriptClass.getMethod("main", String[].class);
            return InvokerHelper.invokeMethod(scriptClass, "main", new Object[]{args});
        }
        catch (NoSuchMethodException e) {
            if (Runnable.class.isAssignableFrom(scriptClass)) {
                return this.runRunnable(scriptClass, args);
            }
            if (this.isJUnit3Test(scriptClass)) {
                return this.runJUnit3Test(scriptClass);
            }
            if (this.isJUnit4Test(scriptClass)) {
                return this.runJUnit4Test(scriptClass);
            }
            if (this.isTestNgTest(scriptClass)) {
                return this.runTestNgTest(scriptClass);
            }
            throw new GroovyRuntimeException("This script or class could not be run.\nIt should either: \n- have a main method, \n- be a JUnit test, TestNG test or extend GroovyTestCase, \n- or implement the Runnable interface.");
        }
    }

    private Object runRunnable(Class scriptClass, String[] args) {
        Constructor constructor = null;
        Runnable runnable = null;
        Throwable reason = null;
        try {
            constructor = scriptClass.getConstructor(new String[0].getClass());
            try {
                runnable = (Runnable)constructor.newInstance(new Object[]{args});
            }
            catch (Throwable t) {
                reason = t;
            }
        }
        catch (NoSuchMethodException e1) {
            try {
                constructor = scriptClass.getConstructor(new Class[0]);
                try {
                    runnable = (Runnable)constructor.newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    reason = t;
                }
            }
            catch (NoSuchMethodException nsme) {
                reason = nsme;
            }
        }
        if (constructor == null || runnable == null) {
            throw new GroovyRuntimeException("This script or class was runnable but could not be run. ", reason);
        }
        runnable.run();
        return null;
    }

    private Object runJUnit3Test(Class scriptClass) {
        try {
            Object testSuite = InvokerHelper.invokeConstructorOf("junit.framework.TestSuite", (Object)new Object[]{scriptClass});
            return InvokerHelper.invokeStaticMethod("junit.textui.TestRunner", "run", (Object)new Object[]{testSuite});
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Failed to run the unit test. JUnit is not on the Classpath.");
        }
    }

    private Object runJUnit4Test(Class scriptClass) {
        try {
            return InvokerHelper.invokeStaticMethod("org.codehaus.groovy.vmplugin.v5.JUnit4Utils", "realRunJUnit4Test", (Object)new Object[]{scriptClass});
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Failed to run the JUnit 4 test.");
        }
    }

    private Object runTestNgTest(Class scriptClass) {
        try {
            return InvokerHelper.invokeStaticMethod("org.codehaus.groovy.vmplugin.v5.TestNgUtils", "realRunTestNgTest", (Object)new Object[]{scriptClass});
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Failed to run the TestNG test.");
        }
    }

    private boolean isJUnit3Test(Class scriptClass) {
        boolean isUnitTestCase = false;
        try {
            try {
                Class<?> testCaseClass = this.loader.loadClass("junit.framework.TestCase");
                if (testCaseClass.isAssignableFrom(scriptClass)) {
                    isUnitTestCase = true;
                }
            }
            catch (ClassNotFoundException e) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isUnitTestCase;
    }

    private boolean isJUnit4Test(Class scriptClass) {
        char version = System.getProperty("java.version").charAt(2);
        if (version < '5') {
            return false;
        }
        boolean isTest = false;
        try {
            if (InvokerHelper.invokeStaticMethod("org.codehaus.groovy.vmplugin.v5.JUnit4Utils", "realIsJUnit4Test", (Object)new Object[]{scriptClass, this.loader}) == Boolean.TRUE) {
                isTest = true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Failed to invoke the JUnit 4 helper class.");
        }
        return isTest;
    }

    private boolean isTestNgTest(Class scriptClass) {
        char version = System.getProperty("java.version").charAt(2);
        if (version < '5') {
            return false;
        }
        boolean isTest = false;
        try {
            if (InvokerHelper.invokeStaticMethod("org.codehaus.groovy.vmplugin.v5.TestNgUtils", "realIsTestNgTest", (Object)new Object[]{scriptClass, this.loader}) == Boolean.TRUE) {
                isTest = true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new GroovyRuntimeException("Failed to invoke the TestNG helper class.");
        }
        return isTest;
    }

    public Object run(String scriptText, String fileName, String[] args) throws CompilationFailedException {
        try {
            return this.run(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), fileName, args);
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Object run(final InputStream in, final String fileName, String[] args) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/shell");
            }
        });
        Class scriptClass = this.parseClass(gcs);
        return this.runScriptOrMainOrTestOrRunnable(scriptClass, args);
    }

    public Object getVariable(String name) {
        return this.context.getVariables().get(name);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Object evaluate(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script script = this.parse(codeSource);
        return script.run();
    }

    public Object evaluate(String scriptText, String fileName) throws CompilationFailedException {
        try {
            return this.evaluate(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Object evaluate(String scriptText, String fileName, String codeBase) throws CompilationFailedException {
        try {
            return this.evaluate(new GroovyCodeSource(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), fileName, codeBase));
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Object evaluate(File file) throws CompilationFailedException, IOException {
        return this.evaluate(new GroovyCodeSource(file));
    }

    public Object evaluate(String scriptText) throws CompilationFailedException {
        try {
            return this.evaluate(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), this.generateScriptName());
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Object evaluate(InputStream in) throws CompilationFailedException {
        return this.evaluate(in, this.generateScriptName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(InputStream in, String fileName) throws CompilationFailedException {
        Script script = null;
        try {
            script = this.parse(in, fileName);
            Object object = script.run();
            return object;
        }
        finally {
            if (script != null) {
                InvokerHelper.removeClass(script.getClass());
            }
        }
    }

    public Script parse(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/shell");
            }
        });
        return this.parse(gcs);
    }

    private Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.loader.parseClass(codeSource, false);
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        return InvokerHelper.createScript(this.parseClass(codeSource), this.context);
    }

    public Script parse(File file) throws CompilationFailedException, IOException {
        return this.parse(new GroovyCodeSource(file));
    }

    public Script parse(String scriptText) throws CompilationFailedException {
        try {
            return this.parse(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), this.generateScriptName());
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Script parse(String scriptText, String fileName) throws CompilationFailedException {
        try {
            return this.parse(new ByteArrayInputStream(scriptText.getBytes(this.config.getSourceEncoding())), fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new CompilationFailedException(0, null, e);
        }
    }

    public Script parse(InputStream in) throws CompilationFailedException {
        return this.parse(in, this.generateScriptName());
    }

    protected synchronized String generateScriptName() {
        return "Script" + ++this.counter + ".groovy";
    }
}

