/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.IdScriptableObject;
import org.mozilla.nb.javascript.NativeArray;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;
import org.mozilla.nb.javascript.Undefined;

public class NativeObject
extends IdScriptableObject {
    static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = "Object";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int Id___defineGetter__ = 9;
    private static final int Id___defineSetter__ = 10;
    private static final int Id___lookupGetter__ = 11;
    private static final int Id___lookupSetter__ = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.exportAsJSClass(12, scriptable, bl);
    }

    @Override
    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "hasOwnProperty";
                break;
            }
            case 6: {
                n2 = 1;
                string = "propertyIsEnumerable";
                break;
            }
            case 7: {
                n2 = 1;
                string = "isPrototypeOf";
                break;
            }
            case 8: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 9: {
                n2 = 2;
                string = "__defineGetter__";
                break;
            }
            case 10: {
                n2 = 2;
                string = "__defineSetter__";
                break;
            }
            case 11: {
                n2 = 1;
                string = "__lookupGetter__";
                break;
            }
            case 12: {
                n2 = 1;
                string = "__lookupSetter__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(OBJECT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 != null) {
                    return idFunctionObject.construct(context, scriptable, objectArray);
                }
                if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            }
            case 2: 
            case 3: {
                if (context.hasFeature(4)) {
                    String string = ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
                    int n2 = string.length();
                    if (n2 != 0 && string.charAt(0) == '(' && string.charAt(n2 - 1) == ')') {
                        string = string.substring(1, n2 - 1);
                    }
                    return string;
                }
                return ScriptRuntime.defaultObjectToString(scriptable2);
            }
            case 4: {
                return scriptable2;
            }
            case 5: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string == null) {
                        int n3 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n3, scriptable2);
                    } else {
                        bl = scriptable2.has(string, scriptable2);
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 6: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string == null) {
                        int n4 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n4, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n5 = scriptableObject.getAttributes(n4);
                            bl = (n5 & 2) == 0;
                        }
                    } else {
                        bl = scriptable2.has(string, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n6 = scriptableObject.getAttributes(string);
                            bl = (n6 & 2) == 0;
                        }
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 7: {
                boolean bl = false;
                if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
                    Scriptable scriptable3 = (Scriptable)objectArray[0];
                    do {
                        if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
                        bl = true;
                        break;
                    } while (scriptable3 != null);
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
            }
            case 9: 
            case 10: {
                if (objectArray.length < 2 || !(objectArray[1] instanceof Callable)) {
                    Object object = objectArray.length >= 2 ? objectArray[1] : Undefined.instance;
                    throw ScriptRuntime.notFunctionError(object);
                }
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", scriptable2.getClass().getName(), String.valueOf(objectArray[0]));
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                int n7 = string != null ? 0 : ScriptRuntime.lastIndexResult(context);
                Callable callable = (Callable)objectArray[1];
                boolean bl = n == 10;
                scriptableObject.setGetterOrSetter(string, n7, callable, bl);
                if (scriptableObject instanceof NativeArray) {
                    ((NativeArray)scriptableObject).setDenseOnly(false);
                }
                return Undefined.instance;
            }
            case 11: 
            case 12: {
                Scriptable scriptable4;
                Object object;
                boolean bl;
                if (objectArray.length < 1 || !(scriptable2 instanceof ScriptableObject)) {
                    return Undefined.instance;
                }
                ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                String string = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                int n8 = string != null ? 0 : ScriptRuntime.lastIndexResult(context);
                boolean bl2 = bl = n == 12;
                while ((object = scriptableObject.getGetterOrSetter(string, n8, bl)) == null && (scriptable4 = scriptableObject.getPrototype()) != null && scriptable4 instanceof ScriptableObject) {
                    scriptableObject = (ScriptableObject)scriptable4;
                }
                if (object != null) {
                    return object;
                }
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block14: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 7: {
                    string2 = "valueOf";
                    n = 4;
                    break;
                }
                case 8: {
                    char c = string.charAt(3);
                    if (c == 'o') {
                        string2 = "toSource";
                        n = 8;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 2;
                    break;
                }
                case 11: {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                case 13: {
                    string2 = "isPrototypeOf";
                    n = 7;
                    break;
                }
                case 14: {
                    char c = string.charAt(0);
                    if (c == 'h') {
                        string2 = "hasOwnProperty";
                        n = 5;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toLocaleString";
                    n = 3;
                    break;
                }
                case 16: {
                    char c = string.charAt(2);
                    if (c == 'd') {
                        c = string.charAt(8);
                        if (c == 'G') {
                            string2 = "__defineGetter__";
                            n = 9;
                            break;
                        }
                        if (c != 'S') break;
                        string2 = "__defineSetter__";
                        n = 10;
                        break;
                    }
                    if (c != 'l') break;
                    c = string.charAt(8);
                    if (c == 'G') {
                        string2 = "__lookupGetter__";
                        n = 11;
                        break;
                    }
                    if (c != 'S') break;
                    string2 = "__lookupSetter__";
                    n = 12;
                    break;
                }
                case 20: {
                    string2 = "propertyIsEnumerable";
                    n = 6;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block14;
            n = 0;
        }
        return n;
    }
}

