/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
JavadocForBinaryQueryImplementation {
    private final NbMavenProjectImpl project;
    private final HashMap<String, BinResult> map;

    public MavenForBinaryQueryImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        this.map = new HashMap();
        NbMavenProject.addPropertyChangeListener(proj, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName())) {
                    HashMap hashMap = MavenForBinaryQueryImpl.this.map;
                    synchronized (hashMap) {
                        for (BinResult res : MavenForBinaryQueryImpl.this.map.values()) {
                            if (Arrays.equals(res.getCached(), res.getRoots())) continue;
                            res.fireChanged();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        HashMap<String, BinResult> hashMap = this.map;
        synchronized (hashMap) {
            int result;
            BinResult toReturn = this.map.get(url.toString());
            if (toReturn != null) {
                return toReturn;
            }
            if (url.getProtocol().equals("jar") && this.checkURL(url) != -1) {
                toReturn = new BinResult(url);
            }
            if (url.getProtocol().equals("file") && ((result = this.checkURL(url)) == 1 || result == 0)) {
                toReturn = new BinResult(url);
            }
            if (toReturn != null) {
                this.map.put(url.toString(), toReturn);
            }
            return toReturn;
        }
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        if (this.checkURL(url) != -1) {
            return new DocResult(url);
        }
        return null;
    }

    private int checkURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                Build build;
                MavenProject proj = this.project.getOriginalMavenProject();
                if (proj != null && (build = proj.getBuild()) != null && build.getOutputDirectory() != null) {
                    File src = FileUtil.normalizeFile((File)new File(build.getOutputDirectory()));
                    URL srcUrl = src.toURI().toURL();
                    if (!srcUrl.toExternalForm().endsWith("/")) {
                        srcUrl = new URL(srcUrl.toExternalForm() + "/");
                    }
                    if (url.equals(srcUrl)) {
                        return 0;
                    }
                    File test = FileUtil.normalizeFile((File)new File(build.getTestOutputDirectory()));
                    URL testsrcUrl = test.toURI().toURL();
                    if (!testsrcUrl.toExternalForm().endsWith("/")) {
                        testsrcUrl = new URL(testsrcUrl.toExternalForm() + "/");
                    }
                    if (url.equals(testsrcUrl)) {
                        return 1;
                    }
                }
            }
            catch (MalformedURLException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            return -1;
        }
        if ("jar".equals(url.getProtocol()) && !Boolean.getBoolean("mevenide.projectLinksDisable")) {
            String path;
            int ret;
            URL binRoot = FileUtil.getArchiveFile((URL)url);
            File file = new File(URI.create(binRoot.toString()));
            String filepath = file.getAbsolutePath().replace('\\', '/');
            int n = ret = filepath.endsWith(path = this.project.getArtifactRelativeRepositoryPath()) ? 0 : -1;
            if (ret == -1) {
                path = this.project.getTestArtifactRelativeRepositoryPath();
                ret = filepath.endsWith(path) ? 1 : -1;
            }
            return ret;
        }
        return -1;
    }

    private FileObject[] getSrcRoot() {
        URI groovy;
        FileObject groovyfo;
        HashSet<FileObject> toReturn = new HashSet<FileObject>();
        List srcRoots = this.project.getOriginalMavenProject().getCompileSourceRoots();
        for (String item : srcRoots) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI[] genRoots = this.project.getGeneratedSourceRoots();
        for (int i = 0; i < genRoots.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(genRoots[i]);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI scala = this.project.getScalaDirectory(false);
        FileObject scalafo = FileUtilities.convertURItoFileObject(scala);
        if (scalafo != null) {
            toReturn.add(scalafo);
        }
        if ((groovyfo = FileUtilities.convertURItoFileObject(groovy = this.project.getGroovyDirectory(false))) != null) {
            toReturn.add(groovyfo);
        }
        URI[] res = this.project.getResources(false);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[toReturn.size()]);
    }

    private FileObject[] getTestSrcRoot() {
        URI groovy;
        FileObject groovyfo;
        HashSet<FileObject> toReturn = new HashSet<FileObject>();
        List srcRoots = this.project.getOriginalMavenProject().getTestCompileSourceRoots();
        for (String item : srcRoots) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI scala = this.project.getScalaDirectory(true);
        FileObject scalafo = FileUtilities.convertURItoFileObject(scala);
        if (scalafo != null) {
            toReturn.add(scalafo);
        }
        if ((groovyfo = FileUtilities.convertURItoFileObject(groovy = this.project.getGroovyDirectory(true))) != null) {
            toReturn.add(groovyfo);
        }
        URI[] res = this.project.getResources(true);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[toReturn.size()]);
    }

    private URL[] getJavadocRoot() {
        return new URL[0];
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private URL url;
        private URL[] results;
        private final List<ChangeListener> listeners;

        public DocResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }

        public URL[] getRoots() {
            this.results = MavenForBinaryQueryImpl.this.checkURL(this.url) != -1 ? MavenForBinaryQueryImpl.this.getJavadocRoot() : new URL[0];
            return this.results;
        }
    }

    private class BinResult
    implements SourceForBinaryQuery.Result {
        private URL url;
        private final List<ChangeListener> listeners;
        private FileObject[] results;
        private FileObject[] cached = null;

        public BinResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList<ChangeListener>();
        }

        public FileObject[] getRoots() {
            int xxx = MavenForBinaryQueryImpl.this.checkURL(this.url);
            this.results = xxx == 0 ? MavenForBinaryQueryImpl.this.getSrcRoot() : (xxx == 1 ? MavenForBinaryQueryImpl.this.getTestSrcRoot() : new FileObject[0]);
            this.cached = this.results;
            return this.results;
        }

        public FileObject[] getCached() {
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

