/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.elf.SectionHeader;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfDebugInfoSection
extends ElfSection {
    private List<CompilationUnit> compilationUnits;

    public DwarfDebugInfoSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
        reader.getSection(".rela.debug_info");
    }

    public DwarfDebugInfoSection(ElfReader reader, int sectionIdx, SectionHeader header, String sectionName) {
        super(reader, sectionIdx, header, sectionName);
    }

    public CompilationUnit getCompilationUnit(long unit_offset) throws IOException {
        for (CompilationUnit unit : this.getCompilationUnits()) {
            if (unit.unit_offset != unit_offset) continue;
            return unit;
        }
        return null;
    }

    public Iterator<CompilationUnit> iteratorCompilationUnits() throws IOException {
        if (this.compilationUnits != null) {
            return this.compilationUnits.iterator();
        }
        return new UnitIterator();
    }

    public List<CompilationUnit> getCompilationUnits() throws IOException {
        if (this.compilationUnits != null) {
            return this.compilationUnits;
        }
        this.compilationUnits = new ArrayList<CompilationUnit>();
        int cuOffset = 0;
        while ((long)cuOffset != this.header.sh_size) {
            ((DwarfReader)this.reader).seek(this.header.getSectionOffset() + (long)cuOffset);
            if (this.reader.readDWlen() == 0L) break;
            CompilationUnit unit = new CompilationUnit((DwarfReader)this.reader, this.header.getSectionOffset(), cuOffset);
            this.compilationUnits.add(unit);
            cuOffset = (int)((long)cuOffset + unit.getUnitTotalLength());
        }
        return this.compilationUnits;
    }

    @Override
    public void dump(PrintStream out) {
        try {
            for (CompilationUnit unit : this.getCompilationUnits()) {
                unit.dump(out);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitIterator
    implements Iterator<CompilationUnit> {
        private int cuOffset = 0;
        private CompilationUnit unit;

        public UnitIterator() throws IOException {
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.unit != null;
        }

        @Override
        public CompilationUnit next() {
            CompilationUnit res = this.unit;
            try {
                this.advance();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() throws IOException {
            this.unit = null;
            if ((long)this.cuOffset != DwarfDebugInfoSection.this.header.sh_size) {
                ((DwarfReader)DwarfDebugInfoSection.this.reader).seek(DwarfDebugInfoSection.this.header.getSectionOffset() + (long)this.cuOffset);
                if (DwarfDebugInfoSection.this.reader.readDWlen() == 0L) {
                    return;
                }
                this.unit = new CompilationUnit((DwarfReader)DwarfDebugInfoSection.this.reader, DwarfDebugInfoSection.this.header.getSectionOffset(), this.cuOffset);
                this.cuOffset = (int)((long)this.cuOffset + this.unit.getUnitTotalLength());
            }
        }
    }
}

