/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.ruby.debugger.model.VariablesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class WatchesModel
extends VariablesModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private WatchesListener listener;

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        this.checkListener(parent);
        if (parent == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches();
        }
        if (parent instanceof Watch) {
            RubyVariable var = this.resolveVariable((Watch)parent);
            return var == null ? new Object[]{} : super.getChildren(var, from, to);
        }
        return super.getChildren(parent, from, to);
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Watch) {
            RubyVariable var = this.resolveVariable((Watch)node);
            return var == null ? true : super.isLeaf(var);
        }
        return super.isLeaf(node);
    }

    @Override
    public int getChildrenCount(Object node) throws UnknownTypeException {
        this.checkListener(node);
        if (node == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches().length;
        }
        if (node instanceof Watch) {
            RubyVariable var = this.resolveVariable((Watch)node);
            return var == null ? 0 : super.getChildrenCount(var);
        }
        return super.getChildrenCount(node);
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return WatchesModel.getMessage("CTL_CallstackModel.Column.Name.Name");
        }
        if (node instanceof Watch) {
            return ((Watch)node).getExpression();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof Watch) {
            return WATCH;
        }
        return super.getIconBaseWithExtension(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return WatchesModel.getMessage("CTL_CallstackModel.Column.Name.Desc");
        }
        if (node instanceof Watch) {
            RubyVariable var = this.resolveVariable((Watch)node);
            return var == null ? WatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation") : super.getShortDescription(var);
        }
        return super.getShortDescription(node);
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof Watch) {
            RubyVariable var = this.resolveVariable((Watch)node);
            if (var == null) {
                return WatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation");
            }
            if (this.isWatchColumn(columnID)) {
                return super.getValueAt(var, "LocalsValue");
            }
            if (this.isWatchTypeColumn(columnID)) {
                return super.getValueAt(var, "LocalsType");
            }
        } else {
            if (this.isWatchColumn(columnID)) {
                return super.getValueAt(node, "LocalsValue");
            }
            if (this.isWatchTypeColumn(columnID)) {
                return super.getValueAt(node, "LocalsType");
            }
        }
        throw new UnknownTypeException(node);
    }

    private boolean isWatchColumn(String columnID) {
        return "WatchValue".equals(columnID) || "LocalsValue".equals(columnID);
    }

    private boolean isWatchTypeColumn(String columnID) {
        return "WatchType".equals(columnID) || "LocalsType".equals(columnID);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    private synchronized void checkListener(Object node) {
        if (this.listener == null && (node == "Root" || node instanceof Watch)) {
            this.listener = new WatchesListener(this);
        }
    }

    private void fireWatchPropertyChanged(Watch watch, String propertyName) {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
        }
    }

    private RubyVariable resolveVariable(Watch watch) {
        String expr = watch.getExpression();
        return this.rubySession.inspectExpression(expr);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(WatchesModel.class, (String)key);
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<WatchesModel> modelRef;

        public WatchesListener(WatchesModel watchesModel) {
            Watch[] watches;
            this.modelRef = new WeakReference<WatchesModel>(watchesModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesModel getModel() {
            WatchesModel model = (WatchesModel)this.modelRef.get();
            if (model == null) {
                Watch[] watches;
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
                    watch.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return model;
        }

        public void watchAdded(Watch watch) {
            WatchesModel model = this.getModel();
            if (model == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            model.fireChanges();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel model = this.getModel();
            if (model == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            model.fireChanges();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WatchesModel model = this.getModel();
            if (model == null) {
                return;
            }
            if (!(evt.getSource() instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            model.fireWatchPropertyChanged(w, evt.getPropertyName());
        }
    }
}

