/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class CreateTestsAction
extends NodeAction {
    private static final long serialVersionUID = 952382987542628824L;
    private static final Logger LOGGER = Logger.getLogger(CreateTestsAction.class.getName());
    private static final String REQUIRE_ONCE_TPL = "require_once '%s';";
    private static final ExecutionDescriptor EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(false).frontWindow(false);
    private static final RequestProcessor RP = new RequestProcessor("Generate PHP Unit tests", 1);
    static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            Runnable toRun = RUNNABLES.poll();
            while (toRun != null) {
                toRun.run();
                toRun = RUNNABLES.poll();
            }
        }
    }, true);

    public CreateTestsAction() {
        this.putValue("noIconInMenu", true);
    }

    public boolean asynchronous() {
        return true;
    }

    protected void performAction(final Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return;
        }
        final PhpUnit phpUnit = CommandUtils.getPhpUnit(true);
        if (phpUnit == null) {
            return;
        }
        final PhpProject phpProject = PhpProjectUtils.getPhpProject(activatedNodes[0]);
        assert (phpProject != null) : "PHP project must be found for " + activatedNodes[0];
        if (ProjectPropertiesSupport.getTestDirectory(phpProject, true) == null) {
            return;
        }
        if (!Utils.validatePhpUnitForProject(phpUnit, phpProject)) {
            return;
        }
        RUNNABLES.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreatingTests"));
                handle.start();
                try {
                    LifecycleManager.getDefault().saveAll();
                    CreateTestsAction.this.generateTests(activatedNodes, phpUnit, phpProject);
                }
                finally {
                    handle.finish();
                }
            }
        });
        TASK.schedule(0);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        PhpProject onlyOneProjectAllowed = null;
        for (Node node : activatedNodes) {
            FileObject fileObj = CommandUtils.getFileObject(node);
            if (fileObj == null) {
                return false;
            }
            if (fileObj.isData() && !FileUtils.isPhpFile((FileObject)fileObj)) {
                return false;
            }
            PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObj);
            if (phpProject == null) {
                return false;
            }
            if (onlyOneProjectAllowed == null) {
                onlyOneProjectAllowed = phpProject;
            } else if (!onlyOneProjectAllowed.equals(phpProject)) {
                return false;
            }
            if (CommandUtils.isUnderSources(phpProject, fileObj) && !CommandUtils.isUnderTests(phpProject, fileObj, false)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreateTests");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    void generateTests(Node[] activatedNodes, final PhpUnit phpUnit, final PhpProject phpProject) {
        assert (phpProject != null);
        final List<FileObject> files = CommandUtils.getFileObjects(activatedNodes);
        assert (!files.isEmpty()) : "No files for tests?!";
        final HashSet proceeded = new HashSet();
        final HashSet failed = new HashSet();
        final HashSet toOpen = new HashSet();
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PhpVisibilityQuery phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
                    for (FileObject fo : files) {
                        CreateTestsAction.this.generateTest(phpUnit, phpProject, phpVisibilityQuery, fo, proceeded, failed, toOpen);
                        Enumeration children = fo.getChildren(true);
                        while (children.hasMoreElements()) {
                            CreateTestsAction.this.generateTest(phpUnit, phpProject, phpVisibilityQuery, (FileObject)children.nextElement(), proceeded, failed, toOpen);
                        }
                    }
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    UiUtils.processExecutionException((ExecutionException)ex);
                }
            }
        });
        if (!failed.isEmpty()) {
            StringBuilder sb = new StringBuilder(50);
            for (File file : failed) {
                sb.append(file.getNameExt());
                sb.append("\n");
            }
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateTestsAction.class, (String)"MSG_TestNotGenerated", (Object)sb.toString()), 2));
        }
        HashSet<File> toRefresh = new HashSet<File>();
        for (File file : toOpen) {
            assert (file.isFile()) : "File must be given to open: " + file;
            toRefresh.add(file.getParentFile());
            try {
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                assert (fo != null) : "File object not found for " + file;
                assert (fo.isValid()) : "File object not valid for " + file;
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                ec.open();
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        if (!toRefresh.isEmpty()) {
            FileUtil.refreshFor((File[])toRefresh.toArray(new File[toRefresh.size()]));
        }
    }

    private void generateTest(PhpUnit phpUnit, PhpProject phpProject, PhpVisibilityQuery phpVisibilityQuery, FileObject sourceFo, Set<FileObject> proceeded, Set<FileObject> failed, Set<File> toOpen) throws ExecutionException {
        if (sourceFo.isFolder() || !FileUtils.isPhpFile((FileObject)sourceFo) || proceeded.contains(sourceFo) || CommandUtils.isUnderTests(phpProject, sourceFo, false) || CommandUtils.isUnderSelenium(phpProject, sourceFo, false) || !PhpProjectUtils.isVisible(phpVisibilityQuery, sourceFo)) {
            return;
        }
        proceeded.add(sourceFo);
        PhpUnit.ConfigFiles configFiles = PhpUnit.getConfigFiles(phpProject, false);
        String paramSkeleton = PhpUnit.hasValidVersion(phpUnit) ? "--skeleton-test" : "--skeleton";
        File sourceFile = FileUtil.toFile((FileObject)sourceFo);
        File parent = FileUtil.toFile((FileObject)sourceFo.getParent());
        File workingDirectory = phpUnit.getWorkingDirectory(configFiles, parent);
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection classes = editorSupport.getClasses(sourceFo);
        if (classes.isEmpty()) {
            this.generateSkeleton(phpUnit, configFiles, sourceFo.getName(), sourceFo, workingDirectory, paramSkeleton);
            failed.add(sourceFo);
            return;
        }
        for (PhpClass phpClass : classes) {
            String className = phpClass.getName();
            File testFile = this.getTestFile(phpProject, sourceFo, className);
            if (testFile.isFile()) {
                toOpen.add(testFile);
                continue;
            }
            File generatedFile = this.getGeneratedFile(className, parent);
            Future<Integer> result = this.generateSkeleton(phpUnit, configFiles, phpClass.getFullyQualifiedName(), sourceFo, workingDirectory, paramSkeleton);
            try {
                if (result.get() != 0) {
                    failed.add(sourceFo);
                    continue;
                }
                File moved = this.moveAndAdjustGeneratedFile(generatedFile, testFile, sourceFile);
                if (moved == null) {
                    failed.add(sourceFo);
                    continue;
                }
                toOpen.add(moved);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    private Future<Integer> generateSkeleton(PhpUnit phpUnit, PhpUnit.ConfigFiles configFiles, String className, FileObject sourceFo, File workingDirectory, String paramSkeleton) {
        ExternalProcessBuilder externalProcessBuilder = phpUnit.getProcessBuilder().workingDirectory(workingDirectory);
        if (configFiles.bootstrap != null && configFiles.useBootstrapForCreateTests) {
            externalProcessBuilder = externalProcessBuilder.addArgument("--bootstrap").addArgument(configFiles.bootstrap.getAbsolutePath());
        }
        if (configFiles.configuration != null) {
            externalProcessBuilder = externalProcessBuilder.addArgument("--configuration").addArgument(configFiles.configuration.getAbsolutePath());
        }
        if (className.startsWith("\\")) {
            className = className.substring(1);
        }
        externalProcessBuilder = externalProcessBuilder.addArgument(paramSkeleton).addArgument(className).addArgument(FileUtil.toFile((FileObject)sourceFo).getAbsolutePath());
        ExecutionService service = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)EXECUTION_DESCRIPTOR, (String)String.format("%s %s %s %s", phpUnit.getProgram(), paramSkeleton, className, sourceFo.getNameExt()));
        return service.run();
    }

    private File getGeneratedFile(String className, File parent) {
        return new File(parent, className + "Test.php");
    }

    private File getTestDirectory(PhpProject phpProject) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (testDirectory != null && testDirectory.isValid()) : "Valid folder for tests must be found for " + phpProject;
        return FileUtil.toFile((FileObject)testDirectory);
    }

    private File getTestFile(PhpProject project, FileObject source, String className) {
        assert (project != null);
        assert (source != null);
        FileObject sourcesDirectory = ProjectPropertiesSupport.getSourcesDirectory(project);
        String relativeSourcePath = FileUtil.getRelativePath((FileObject)sourcesDirectory, (FileObject)source.getParent());
        assert (relativeSourcePath != null) : String.format("Relative path must be found for sources %s and folder %s", sourcesDirectory, source.getParent());
        File relativeTestDirectory = new File(this.getTestDirectory(project), relativeSourcePath.replace('/', File.separatorChar));
        return new File(relativeTestDirectory, className + "Test.php");
    }

    private File moveAndAdjustGeneratedFile(File generatedFile, File testFile, File sourceFile) {
        assert (generatedFile.isFile()) : "Generated files must exist: " + generatedFile;
        assert (!testFile.exists()) : "Test file cannot exist: " + testFile;
        try {
            FileUtil.createFolder((File)testFile.getParentFile());
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
            return generatedFile;
        }
        testFile = this.adjustFileContent(generatedFile, testFile, sourceFile, PhpUnit.getRequireOnce(testFile, sourceFile));
        if (testFile == null) {
            return null;
        }
        assert (testFile.isFile()) : "Test file must exist: " + testFile;
        try {
            PhpProjectUtils.reformatFile(testFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot reformat file " + testFile, ex);
        }
        return testFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File adjustFileContent(File generatedFile, File testFile, File sourceFile, String requireOnce) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(generatedFile));
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(testFile));
                try {
                    String line;
                    boolean requireWritten = false;
                    String filename = sourceFile.getName();
                    while ((line = in.readLine()) != null) {
                        if (!requireWritten && PhpUnit.isRequireOnceSourceFile(line.trim(), filename)) {
                            out.write(String.format(REQUIRE_ONCE_TPL, requireOnce).replace("''.", ""));
                            requireWritten = true;
                        } else {
                            out.write(line);
                        }
                        out.newLine();
                    }
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        if (!generatedFile.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete generated file {0}", generatedFile);
        }
        return testFile;
    }
}

