/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChangeSupport;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileDownloadModel;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileUnit;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileUploadModel;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFilterTable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class TransferFilter
extends TransferFilesChooserPanel {
    private static final long serialVersionUID = -71871110754411L;
    final TransferFilterTable table;
    final TransferFileTableModel model;
    final TransferFilesChangeSupport filesChangeSupport = new TransferFilesChangeSupport(this);
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private volatile String filter = "";
    private PopupActionSupport popupActionsSupport;
    private static final RequestProcessor FILTER_PROCESSOR = new RequestProcessor("filter processor");
    private final RequestProcessor.Task searchTask = FILTER_PROCESSOR.create(new Runnable(){

        @Override
        public void run() {
            if (TransferFilter.this.filter != null) {
                int row = TransferFilter.this.getSelectedRow();
                final TransferFileUnit unit = TransferFilter.this.getModel().getUnitAtRow(row);
                final Map<Integer, Boolean> state = TransferFileTableModel.captureState(TransferFilter.this.model.getData());
                Runnable runAfterWards = new Runnable(){

                    @Override
                    public void run() {
                        if (unit != null) {
                            int row = TransferFilter.this.model.getRowForUnit(unit);
                            TransferFilter.this.restoreSelectedRow(row);
                        }
                        TransferFileTableModel.restoreState(TransferFilter.this.model.getData(), state, TransferFileTableModel.isMarkedAsDefault());
                        TransferFilter.this.refreshState();
                    }
                };
                TransferFilter.this.model.setFilter(TransferFilter.this.filter, runAfterWards);
            }
        }
    });
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JLabel lSearch;
    private JTextField tfSearch;

    private TransferFilter(TransferFilterTable table) {
        this.table = table;
        TableModel m = table.getModel();
        assert (m instanceof TransferFileTableModel) : m + " instanceof TransferFileTableModel.";
        this.model = (TransferFileTableModel)m;
        table.getSelectionModel().setSelectionMode(0);
        this.initComponents();
    }

    public static TransferFilter create(Set<TransferFile> transferFiles, TransferFilesChooser.TransferType transferType, long timestamp) {
        TransferFileTableModel model = null;
        switch (transferType) {
            case DOWNLOAD: {
                model = new TransferFileDownloadModel(TransferFilter.wrapTransferFiles(transferFiles, timestamp));
                break;
            }
            case UPLOAD: {
                model = new TransferFileUploadModel(TransferFilter.wrapTransferFiles(transferFiles, timestamp));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type: " + (Object)((Object)transferType));
            }
        }
        TransferFilter transferFilter = new TransferFilter(new TransferFilterTable(model));
        transferFilter.initPopup();
        transferFilter.listenOnSelection();
        transferFilter.listenOnUnitChanges();
        transferFilter.refreshState();
        return transferFilter;
    }

    public static TransferFilter getEmbeddableDownloadDialog(Set<TransferFile> transferFiles) {
        return TransferFilter.create(transferFiles, TransferFilesChooser.TransferType.DOWNLOAD, -1L);
    }

    private static List<TransferFileUnit> wrapTransferFiles(Collection<TransferFile> toTransfer, long timestamp) {
        ArrayList<TransferFileUnit> retval = new ArrayList<TransferFileUnit>(toTransfer.size());
        boolean selected = timestamp == -1L;
        for (TransferFile transferFile : toTransfer) {
            if (timestamp != -1L) {
                selected = transferFile.isFile() && transferFile.getTimestamp() > timestamp;
            }
            retval.add(new TransferFileUnit(transferFile, selected));
        }
        return retval;
    }

    private static Set<TransferFile> unwrapFileUnits(List<TransferFileUnit> fileUnits) {
        HashSet<TransferFile> retval = new HashSet<TransferFile>();
        for (TransferFileUnit fUnit : fileUnits) {
            retval.add(fUnit.getTransferFile());
        }
        return retval;
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransferFilter.this.table.requestFocusInWindow();
            }
        });
    }

    TransferFileTableModel getModel() {
        return this.model;
    }

    public String getHelpId() {
        return TransferFilter.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.focusTable();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    TransferFilter.this.tfSearch.selectAll();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TransferFilter.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        assert (this.dlForSearch != null);
        this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        this.dlForSearch = null;
        assert (this.flForSearch != null);
        this.tfSearch.removeFocusListener(this.flForSearch);
        this.flForSearch = null;
    }

    public void refreshState() {
        this.popupActionsSupport.tableDataChanged();
    }

    private void initPopup() {
        TabAction[] forPopup = null;
        switch (this.model.getType()) {
            case DOWNLOAD: 
            case UPLOAD: {
                forPopup = new TabAction[]{new CheckAllAction(), new UncheckAllAction(), new CheckAction()};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown model type: " + (Object)((Object)this.model.getType()));
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TransferFilter.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(forPopup);
        this.table.addMouseListener(this.popupActionsSupport);
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    TransferFilter.this.popupActionsSupport.rowChanged(-1);
                } else {
                    TransferFilter.this.popupActionsSupport.rowChanged(lsm.getMinSelectionIndex());
                }
            }
        });
    }

    private void listenOnUnitChanges() {
        this.addUpdateUnitListener(new TransferFileTableChangeListener(){

            @Override
            public void updateUnitsChanged() {
                TransferFilter.this.refreshState();
                TransferFilter.this.filesChangeSupport.fireSelectedFilesChange();
            }

            @Override
            public void filterChanged() {
                TransferFilter.this.model.fireTableDataChanged();
                TransferFilter.this.refreshState();
                TransferFilter.this.filesChangeSupport.fireFilterChange();
            }
        });
    }

    private void addUpdateUnitListener(TransferFileTableChangeListener l) {
        this.model.addUpdateUnitListener(l);
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent event) {
                    this.processUpdate(event);
                }

                @Override
                public void removeUpdate(DocumentEvent event) {
                    this.processUpdate(event);
                }

                @Override
                public void changedUpdate(DocumentEvent event) {
                    this.processUpdate(event);
                }

                private void processUpdate(DocumentEvent event) {
                    TransferFilter.this.filter = TransferFilter.this.tfSearch.getText().trim();
                    TransferFilter.this.searchTask.schedule(350);
                }
            };
        }
        return this.dlForSearch;
    }

    @Override
    public void addChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.filesChangeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.filesChangeSupport.removeChangeListener(listener);
    }

    @Override
    public Set<TransferFile> getSelectedFiles() {
        return TransferFilter.unwrapFileUnits(this.getModel().getMarkedUnits());
    }

    @Override
    public TransferFilesChooserPanel getEmbeddablePanel() {
        return this;
    }

    @Override
    public boolean hasAnyTransferableFiles() {
        return !TransferFilter.unwrapFileUnits(this.getModel().getMarkedUnits()).isEmpty();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = this.table;
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.setFocusTraversalPolicy(null);
        this.jTable1.setModel(this.table.getModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleName"));
        this.jTable1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jTable1.AccessibleContext.accessibleDescription"));
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(TransferFilter.class, (String)"lSearch1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(175, Short.MAX_VALUE).addComponent(this.lSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch, -2, 114, -2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 344, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 197, Short.MAX_VALUE)));
        this.jScrollPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleName"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.jScrollPane1.AccessibleContext.accessibleDescription"));
        this.lSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.lSearch.AccessibleContext.accessibleName"));
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"ACD_Search"));
        this.tfSearch.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleName"));
        this.tfSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.tfSearch.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferFilter.class, (String)"TransferFilter.AccessibleContext.accessibleDescription"));
    }

    private void showPopup(Point e, Component invoker) {
        int row = this.table.rowAtPoint(e);
        if (row >= 0) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
            JPopupMenu popup = this.popupActionsSupport.createPopup();
            if (popup.getComponentCount() > 0) {
                popup.show(invoker, e.x, e.y);
            }
        }
    }

    int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int row) {
        if (row < 0) {
            row = 0;
        }
        int rowCount = this.table.getRowCount();
        for (int temp = row; temp >= 0; --temp) {
            if (temp >= rowCount || temp <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(temp, temp);
            break;
        }
    }

    static String textForKey(String key) {
        JButton jb = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jb, (String)NbBundle.getMessage(TransferFilter.class, (String)key));
        return jb.getText();
    }

    static int mnemonicForKey(String key) {
        JButton jb = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jb, (String)NbBundle.getMessage(TransferFilter.class, (String)key));
        return jb.getMnemonic();
    }

    private class CheckAction
    extends RowTabAction {
        private static final long serialVersionUID = 3205317962231792782L;

        public CheckAction() {
            super("FileConfirmationPane_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        @Override
        public void performerImpl(TransferFileUnit unit) {
            int row = TransferFilter.this.getSelectedRow();
            if (unit != null && unit.canBeMarked()) {
                unit.setMarked(!unit.isMarked());
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(TransferFileUnit unit) {
            return unit.canBeMarked();
        }

        @Override
        protected String getContextName(TransferFileUnit unit) {
            return this.getActionName();
        }

        @Override
        protected boolean isVisible(TransferFileUnit unit) {
            return false;
        }

        @Override
        protected boolean isVisible(int row) {
            return false;
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        private static final long serialVersionUID = -2771565736665639L;

        public CheckAllAction() {
            super("FileConfirmationPane_CheckAllAction", "Check");
        }

        @Override
        public void performerImpl(TransferFileUnit notUsed) {
            int row = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> allUnits = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit tfu : allUnits) {
                if (tfu.isMarked() || !tfu.canBeMarked()) continue;
                tfu.setMarked(true);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(TransferFileUnit unit) {
            return true;
        }

        @Override
        protected String getContextName(TransferFileUnit unit) {
            return this.getActionName();
        }
    }

    private class UncheckAllAction
    extends RowTabAction {
        private static final long serialVersionUID = -1506415995282022116L;

        public UncheckAllAction() {
            super("FileConfirmationPane_UncheckAllAction", "Uncheck");
        }

        @Override
        public void performerImpl(TransferFileUnit notUsed) {
            int row = TransferFilter.this.getSelectedRow();
            List<TransferFileUnit> allUnits = TransferFilter.this.model.getVisibleFileUnits();
            for (TransferFileUnit tfu : allUnits) {
                if (!tfu.isMarked() || !tfu.canBeMarked()) continue;
                tfu.setMarked(false);
            }
            TransferFilter.this.model.fireTableDataChanged();
            TransferFilter.this.restoreSelectedRow(row);
        }

        @Override
        protected boolean isEnabled(TransferFileUnit unit) {
            return true;
        }

        @Override
        protected String getContextName(TransferFileUnit unit) {
            return this.getActionName();
        }
    }

    private abstract class RowTabAction
    extends TabAction {
        private volatile TransferFileUnit unit;
        private volatile int row;

        public RowTabAction(String nameKey, String actionCategoryKey) {
            super(nameKey, actionCategoryKey);
        }

        public RowTabAction(String nameKey, KeyStroke accelerator, String actionCategoryKey) {
            super(nameKey, accelerator, actionCategoryKey);
        }

        public void unitChanged(int row, TransferFileUnit unit) {
            this.unit = unit;
            this.row = row;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.unit != null ? this.isVisible(this.unit) : this.isVisible(this.row);
        }

        private void unitChanged() {
            if (this.unit != null) {
                this.setEnabled(this.isEnabled(this.unit));
                this.setContextName(this.getContextName(this.unit));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<TransferFileUnit> units) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.unit);
            TransferFilter.this.model.fireUpdataUnitChange();
        }

        protected boolean isVisible(TransferFileUnit unit) {
            return unit != null;
        }

        protected boolean isVisible(int row) {
            return false;
        }

        public abstract void performerImpl(TransferFileUnit var1);

        protected abstract boolean isEnabled(TransferFileUnit var1);

        protected boolean isEnabled(int row) {
            return false;
        }

        protected abstract String getContextName(TransferFileUnit var1);

        protected String getContextName(int row) {
            return this.getActionName();
        }
    }

    private abstract class TabAction
    extends AbstractAction {
        private final String name;
        private final String actionCategory;

        public TabAction(String nameKey, String actionCategoryKey) {
            super(TransferFilter.textForKey(nameKey));
            this.actionCategory = actionCategoryKey;
            this.putValue("MnemonicKey", TransferFilter.mnemonicForKey(nameKey));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(TransferFilter.this.table);
        }

        public TabAction(String key, KeyStroke accelerator, String actionCategoryKey) {
            this(key, actionCategoryKey);
            this.putValue("AcceleratorKey", accelerator);
            this.putIntoActionMap(transferFilter.table);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String name) {
            this.putValue("Name", name);
        }

        public final void putIntoActionMap(JComponent component) {
            KeyStroke ks = (KeyStroke)this.getValue("AcceleratorKey");
            Object key = this.getValue("Name");
            if (ks == null) {
                ks = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 18);
            }
            if (ks != null && key != null) {
                component.getInputMap(0).put(ks, key);
                component.getActionMap().put(key, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.performerImpl();
        }

        public void tableDataChanged() {
            this.tableDataChanged(TransferFilter.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<TransferFileUnit> units) {
            this.setEnabled(units.size() > 0);
        }

        public abstract void performerImpl();
    }

    private final class PopupActionSupport
    extends MouseAdapter {
        private final TabAction[] actions;

        PopupActionSupport(TabAction[] actions) {
            this.actions = actions;
        }

        void rowChanged(int row) {
            TransferFileUnit u = null;
            if (row > -1) {
                u = TransferFilter.this.model.getUnitAtRow(row);
            }
            for (TabAction action : this.actions) {
                assert (action instanceof RowTabAction) : "Need RowTabAction and not " + action.getClass().getName();
                RowTabAction rowAction = (RowTabAction)action;
                rowAction.unitChanged(row, u);
            }
        }

        void tableDataChanged() {
            List<TransferFileUnit> units = TransferFilter.this.model.getMarkedUnits();
            for (TabAction action : this.actions) {
                action.tableDataChanged(units);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu popup = new JPopupMenu();
            HashSet<String> categories2 = new HashSet<String>(this.actions.length);
            ArrayList<String> categories = new ArrayList<String>(this.actions.length);
            for (TabAction action : this.actions) {
                String categoryName = action.getActionCategory();
                if (!categories2.add(categoryName)) continue;
                categories.add(categoryName);
            }
            for (String categoryName : categories) {
                boolean addSeparator = popup.getSubElements().length > 0;
                for (TabAction action : this.actions) {
                    String actionCategory = action.getActionCategory();
                    if ((categoryName == null || !categoryName.equals(actionCategory)) && (categoryName != null || actionCategory != null)) continue;
                    assert (action instanceof RowTabAction) : "Need RowTabAction and not " + action.getClass().getName();
                    RowTabAction rowAction = (RowTabAction)action;
                    if (!rowAction.isVisible()) continue;
                    if (addSeparator) {
                        addSeparator = false;
                        popup.addSeparator();
                    }
                    popup.add(new JMenuItem(action));
                }
            }
            return popup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private boolean maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TransferFilter.this.focusTable();
                TransferFilter.this.showPopup(e.getPoint(), e.getComponent());
                return true;
            }
            return false;
        }
    }
}

