/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpPreferences;

public final class ProjectSettings {
    private static final String PROJECT_PREFERENCES_PATH = "projects";
    private static final String LAST_UPLOAD = "lastUpload";
    private static final String LAST_DONWLOAD = "lastDownload";
    private static final String DEBUG_URLS = "debugUrls";
    private static final String DEBUG_URLS_DELIMITER = "??NB??";
    private static final int DEBUG_URLS_LIMIT = 10;

    private ProjectSettings() {
    }

    private static Preferences getPreferences(Project project) {
        return PhpPreferences.getPreferences(false).node(PROJECT_PREFERENCES_PATH).node(ProjectUtils.getInformation((Project)project).getName());
    }

    public static long getLastUpload(Project project) {
        return ProjectSettings.getPreferences(project).getLong(LAST_UPLOAD, -1L);
    }

    public static void setLastUpload(Project project, long timestamp) {
        ProjectSettings.getPreferences(project).putLong(LAST_UPLOAD, timestamp);
    }

    public static void resetLastUpload(Project project) {
        ProjectSettings.setLastUpload(project, -1L);
    }

    public static long getLastDownload(Project project) {
        return ProjectSettings.getPreferences(project).getLong(LAST_DONWLOAD, -1L);
    }

    public static void setLastDownload(Project project, long timestamp) {
        ProjectSettings.getPreferences(project).putLong(LAST_DONWLOAD, timestamp);
    }

    public static void resetLastDownload(Project project) {
        ProjectSettings.setLastDownload(project, -1L);
    }

    public static List<String> getDebugUrls(Project project) {
        return StringUtils.explode((String)ProjectSettings.getPreferences(project).get(DEBUG_URLS, null), (String)DEBUG_URLS_DELIMITER);
    }

    public static void setDebugUrls(Project project, List<String> debugUrls) {
        if (debugUrls.size() > 10) {
            debugUrls = debugUrls.subList(0, 10);
        }
        ProjectSettings.getPreferences(project).put(DEBUG_URLS, StringUtils.implode(debugUrls, (String)DEBUG_URLS_DELIMITER));
    }
}

