/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;

class FortranDiffLinkedList {
    private LinkedList<FortranReformatter.Diff> storage = new LinkedList();

    FortranDiffLinkedList() {
    }

    FortranReformatter.Diff addFirst(int start, int end, int newLines, int spaces, boolean isIndent) {
        FortranReformatter.Diff diff = new FortranReformatter.Diff(start, end, newLines, spaces, isIndent);
        this.storage.add(this.getIndex(start, end), diff);
        return diff;
    }

    private int getIndex(int start, int end) {
        int res = 0;
        Iterator it = this.storage.iterator();
        while (it.hasNext()) {
            FortranReformatter.Diff diff = (FortranReformatter.Diff)it.next();
            if (diff.getStartOffset() <= start) {
                if (diff.getStartOffset() != start || diff.getEndOffset() != end) break;
                it.remove();
                break;
            }
            ++res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiffResult getDiffs(FortranExtendedTokenSequence ts, int shift) {
        int end;
        int start;
        if (shift != 0) {
            int index = ts.index();
            try {
                if (shift > 0) {
                    while (ts.moveNext() && --shift != 0) {
                    }
                } else {
                    while (ts.movePrevious() && ++shift != 0) {
                    }
                }
                start = ts.offset();
                end = ts.offset() + ts.token().length();
            }
            finally {
                ts.moveIndex(index);
                ts.moveNext();
            }
        } else {
            start = ts.offset();
            end = ts.offset() + ts.token().length();
        }
        return this.getDiffs(start, end);
    }

    DiffResult getDiffs(int start, int end) {
        DiffResult result = null;
        for (FortranReformatter.Diff diff : this.storage) {
            if (diff.getStartOffset() == start) {
                if (diff.getEndOffset() == end) {
                    if (result == null) {
                        result = new DiffResult();
                    }
                    result.replace = diff;
                } else {
                    if (result == null) {
                        result = new DiffResult();
                    }
                    result.before = diff;
                }
            } else if (diff.getEndOffset() == end) {
                if (result == null) {
                    result = new DiffResult();
                }
                result.after = diff;
            }
            if (diff.getEndOffset() >= start) continue;
            return result;
        }
        return result;
    }

    FortranReformatter.Diff getFirst() {
        if (this.storage.isEmpty()) {
            return null;
        }
        return this.storage.getFirst();
    }

    LinkedList<FortranReformatter.Diff> getStorage() {
        return this.storage;
    }

    static class DiffResult {
        FortranReformatter.Diff before;
        FortranReformatter.Diff replace;
        FortranReformatter.Diff after;

        DiffResult() {
        }
    }
}

