/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.dependency.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class AddDependencyUI
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private final JButton addButton;
    private JScrollPane jScrollPane1;
    private JLabel lblDescription;

    public AddDependencyUI(String string) {
        this.initComponents();
        this.lblDescription.setText(NbBundle.getMessage(AddDependencyUI.class, (String)"LBL_Description", (Object)string));
        this.addButton = new JButton(NbBundle.getMessage(AddDependencyUI.class, (String)"BTN_Add"));
        this.addButton.setEnabled(false);
        final List<Project> list = this.getOpenProjects();
        Children.Keys<Project> keys = new Children.Keys<Project>(){

            protected Node[] createNodes(Project project) {
                return new Node[]{new OpenProjectNode(project)};
            }

            protected void addNotify() {
                super.addNotify();
                this.setKeys(list);
            }
        };
        AbstractNode abstractNode = new AbstractNode((Children)keys){

            public Image getIcon(int n) {
                return NodeUtils.getTreeFolderIcon((boolean)false);
            }

            public Image getOpenedIcon(int n) {
                return NodeUtils.getTreeFolderIcon((boolean)true);
            }
        };
        abstractNode.setDisplayName(NbBundle.getMessage(AddDependencyUI.class, (String)"LBL_OpenProjects"));
        this.explorerManager.setRootContext((Node)abstractNode);
        BeanTreeView beanTreeView = (BeanTreeView)this.jScrollPane1;
        beanTreeView.setPopupAllowed(false);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    Node[] nodeArray = AddDependencyUI.this.explorerManager.getSelectedNodes();
                    boolean bl = false;
                    for (Node node : nodeArray) {
                        if (!(node instanceof OpenProjectNode)) continue;
                        bl = true;
                        break;
                    }
                    AddDependencyUI.this.addButton.setEnabled(bl);
                }
            }
        });
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.lblDescription = new JLabel();
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.lblDescription.setText(NbBundle.getMessage(AddDependencyUI.class, (String)"LBL_Description"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 330, Short.MAX_VALUE).add(1, (Component)this.lblDescription, -1, 330, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblDescription).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 369, Short.MAX_VALUE)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public List<Project> getSelectedMavenProjects() {
        Node[] nodeArray;
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (Node node : nodeArray = this.explorerManager.getSelectedNodes()) {
            if (!(node instanceof OpenProjectNode)) continue;
            OpenProjectNode openProjectNode = (OpenProjectNode)node;
            arrayList.add(openProjectNode.project);
        }
        return arrayList;
    }

    public List<Project> getOpenProjects() {
        Project[] projectArray;
        ArrayList<Project> arrayList = new ArrayList<Project>();
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject == null) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    public static class OpenProjectNode
    extends AbstractNode {
        private Project project;
        private ProjectInformation pi;

        public OpenProjectNode(Project project) {
            super(Children.LEAF);
            this.project = project;
            this.pi = ProjectUtils.getInformation((Project)project);
        }

        public Image getIcon(int n) {
            return ImageUtilities.icon2Image((Icon)this.pi.getIcon());
        }

        public String getDisplayName() {
            return this.pi.getDisplayName();
        }
    }
}

