/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.pojo;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hibernate.mapping.Property;

public class SkipBackRefPropertyIterator
implements Iterator {
    private Iterator delegate;
    private Property backLog;

    SkipBackRefPropertyIterator(Iterator iterator) {
        this.delegate = iterator;
    }

    public boolean hasNext() {
        if (this.backLog != null) {
            return true;
        }
        if (this.delegate.hasNext()) {
            Property nextProperty = (Property)this.delegate.next();
            while (nextProperty.isBackRef() && this.delegate.hasNext()) {
                nextProperty = (Property)this.delegate.next();
            }
            if (!nextProperty.isBackRef()) {
                this.backLog = nextProperty;
                return true;
            }
        }
        return false;
    }

    public Object next() {
        if (this.backLog != null) {
            Property p = this.backLog;
            this.backLog = null;
            return p;
        }
        Property nextProperty = (Property)this.delegate.next();
        while (nextProperty.isBackRef() && this.delegate.hasNext()) {
            nextProperty = (Property)this.delegate.next();
        }
        if (nextProperty.isBackRef()) {
            throw new NoSuchElementException();
        }
        return nextProperty;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() not allowed");
    }
}

