/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticUnresolved;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.generated.CPPParser;
import org.openide.util.Exceptions;

public class Diagnostic {
    private static int STATISTICS_LEVEL = Integer.getInteger("cnd.modelimpl.stat.level", 0);
    private static DiagnosticUnresolved diagnosticUnresolved = null;
    private static final int step = 4;
    private static StringBuilder indentBuffer = new StringBuilder();
    private static FileStatistics curFileHandler = new FileStatistics(null);

    private Diagnostic() {
    }

    public static int getStatisticsLevel() {
        return STATISTICS_LEVEL;
    }

    public static void setStatisticsLevel(int n) {
        STATISTICS_LEVEL = n;
    }

    public static boolean needStatistics() {
        return STATISTICS_LEVEL > 0;
    }

    public static void indent() {
        Diagnostic.setupIndentBuffer(indentBuffer.length() + 4);
    }

    public static void unindent() {
        Diagnostic.setupIndentBuffer(indentBuffer.length() - 4);
    }

    private static void setupIndentBuffer(int n) {
        if (n <= 0) {
            indentBuffer.setLength(0);
        } else {
            indentBuffer.setLength(n);
            for (int i = 0; i < n; ++i) {
                indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public static void trace(PrintStream printStream, Object object) {
        if (TraceFlags.DEBUG | Diagnostic.needStatistics()) {
            printStream.println(indentBuffer.toString() + object);
        }
    }

    public static void trace(Object object) {
        Diagnostic.trace(System.err, object);
    }

    public static void traceStack(String string) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace(string);
            StringWriter stringWriter = new StringWriter();
            new Exception(string).printStackTrace(new PrintWriter(stringWriter));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.getBuffer().toString()));
            try {
                bufferedReader.readLine();
                bufferedReader.readLine();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    Diagnostic.trace(string2);
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    public static void printlnStack(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('\n');
        StringWriter stringWriter = new StringWriter();
        new Exception(string).printStackTrace(new PrintWriter(stringWriter));
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.getBuffer().toString()));
        try {
            bufferedReader.readLine();
            bufferedReader.readLine();
            int n2 = 0;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (n2 == 0) {
                    stringBuilder.append("  in thread " + Thread.currentThread().getName());
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                if (n2 <= n - 1) {
                    ++n2;
                    string2 = bufferedReader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        System.out.println(stringBuilder.toString());
    }

    public static synchronized void printToFile(String string, String string2, Object ... objectArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.printf(string2, objectArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
    }

    public static void traceThreads(String string) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace(string);
            Diagnostic.trace("Threads are:");
            int n = Thread.activeCount();
            Thread[] threadArray = new Thread[n];
            Thread.enumerate(threadArray);
            for (int i = 0; i < n; ++i) {
                String string2 = threadArray[i].getName() + " " + threadArray[i].getPriority();
                if (threadArray[i] == Thread.currentThread()) {
                    string2 = string2 + " (current)";
                }
                Diagnostic.trace(string2);
            }
            Diagnostic.trace("");
        }
    }

    public static void initFileStatistics(String string) {
        curFileHandler.dispose();
        curFileHandler = null;
        curFileHandler = new FileStatistics(string);
    }

    public static void dumpFileStatistics(String string) throws FileNotFoundException {
        Diagnostic.dumpFileStatistics(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFileStatistics(String string, boolean bl) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string, bl), true);
        try {
            curFileHandler.dump(printStream);
        }
        finally {
            printStream.close();
        }
    }

    public static void onUnresolvedError(CharSequence[] charSequenceArray, CsmFile csmFile, int n) {
        if (STATISTICS_LEVEL > 0) {
            Diagnostic.getDiagnosticUnresolved().onUnresolved(charSequenceArray, csmFile, n);
        }
    }

    public static void dumpUnresolvedStatistics(String string, boolean bl) throws FileNotFoundException {
        Diagnostic.getDiagnosticUnresolved().dumpStatictics(string, bl);
    }

    private static synchronized DiagnosticUnresolved getDiagnosticUnresolved() {
        if (diagnosticUnresolved == null) {
            diagnosticUnresolved = new DiagnosticUnresolved(STATISTICS_LEVEL);
        }
        return diagnosticUnresolved;
    }

    public static void onLexerError(RecognitionException recognitionException) {
        curFileHandler.handleLexerError(recognitionException);
    }

    public static void onParserError(RecognitionException recognitionException) {
        curFileHandler.handleParserError(recognitionException);
    }

    public static void onError(Exception exception, String string) {
        curFileHandler.handleOtherError(exception, string);
    }

    public static void onInclude(String string, String string2, String string3) {
        curFileHandler.handleInclude(string, string2, string3, false);
    }

    public static void onRecurseInclude(String string, String string2) {
        curFileHandler.handleInclude(null, string2, string, true);
    }

    private static class FileStatistics {
        private Map<ExceptionWrapper, ExceptionWrapper> lexerProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<ExceptionWrapper, ExceptionWrapper> parserProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<ExceptionWrapper, ExceptionWrapper> otherProblems = new HashMap<ExceptionWrapper, ExceptionWrapper>();
        private Map<String, IncludeInfo> includes = new HashMap<String, IncludeInfo>();
        private ExceptionWrapper lastError = null;
        private ExceptionWrapper firstError = null;
        private String lastErrorMsg = null;
        private String handledFile;

        public FileStatistics(String string) {
            this.handledFile = string;
        }

        public void handleLexerError(RecognitionException recognitionException) {
            this.handleError(this.lexerProblems, new LexerExceptionWrapper(recognitionException), true);
        }

        public void handleParserError(RecognitionException recognitionException) {
            this.handleError(this.parserProblems, new ParserExceptionWrapper(recognitionException), true);
        }

        public void handleOtherError(Exception exception, String string) {
            this.handleError(this.otherProblems, new ExceptionWrapper(exception, string), false);
        }

        public void handleInclude(String string, String string2, String string3, boolean bl) {
            String string4;
            String string5 = string4 = string3 == null ? string : string3;
            assert (string4 != null) : "at least 'include' or 'resolvedIncludePath' must be specified";
            IncludeInfo includeInfo = this.includes.get(string4);
            if (includeInfo == null) {
                includeInfo = new IncludeInfo(string4, string3 == null);
                this.includes.put(string4, includeInfo);
            }
            includeInfo.add(string2, bl);
        }

        public void dispose() {
            this.handledFile = null;
            this.lastError = null;
            this.firstError = null;
            this.lastErrorMsg = null;
            this.lexerProblems.clear();
            this.parserProblems.clear();
            this.otherProblems.clear();
            this.includes.clear();
        }

        private boolean hasLexerProblems() {
            return this.lexerProblems.size() > 0;
        }

        private boolean hasParserProblems() {
            return this.parserProblems.size() > 0;
        }

        private boolean hasOtherProblems() {
            return this.otherProblems.size() > 0;
        }

        private boolean hasIncludeProblems() {
            for (IncludeInfo includeInfo : this.includes.values()) {
                if (!includeInfo.hasErrors()) continue;
                return true;
            }
            return false;
        }

        public void dump(PrintStream printStream) {
            if (this.lexerProblems.isEmpty() && this.parserProblems.isEmpty() && this.includes.isEmpty()) {
                Diagnostic.trace(printStream, "*** No errors found in file " + this.handledFile);
            } else {
                Diagnostic.trace(printStream, "*** Statistics of file " + this.handledFile);
                if (this.lastError != null) {
                    Diagnostic.trace(printStream, "****** First and last lexer/parser errors ******");
                    Diagnostic.indent();
                    Diagnostic.trace(printStream, "[FIRST ERROR MSG]: (" + this.firstError.getSourceName() + ")");
                    Diagnostic.trace(printStream, this.firstError.e.toString());
                    Diagnostic.trace(printStream, "[LAST ERROR MSG]: (" + this.lastError.getSourceName() + ")");
                    Diagnostic.trace(printStream, this.lastErrorMsg);
                    if (Diagnostic.getStatisticsLevel() > 1) {
                        Diagnostic.trace(printStream, "+++ More details +++ ");
                        if (this.lastError != this.firstError) {
                            Diagnostic.trace(printStream, "[FIRST ERROR] " + this.firstError);
                            Diagnostic.trace(printStream, "[LAST ERROR] " + this.lastError);
                        } else {
                            Diagnostic.trace(printStream, "[ERROR] " + this.lastError);
                        }
                    }
                    Diagnostic.unindent();
                }
                if (this.hasOtherProblems()) {
                    Diagnostic.trace(printStream, "****** All unclassified errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(printStream, this.otherProblems);
                    Diagnostic.unindent();
                }
                if (this.hasLexerProblems()) {
                    Diagnostic.trace(printStream, "****** All Lexer errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(printStream, this.lexerProblems);
                    Diagnostic.unindent();
                }
                if (this.hasParserProblems()) {
                    Diagnostic.trace(printStream, "****** All Parser errors ******");
                    Diagnostic.indent();
                    this.dumpExceptions(printStream, this.parserProblems);
                    Diagnostic.unindent();
                }
                if (Diagnostic.getStatisticsLevel() > 1 || this.hasIncludeProblems()) {
                    Diagnostic.trace(printStream, "****** Inclusions ******");
                    Diagnostic.indent();
                    this.dumpIncludes(printStream, this.includes);
                    Diagnostic.unindent();
                }
                Diagnostic.trace(printStream, "*** End of statistics for " + this.handledFile + '\n');
            }
        }

        private void handleError(Map<ExceptionWrapper, ExceptionWrapper> map, ExceptionWrapper exceptionWrapper, boolean bl) {
            assert (exceptionWrapper != null);
            assert (exceptionWrapper.getException() != null);
            ExceptionWrapper exceptionWrapper2 = map.get(exceptionWrapper);
            if (exceptionWrapper2 == null) {
                exceptionWrapper2 = exceptionWrapper;
                map.put(exceptionWrapper2, exceptionWrapper2);
            }
            exceptionWrapper2.add(exceptionWrapper.getException());
            if (bl) {
                this.lastError = exceptionWrapper2;
                this.lastErrorMsg = exceptionWrapper.e.toString();
                if (this.firstError == null) {
                    this.firstError = this.lastError;
                }
            }
        }

        private void dumpExceptions(PrintStream printStream, Map<ExceptionWrapper, ExceptionWrapper> map) {
            ArrayList<ExceptionWrapper> arrayList = new ArrayList<ExceptionWrapper>(map.keySet());
            Collections.sort(arrayList, ExceptionWrapper.COMPARATOR);
            for (ExceptionWrapper exceptionWrapper : arrayList) {
                Diagnostic.trace(printStream, exceptionWrapper);
            }
        }

        private void dumpIncludes(PrintStream printStream, Map<String, IncludeInfo> map) {
            ArrayList<IncludeInfo> arrayList = new ArrayList<IncludeInfo>(map.values());
            Collections.sort(arrayList, IncludeInfo.COMPARATOR);
            for (IncludeInfo includeInfo : arrayList) {
                if (Diagnostic.getStatisticsLevel() == 1 && !includeInfo.hasErrors()) break;
                Diagnostic.trace(printStream, includeInfo);
            }
        }

        private static class ParserExceptionWrapper
        extends ExceptionWrapper {
            ParserExceptionWrapper(RecognitionException recognitionException) {
                super((Exception)recognitionException, "Parser");
            }

            @Override
            protected boolean isStopElement(StackTraceElement stackTraceElement) {
                if (!stackTraceElement.getClassName().equals(CPPParser.class.getName())) {
                    return true;
                }
                return stackTraceElement.getMethodName().equals("translation_unit");
            }
        }

        private static class LexerExceptionWrapper
        extends ExceptionWrapper {
            LexerExceptionWrapper(RecognitionException recognitionException) {
                super((Exception)recognitionException, "Lexer");
            }

            @Override
            protected boolean isStopElement(StackTraceElement stackTraceElement) {
                if (!stackTraceElement.getClassName().equals("org.netbeans.modules.cnd.apt.impl.support.generated.APTLexer")) {
                    return true;
                }
                return stackTraceElement.getMethodName().equals("nextToken");
            }
        }

        private static class ExceptionWrapper {
            private static final int CKHECKED_STACK_DEPTH = 15;
            private Exception e;
            private Set<String> errorMessages = new HashSet<String>();
            private int counter = 0;
            private String source;
            static final Comparator<ExceptionWrapper> COMPARATOR = new Comparator<ExceptionWrapper>(){

                @Override
                public int compare(ExceptionWrapper exceptionWrapper, ExceptionWrapper exceptionWrapper2) {
                    if (exceptionWrapper == exceptionWrapper2) {
                        return 0;
                    }
                    if (exceptionWrapper.counter > exceptionWrapper2.counter) {
                        return -1;
                    }
                    if (exceptionWrapper.counter < exceptionWrapper2.counter) {
                        return 1;
                    }
                    String string = exceptionWrapper.e.toString();
                    String string2 = exceptionWrapper2.e.toString();
                    return string.compareTo(string2);
                }
            };

            ExceptionWrapper(Exception exception, String string) {
                this.e = exception;
                this.source = string;
            }

            public Exception getException() {
                return this.e;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof ExceptionWrapper)) {
                    return false;
                }
                ExceptionWrapper exceptionWrapper = (ExceptionWrapper)object;
                if (!exceptionWrapper.e.getClass().equals(this.e.getClass())) {
                    return false;
                }
                StackTraceElement[] stackTraceElementArray = this.e.getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = exceptionWrapper.e.getStackTrace();
                if (stackTraceElementArray != null) {
                    int n = Math.min(15, Math.min(stackTraceElementArray.length, stackTraceElementArray2.length));
                    for (int i = 0; i < n; ++i) {
                        StackTraceElement stackTraceElement = stackTraceElementArray[i];
                        StackTraceElement stackTraceElement2 = stackTraceElementArray2[i];
                        if (this.isStopElement(stackTraceElement) || exceptionWrapper.isStopElement(stackTraceElement2)) {
                            return true;
                        }
                        if (this.equals(stackTraceElement, stackTraceElement2)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            protected String getSourceName() {
                return this.source;
            }

            public String toString() {
                Object object;
                String string;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("===> [").append(this.counter).append("] similar ");
                stringBuilder.append(this.getSourceName()).append(" error(s) with the first :\n");
                stringBuilder.append(indentBuffer.toString()).append(this.e.toString());
                if (Diagnostic.getStatisticsLevel() > 2) {
                    string = indentBuffer.toString() + indentBuffer.toString() + indentBuffer.toString();
                    object = this.e.getStackTrace();
                    for (int i = 0; i < ((StackTraceElement[])object).length; ++i) {
                        stringBuilder.append("\n").append(string);
                        stringBuilder.append("at ").append(object[i]);
                    }
                }
                if (Diagnostic.getStatisticsLevel() > 1 && this.errorMessages.size() > 1) {
                    string = indentBuffer.toString() + indentBuffer.toString();
                    stringBuilder.append("\n").append(string);
                    stringBuilder.append("+++ all error messages:");
                    object = new ArrayList<String>(this.errorMessages);
                    Collections.sort(object);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        stringBuilder.append('\n').append(string).append(string2);
                    }
                }
                return stringBuilder.toString();
            }

            public int hashCode() {
                StackTraceElement[] stackTraceElementArray = this.e.getStackTrace();
                int n = stackTraceElementArray != null && stackTraceElementArray.length > 0 ? stackTraceElementArray[0].hashCode() : this.e.hashCode();
                return n;
            }

            protected boolean isStopElement(StackTraceElement stackTraceElement) {
                return false;
            }

            private boolean equals(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
                assert (stackTraceElement != null);
                assert (stackTraceElement2 != null);
                return stackTraceElement.equals(stackTraceElement2);
            }

            public void add(Exception exception) {
                ++this.counter;
                this.errorMessages.add(exception.toString());
            }
        }

        private static class IncludeInfo {
            private String include;
            private boolean failedInclusion;
            private int counter = 0;
            private Map<String, Integer> includedFrom = new HashMap<String, Integer>();
            private Set<String> recursionFrom = new HashSet<String>();
            static final Comparator<IncludeInfo> COMPARATOR = new Comparator<IncludeInfo>(){

                @Override
                public int compare(IncludeInfo includeInfo, IncludeInfo includeInfo2) {
                    if (includeInfo == includeInfo2) {
                        return 0;
                    }
                    if (includeInfo.failedInclusion != includeInfo2.failedInclusion) {
                        return includeInfo.failedInclusion ? -1 : 1;
                    }
                    if (includeInfo.recursionFrom.size() != includeInfo2.recursionFrom.size()) {
                        return includeInfo.recursionFrom.size() > includeInfo2.recursionFrom.size() ? -1 : 1;
                    }
                    if (includeInfo.counter != includeInfo2.counter) {
                        return includeInfo.counter > includeInfo2.counter ? -1 : 1;
                    }
                    return includeInfo.include.compareTo(includeInfo2.include);
                }
            };

            IncludeInfo(String string, boolean bl) {
                this.include = string;
                this.failedInclusion = bl;
            }

            void add(String string, boolean bl) {
                ++this.counter;
                Integer n = this.includedFrom.containsKey(string) ? this.includedFrom.get(string) : Integer.valueOf(0);
                this.includedFrom.put(string, n + 1);
                if (bl) {
                    this.recursionFrom.add(string);
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof IncludeInfo)) {
                    return false;
                }
                IncludeInfo includeInfo = (IncludeInfo)object;
                boolean bl = this.isFailedInclude() == includeInfo.isFailedInclude();
                return bl &= this.include.equals(includeInfo.include);
            }

            public int hashCode() {
                int n = this.include.hashCode() + 17 * (this.isFailedInclude() ? 0 : 1);
                return n;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("===> ").append(this.include);
                if (this.isFailedInclude()) {
                    stringBuilder.append(" (FAILED)");
                } else if (this.hasRecursionInclude()) {
                    stringBuilder.append(" (HAS RECURSION)");
                }
                stringBuilder.append(" included ");
                stringBuilder.append(this.counter).append(" time(s)");
                if (Diagnostic.getStatisticsLevel() == 1) {
                    if (this.isFailedInclude() || this.hasRecursionInclude()) {
                        String string;
                        stringBuilder.append("\n").append(indentBuffer.toString()).append(indentBuffer.toString());
                        if (this.hasRecursionInclude()) {
                            assert (this.recursionFrom.size() > 0);
                            assert (this.recursionFrom.iterator().hasNext());
                            string = this.recursionFrom.iterator().next();
                            stringBuilder.append(" [RECURSION] ");
                        } else {
                            assert (this.includedFrom.size() > 0);
                            assert (this.includedFrom.keySet().iterator().hasNext());
                            string = this.includedFrom.keySet().iterator().next();
                            stringBuilder.append(" where [").append(this.includedFrom.get(string)).append("] time(s) ");
                        }
                        stringBuilder.append("from ").append(string);
                    }
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>(this.includedFrom.keySet());
                    Collections.sort(arrayList);
                    for (String string : arrayList) {
                        stringBuilder.append("\n").append(indentBuffer.toString());
                        stringBuilder.append(indentBuffer.toString());
                        if (this.recursionFrom.contains(string)) {
                            stringBuilder.append(" [RECURSION] ");
                        } else {
                            stringBuilder.append(" [").append(this.includedFrom.get(string)).append("] ");
                        }
                        stringBuilder.append("from ").append(string);
                    }
                }
                return stringBuilder.toString();
            }

            public boolean isFailedInclude() {
                return this.failedInclusion;
            }

            public boolean hasRecursionInclude() {
                return !this.recursionFrom.isEmpty();
            }

            public boolean hasErrors() {
                return this.isFailedInclude() || this.hasRecursionInclude();
            }
        }
    }

    public static class StopWatch {
        private long time = 0L;
        private long lastStart;
        private boolean running;

        public StopWatch() {
            this(true);
        }

        public StopWatch(boolean bl) {
            if (bl) {
                this.start();
            }
        }

        public void start() {
            this.running = true;
            this.lastStart = System.currentTimeMillis();
        }

        public long stop() {
            this.running = false;
            this.time += System.currentTimeMillis() - this.lastStart;
            return this.time;
        }

        public long stopAndReport(String string) {
            long l = this.stop();
            this.report(string);
            return l;
        }

        public long report(String string) {
            System.err.println(' ' + string + ' ' + this.time + " ms");
            return this.time;
        }

        public boolean isRunning() {
            return this.running;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class ProjectStat {
        private static final int SLOW_FILE_NUMBER = Math.max(1, Integer.getInteger("cnd.modelimpl.slow.file.number", 5));
        private final ConcurrentMap<CsmUID<CsmProject>, SlowFilesCollection> projectStats = new ConcurrentHashMap<CsmUID<CsmProject>, SlowFilesCollection>();

        public void addParseFileStatistics(ProjectBase projectBase, FileImpl fileImpl, long l) {
            if (projectBase != null && !projectBase.isArtificial()) {
                SlowFilesCollection slowFilesCollection;
                CsmUID<CsmProject> csmUID = projectBase.getUID();
                SlowFilesCollection slowFilesCollection2 = (SlowFilesCollection)this.projectStats.get(csmUID);
                if (slowFilesCollection2 == null && csmUID != null && (slowFilesCollection = this.projectStats.putIfAbsent(csmUID, slowFilesCollection2 = new SlowFilesCollection())) != null) {
                    slowFilesCollection2 = slowFilesCollection;
                }
                if (slowFilesCollection2 != null) {
                    slowFilesCollection2.put(fileImpl, l);
                }
            }
        }

        public void traceProjectData(ProjectBase projectBase) {
            if (projectBase != null && !projectBase.isArtificial()) {
                SlowFilesCollection slowFilesCollection = (SlowFilesCollection)this.projectStats.get(projectBase.getUID());
                if (slowFilesCollection != null) {
                    System.err.printf("Slowest Files for %s are:\n%s", projectBase.getName(), slowFilesCollection.asString());
                    System.err.println();
                    System.err.flush();
                } else {
                    System.err.printf("No Slowest Files info for " + projectBase.getName(), new Object[0]);
                    System.err.println();
                    System.err.flush();
                }
            }
        }

        public void clear() {
            this.projectStats.clear();
        }

        private static final class SlowFilesCollection {
            private final LinkedList<Entry> times = new LinkedList();

            private SlowFilesCollection() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void put(FileImpl fileImpl, long l) {
                SlowFilesCollection slowFilesCollection = this;
                synchronized (slowFilesCollection) {
                    boolean bl;
                    ListIterator<Entry> listIterator = this.times.listIterator(this.times.size());
                    boolean bl2 = bl = !listIterator.hasPrevious();
                    while (listIterator.hasPrevious()) {
                        Entry entry = listIterator.previous();
                        if (entry.time < l) {
                            bl = true;
                            continue;
                        }
                        if (!bl) continue;
                        listIterator.add(new Entry(l, fileImpl.getAbsolutePath()));
                        break;
                    }
                    if (bl) {
                        this.times.addFirst(new Entry(l, fileImpl.getAbsolutePath()));
                    }
                    if (this.times.size() > SLOW_FILE_NUMBER) {
                        this.times.removeLast();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String asString() {
                StringBuilder stringBuilder = new StringBuilder();
                SlowFilesCollection slowFilesCollection = this;
                synchronized (slowFilesCollection) {
                    for (Entry entry : this.times) {
                        stringBuilder.append(entry).append('\n');
                    }
                }
                return stringBuilder.toString();
            }

            private static final class Entry {
                final long time;
                final CharSequence file;

                public Entry(long l, CharSequence charSequence) {
                    this.time = l;
                    this.file = charSequence;
                }

                public String toString() {
                    return " file=" + this.file + " " + this.time + " ms";
                }
            }
        }
    }
}

