/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeFileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.RequestProcessor;

public final class ProjectImpl
extends ProjectBase {
    private final Map<CsmFile, EditingTask> editedFiles = new HashMap<CsmFile, EditingTask>();
    private final NativeFileContainer nativeFiles = new NativeFileContainer();
    private static final RequestProcessor RP = new RequestProcessor("ProjectImpl RP", 50);

    private ProjectImpl(ModelImpl modelImpl, Object object, String string) {
        super(modelImpl, object, string);
    }

    public static ProjectImpl createInstance(ModelImpl modelImpl, String string, String string2) {
        return ProjectImpl.createInstance(modelImpl, (Object)string, string2);
    }

    public static ProjectImpl createInstance(ModelImpl modelImpl, NativeProject nativeProject, String string) {
        return ProjectImpl.createInstance(modelImpl, (Object)nativeProject, string);
    }

    private static ProjectImpl createInstance(ModelImpl modelImpl, Object object, String string) {
        ProjectBase projectBase = null;
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                projectBase = ProjectImpl.readInstance(modelImpl, object, string);
            }
            catch (Exception exception) {
                ProjectImpl.cleanRepository(object, false);
                DiagnosticExceptoins.register(exception);
            }
        }
        if (projectBase == null) {
            projectBase = new ProjectImpl(modelImpl, object, string);
        }
        return (ProjectImpl)projectBase;
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditStart(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        FileImpl fileImpl;
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditSTART " + fileBuffer.getFile().getName());
        }
        if ((fileImpl = this.createOrFindFileImpl(fileBuffer, nativeFileItem)) != null) {
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileBuffer);
            APTFileCacheManager.invalidate((APTFileBuffer)fileBuffer);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ProjectImpl.this.scheduleParseOnEditing(fileImpl);
                }
            };
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                if (TraceFlags.TRACE_182342_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditStart: edited file " + csmFile);
                    }
                    System.err.println("onFileEditStart: current file " + fileImpl);
                }
                fileImpl.setBuffer(fileBuffer);
                if (!this.editedFiles.containsKey(fileImpl)) {
                    this.editedFiles.put(fileImpl, new EditingTask(fileBuffer, changeListener));
                }
                this.scheduleParseOnEditing(fileImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        FileImpl fileImpl;
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditEND " + fileBuffer.getFile().getName());
        }
        if ((fileImpl = this.getFile(fileBuffer.getFile(), false)) != null) {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                Object object;
                if (TraceFlags.TRACE_182342_BUG) {
                    object = this.editedFiles.keySet().iterator();
                    while (object.hasNext()) {
                        CsmFile csmFile = (CsmFile)object.next();
                        System.err.println("onFileEditEnd: edited file " + csmFile);
                    }
                    System.err.println("onFileEditEnd: current file " + fileImpl);
                }
                if ((object = this.editedFiles.remove(fileImpl)) == null) {
                    return;
                }
                ((EditingTask)object).cancelTask();
                fileImpl.setBuffer(fileBuffer);
            }
        }
    }

    @Override
    public void onFilePropertyChanged(NativeFileItem nativeFileItem) {
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFilePropertyChanged " + nativeFileItem.getFile().getName());
        }
        DeepReparsingUtils.reparseOnPropertyChanged(nativeFileItem, (ProjectBase)this);
    }

    @Override
    public void onFilePropertyChanged(List<NativeFileItem> list) {
        if (list.size() > 0) {
            DeepReparsingUtils.reparseOnPropertyChanged(list, (ProjectBase)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(FileImpl fileImpl) {
        try {
            this.onFileRemovedImpl(fileImpl);
            if (fileImpl != null) {
                DeepReparsingUtils.reparseOnRemoved(fileImpl, (ProjectBase)this);
            }
        }
        finally {
            Notificator.instance().flush();
        }
    }

    @Override
    public void onFileImplRemoved(List<FileImpl> list) {
        for (FileImpl fileImpl : list) {
            this.onFileRemovedImpl(fileImpl);
        }
        DeepReparsingUtils.reparseOnRemoved(list, (ProjectBase)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl onFileRemovedImpl(FileImpl fileImpl) {
        CndFileUtils.clearFileExistenceCache();
        if (fileImpl != null) {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                EditingTask editingTask = this.editedFiles.remove(fileImpl);
                if (editingTask != null) {
                    editingTask.cancelTask();
                }
            }
            this.removeNativeFileItem(fileImpl.getUID());
            fileImpl.dispose();
            this.removeFile(fileImpl.getAbsolutePath());
            APTDriver.getInstance().invalidateAPT((APTFileBuffer)fileImpl.getBuffer());
            APTFileCacheManager.invalidate((APTFileBuffer)fileImpl.getBuffer());
            ParserQueue.instance().remove(fileImpl);
        }
        return fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<FileImpl> arrayList = new ArrayList<FileImpl>();
            for (NativeFileItem nativeFileItem : list) {
                File file = nativeFileItem.getFile();
                try {
                    FileImpl fileImpl = this.getFile(file, false);
                    if (fileImpl == null) continue;
                    this.onFileRemovedImpl(fileImpl);
                    arrayList.add(fileImpl);
                }
                finally {
                    Notificator.instance().flush();
                }
            }
            DeepReparsingUtils.reparseOnRemoved(arrayList, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    @Override
    public void onFileAdded(NativeFileItem nativeFileItem) {
        this.onFileAddedImpl(nativeFileItem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeFileItem onFileAddedImpl(NativeFileItem nativeFileItem, boolean bl) {
        if (Utils.acceptNativeItem(nativeFileItem)) {
            CndFileUtils.clearFileExistenceCache();
            try {
                this.createIfNeed(nativeFileItem, this.isSourceFile(nativeFileItem));
                NativeFileItem nativeFileItem2 = nativeFileItem;
                return nativeFileItem2;
            }
            finally {
                Notificator.instance().flush();
                if (bl) {
                    DeepReparsingUtils.reparseOnAdded(nativeFileItem, (ProjectBase)this);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileAdded(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
            for (NativeFileItem nativeFileItem : list) {
                NativeFileItem nativeFileItem2 = this.onFileAddedImpl(nativeFileItem, false);
                if (nativeFileItem2 == null) continue;
                arrayList.add(nativeFileItem2);
            }
            DeepReparsingUtils.reparseOnAdded(arrayList, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureChangedFilesEnqueued() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            super.ensureChangedFilesEnqueued();
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (fileImpl.isParsingOrParsed()) continue;
                ParserQueue.instance().add(fileImpl, this.getPreprocHandler(fileImpl.getBuffer().getFile()).getState(), ParserQueue.Position.TAIL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasChangedFiles(CsmFile csmFile) {
        if (csmFile == null) {
            return false;
        }
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (csmFile == fileImpl || fileImpl.isParsingOrParsed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasEditedFiles() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            return !this.editedFiles.isEmpty();
        }
    }

    @Override
    public ProjectBase findFileProject(CharSequence charSequence) {
        ProjectBase projectBase = super.findFileProject(charSequence);
        if (projectBase == null && ParserThreadManager.instance().isStandalone()) {
            projectBase = ((Object)charSequence).toString().startsWith("/usr") ? projectBase : this;
        }
        return projectBase;
    }

    public boolean isArtificial() {
        return false;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> csmUID) {
        return this.nativeFiles.getNativeFileItem(csmUID);
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> csmUID, NativeFileItem nativeFileItem) {
        this.nativeFiles.putNativeFileItem(csmUID, nativeFileItem);
    }

    @Override
    protected void removeNativeFileItem(CsmUID<CsmFile> csmUID) {
        this.nativeFiles.removeNativeFileItem(csmUID);
    }

    @Override
    protected void clearNativeFileContainer() {
        this.nativeFiles.clear();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        LibraryManager.getInstance().writeProjectLibraries(this.getUID(), dataOutput);
    }

    public ProjectImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        LibraryManager.getInstance().readProjectLibraries(this.getUID(), dataInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleParseOnEditing(final FileImpl fileImpl) {
        int n;
        RequestProcessor.Task task;
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            EditingTask editingTask = this.editedFiles.get(fileImpl);
            if (editingTask == null) {
                if (TraceFlags.TRACE_182342_BUG) {
                    System.err.println("scheduleParseOnEditing: file was removed " + fileImpl);
                }
                return;
            }
            if (!editingTask.updateLastModified(fileImpl.getBuffer().lastModified())) {
                if (TraceFlags.TRACE_182342_BUG) {
                    System.err.println("scheduleParseOnEditing: no updates " + fileImpl + " : " + editingTask.lastModified);
                }
                return;
            }
            task = editingTask.getTask();
            if (task == null) {
                if (TraceFlags.TRACE_182342_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("scheduleParseOnEditing: edited file " + csmFile);
                    }
                    System.err.println("scheduleParseOnEditing: current file " + fileImpl);
                }
                task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (TraceFlags.TRACE_182342_BUG) {
                                System.err.printf("scheduleParseOnEditing: RUN scheduleParseOnEditing task for %s\n", fileImpl);
                            }
                            if (ProjectImpl.this.isDisposing()) {
                                return;
                            }
                            DeepReparsingUtils.reparseOnEditingFile(ProjectImpl.this, fileImpl);
                        }
                        catch (AssertionError assertionError) {
                            DiagnosticExceptoins.register((Throwable)((Object)assertionError));
                        }
                        catch (Exception exception) {
                            DiagnosticExceptoins.register(exception);
                        }
                    }
                }, true);
                task.setPriority(1);
                editingTask.setTask(task);
            } else if (TraceFlags.TRACE_182342_BUG) {
                for (CsmFile csmFile : this.editedFiles.keySet()) {
                    System.err.println("reschedule in scheduleParseOnEditing: edited file " + csmFile);
                }
                System.err.println("reschedule in scheduleParseOnEditing: current file " + fileImpl);
            }
            n = TraceFlags.REPARSE_DELAY;
            boolean bl = NamedEntityOptions.instance().isEnabled(new NamedEntity(){

                public String getName() {
                    return "reparse-on-document-changed";
                }

                public boolean isEnabledByDefault() {
                    return true;
                }
            });
            if (bl) {
                if (fileImpl.getLastParseTime() / (n + 1) > 2) {
                    n = Math.max(n, fileImpl.getLastParseTime() + 2000);
                }
            } else {
                n = Integer.MAX_VALUE;
            }
        }
        task.schedule(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisposed() {
        super.setDisposed();
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (EditingTask editingTask : this.editedFiles.values()) {
                editingTask.cancelTask();
            }
            this.editedFiles.clear();
        }
    }

    private static final class EditingTask {
        private RequestProcessor.Task task;
        private final ChangeListener bufListener;
        private final FileBuffer buf;
        private long lastModified = -1L;

        public EditingTask(FileBuffer fileBuffer, ChangeListener changeListener) {
            assert (changeListener != null);
            this.bufListener = changeListener;
            assert (fileBuffer != null);
            this.buf = fileBuffer;
            this.buf.addChangeListener(changeListener);
        }

        public boolean updateLastModified(long l) {
            if (this.lastModified == l) {
                return false;
            }
            this.lastModified = l;
            return true;
        }

        public void setTask(RequestProcessor.Task task) {
            if (TraceFlags.TRACE_182342_BUG) {
                System.err.printf("EditingTask.setTask: set new EditingTask %d for %s\n", task.hashCode(), this.buf.getFile());
            }
            this.task = task;
        }

        public void cancelTask() {
            if (this.task != null) {
                if (TraceFlags.TRACE_182342_BUG) {
                    if (!this.task.isFinished()) {
                        new Exception("EditingTask.cancelTask: cancelling previous EditingTask " + this.task.hashCode()).printStackTrace(System.err);
                    } else {
                        new Exception("EditingTask.cancelTask: cancelTask where EditingTask was finished " + this.task.hashCode()).printStackTrace(System.err);
                    }
                }
                try {
                    this.task.cancel();
                }
                catch (Throwable throwable) {
                    System.err.println("EditingTask.cancelTask: cancelled with exception:");
                    throwable.printStackTrace(System.err);
                }
            }
            this.buf.removeChangeListener(this.bufListener);
        }

        private RequestProcessor.Task getTask() {
            return this.task;
        }
    }
}

