/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;
import org.openide.util.Lookup;

public class ProgressSupport {
    private static final ProgressSupport instance = new ProgressSupport();
    private final WeakList<CsmProgressListener> progressListeners = new WeakList();

    private ProgressSupport() {
    }

    static ProgressSupport instance() {
        return instance;
    }

    void addProgressListener(CsmProgressListener csmProgressListener) {
        this.progressListeners.add(csmProgressListener);
    }

    void removeProgressListener(CsmProgressListener csmProgressListener) {
        this.progressListeners.remove(csmProgressListener);
    }

    private Iterable<? extends CsmProgressListener> getProgressListeners() {
        Collection collection = Lookup.getDefault().lookupAll(CsmProgressListener.class);
        return collection.isEmpty() ? this.progressListeners : this.progressListeners.join(collection);
    }

    void fireFileInvalidated(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileInvalidated " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileInvalidated((CsmFile)fileImpl);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireFileAddedToParse(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileAddedToParse " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileAddedToParse((CsmFile)fileImpl);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireFileParsingStarted(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileParsingStarted " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingStarted((CsmFile)fileImpl);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireFileParsingFinished(FileImpl fileImpl) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileParsingFinished " + fileImpl.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingFinished((CsmFile)fileImpl);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireProjectParsingStarted(ProjectBase projectBase) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectParsingStarted " + projectBase.getName());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingStarted((CsmProject)projectBase);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireProjectParsingFinished(ProjectBase projectBase) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectParsingFinished " + projectBase.getName());
        }
        FileImpl.incParseCount();
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingFinished((CsmProject)projectBase);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireProjectLoaded(ProjectBase projectBase) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectLoaded " + projectBase.getName());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectLoaded((CsmProject)projectBase);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireIdle() {
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.parserIdle();
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }

    void fireProjectFilesCounted(ProjectBase projectBase, int n) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectFilesCounted " + projectBase.getName() + ' ' + n);
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectFilesCounted((CsmProject)projectBase, n);
            }
            catch (Throwable throwable) {
                DiagnosticExceptoins.register(throwable);
            }
        }
    }
}

