/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

class ClassifierContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private final Map<CharSequence, CsmUID<CsmClassifier>> classifiers;
    private final Map<CharSequence, CsmUID<CsmClassifier>> typedefs;
    private final Map<CharSequence, Set<CsmUID<CsmInheritance>>> inheritances;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private static final ClassifierContainer EMPTY = new ClassifierContainer(){

        @Override
        public boolean putClassifier(CsmClassifier csmClassifier) {
            return false;
        }

        @Override
        public void put() {
        }
    };

    public static ClassifierContainer empty() {
        return EMPTY;
    }

    public ClassifierContainer(ProjectBase projectBase) {
        super(new ClassifierContainerKey(((Object)projectBase.getUniqueName()).toString()), false);
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        this.put();
    }

    public ClassifierContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        int n = dataInput.readInt();
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>(n);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.classifiers, dataInput, QualifiedNameCache.getManager(), n);
        n = dataInput.readInt();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>(n);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.typedefs, dataInput, QualifiedNameCache.getManager(), n);
        n = dataInput.readInt();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        UIDObjectFactory.getDefaultFactory().readStringToUIDMapSet(this.inheritances, dataInput, NameCache.getManager(), n);
    }

    private ClassifierContainer() {
        super(null, false);
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getClassifier(CharSequence charSequence) {
        CsmUID<CsmClassifier> csmUID;
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            csmUID = this.classifiers.get(charSequence);
            if (csmUID == null) {
                csmUID = this.typedefs.get(charSequence);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(csmUID);
        return csmClassifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getInheritances(CharSequence charSequence) {
        Collection collection;
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            collection = this.inheritances.get(charSequence);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        if (collection != null) {
            return UIDCsmConverter.UIDsToInheritances(collection);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getClassifiers() {
        TreeMap<CharSequence, CsmClassifier> treeMap = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.classifiers.entrySet()) {
                treeMap.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<CharSequence, CsmClassifier> getTypedefs() {
        TreeMap<CharSequence, CsmClassifier> treeMap = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : this.typedefs.entrySet()) {
                treeMap.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putClassifier(CsmClassifier csmClassifier) {
        CharSequence charSequence;
        Object object;
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        boolean bl = false;
        CsmUID<CsmClassifier> csmUID = UIDCsmConverter.declarationToUID(csmClassifier);
        if (this.isTypedef((CsmDeclaration)csmClassifier)) {
            map = this.typedefs;
        } else {
            map = this.classifiers;
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier) && !(object = (charSequence = (CsmClass)csmClassifier).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CsmInheritance csmInheritance = (CsmInheritance)iterator.next();
                        CharSequence charSequence2 = this.inheritanceName(csmInheritance);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(charSequence2);
                        if (set == null) {
                            set = new HashSet<CsmUID<CsmInheritance>>();
                            this.inheritances.put(charSequence2, set);
                        }
                        set.add(UIDCsmConverter.inheritanceToUID(csmInheritance));
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        charSequence = csmClassifier.getQualifiedName();
        bl = this.putClassifier(map, charSequence, csmUID);
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier) && !CsmKindUtilities.isTemplate((CsmObject)csmClassifier)) {
            object = this.getQualifiedNameWithoutScopeClasses(csmClassifier);
            if (charSequence.length() != object.length()) {
                this.putClassifier(map, (CharSequence)object, csmUID);
            }
        }
        return bl;
    }

    private CharSequence inheritanceName(CsmInheritance csmInheritance) {
        CharSequence charSequence = csmInheritance instanceof TypeImpl ? ((TypeImpl)csmInheritance.getAncestorType()).getOwnText() : csmInheritance.getAncestorType().getClassifierText();
        int n = CharSequenceUtils.lastIndexOf((CharSequence)charSequence, (CharSequence)"::");
        if (n >= 0) {
            charSequence = charSequence.subSequence(n + 2, charSequence.length());
        }
        return NameCache.getManager().getString(charSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence charSequence, CsmUID<CsmClassifier> csmUID) {
        boolean bl = false;
        try {
            this.declarationsLock.writeLock().lock();
            if (!map.containsKey(charSequence)) {
                assert (csmUID != null);
                map.put(charSequence, csmUID);
                assert (UIDCsmConverter.UIDtoDeclaration(csmUID) != null);
                bl = true;
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (bl) {
            this.put();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassifier(CsmDeclaration csmDeclaration) {
        CharSequence charSequence;
        Object object;
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        if (this.isTypedef(csmDeclaration)) {
            map = this.typedefs;
        } else {
            map = this.classifiers;
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration) && !(object = (charSequence = (CsmClass)csmDeclaration).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CsmInheritance csmInheritance = (CsmInheritance)iterator.next();
                        CharSequence charSequence2 = this.inheritanceName(csmInheritance);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(charSequence2);
                        if (set == null) continue;
                        set.remove(UIDCsmConverter.inheritanceToUID(csmInheritance));
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        charSequence = csmDeclaration.getQualifiedName();
        this.removeClassifier(map, charSequence);
        if (CsmKindUtilities.isClass((CsmObject)csmDeclaration) && !CsmKindUtilities.isTemplate((CsmObject)csmDeclaration)) {
            object = this.getQualifiedNameWithoutScopeClasses((CsmClassifier)((CsmClass)csmDeclaration));
            if (charSequence.length() != object.length()) {
                this.removeClassifier(map, (CharSequence)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence charSequence) {
        CsmUID<CsmClassifier> csmUID;
        try {
            this.declarationsLock.writeLock().lock();
            csmUID = map.remove(charSequence);
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        assert (csmUID == null || UIDCsmConverter.UIDtoCsmObject(csmUID) != null) : " no object for UID " + csmUID;
        if (csmUID != null) {
            this.put();
        }
    }

    private CharSequence getQualifiedNameWithoutScopeClasses(CsmClassifier csmClassifier) {
        CharSequence charSequence = csmClassifier instanceof OffsetableDeclarationBase ? ((OffsetableDeclarationBase)csmClassifier).getQualifiedNamePostfix() : csmClassifier.getName();
        CsmScope csmScope = csmClassifier.getScope();
        while (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            csmScope = ((CsmClass)csmScope).getScope();
        }
        CharSequence charSequence2 = CsmKindUtilities.isNamespace((Object)csmScope) ? Utils.getQualifiedName(((Object)charSequence).toString(), (CsmNamespace)csmScope) : charSequence;
        charSequence2 = QualifiedNameCache.getManager().getString(charSequence2);
        return charSequence2;
    }

    private boolean isTypedef(CsmDeclaration csmDeclaration) {
        return CsmKindUtilities.isTypedef((CsmObject)csmDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.classifiers, dataOutput, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.typedefs, dataOutput, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMapSet(this.inheritances, dataOutput);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

