/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.wizard.DetectWizardPanel;
import org.netbeans.modules.mobility.cldcplatform.wizard.FindWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class InstallerIterator
implements WizardDescriptor.InstantiatingIterator {
    private static InstallerIterator INSTANCE;
    ArrayList<ChangeListener> listeners = new ArrayList();
    int current;
    private WizardDescriptor.FinishablePanel[] panels;
    private WizardDescriptor wizardDescriptor;

    public static synchronized InstallerIterator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new InstallerIterator();
        }
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.current];
    }

    public String name() {
        return NbBundle.getMessage(InstallerIterator.class, (String)"Title_InstallIterator_Add_Mobile_Platforms");
    }

    public boolean hasNext() {
        return this.current < this.panels.length - 1 && this.current().isValid();
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        assert (this.hasNext());
        ++this.current;
    }

    public void previousPanel() {
        assert (this.hasPrevious());
        --this.current;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        this.current = 0;
        this.panels = new WizardDescriptor.FinishablePanel[]{new FindWizardPanel(), new DetectWizardPanel()};
        String[] strs = new String[this.panels.length];
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = this.panels[i].getComponent().getName();
        }
        ((JComponent)this.panels[0].getComponent()).putClientProperty("WizardPanel_contentData", strs);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set<J2MEPlatform> instantiate() throws IOException {
        J2MEPlatform[] platforms = (J2MEPlatform[])this.wizardDescriptor.getProperty("Platforms");
        HashSet<J2MEPlatform> set = new HashSet<J2MEPlatform>();
        for (int i = 0; i < platforms.length; ++i) {
            J2MEPlatform platform = platforms[i];
            J2MEPlatform.createPlatform(platform);
            set.add(platform);
        }
        return set;
    }
}

