/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.cldcplatform.ArchiveFilter;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SrcDocPathsPanel
extends JPanel
implements ListSelectionListener {
    private static final Dimension PREF_DIM = new Dimension(560, 350);
    J2MEPlatform platform;
    DefaultListModel srcModel;
    DefaultListModel docModel;
    private JButton bDocAdd;
    private JButton bDocRemove;
    private JButton bSrcAdd;
    private JButton bSrcRemove;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lDocPaths;
    private JList lSrcPaths;

    public SrcDocPathsPanel() {
        this.initComponents();
        this.initAccessibility();
        this.lDocPaths.addListSelectionListener(this);
        this.lSrcPaths.addListSelectionListener(this);
        this.srcModel = new DefaultListModel();
        this.lSrcPaths.setModel(this.srcModel);
        this.docModel = new DefaultListModel();
        this.lDocPaths.setModel(this.docModel);
        this.platform = null;
    }

    public void readData(WizardDescriptor object) {
        this.platform = (J2MEPlatform)((Object)object.getProperty("Platform"));
        if (this.platform == null) {
            return;
        }
        FileObject[] al = this.platform.getSourceFolders().getRoots();
        this.srcModel.clear();
        if (al != null) {
            for (FileObject fo : al) {
                this.srcModel.addElement(new ListItem<FileObject>(fo));
            }
        }
        List<URL> l = this.platform.getJavadocFolders();
        this.docModel.clear();
        if (l != null) {
            for (URL url : l) {
                this.docModel.addElement(new ListItem<URL>(url));
            }
        }
        this.updateButtons();
    }

    public void storeData(WizardDescriptor object) {
        if (this.platform == null) {
            return;
        }
        Object[] os = this.srcModel.toArray();
        ArrayList<FileObject> l = new ArrayList<FileObject>();
        if (os != null) {
            for (Object osa : os) {
                l.add((FileObject)((ListItem)osa).getObject());
            }
        }
        this.platform.setSourceFolders(l);
        os = this.docModel.toArray();
        ArrayList<URL> u = new ArrayList<URL>();
        if (os != null) {
            for (Object osa : os) {
                u.add((URL)((ListItem)osa).getObject());
            }
        }
        this.platform.setJavadocFolders(u);
    }

    private String browse(String title) {
        File f = new FileChooserBuilder(SrcDocPathsPanel.class).setFileFilter((FileFilter)new ArchiveFilter()).setTitle(title).showOpenDialog();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lSrcPaths = new JList();
        this.bSrcAdd = new JButton();
        this.bSrcRemove = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lDocPaths = new JList();
        this.bDocAdd = new JButton();
        this.bDocRemove = new JButton();
        this.setName(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_J2MEWizardIterator_PathsPanel"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.lSrcPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Sources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lSrcPaths.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lSrcPaths);
        this.lSrcPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSrcAdd, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Add"));
        this.bSrcAdd.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_SrcAdd"));
        this.bSrcAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SrcDocPathsPanel.this.bSrcAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bSrcAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bSrcRemove, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Remove"));
        this.bSrcRemove.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_SrcRemove"));
        this.bSrcRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SrcDocPathsPanel.this.bSrcRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bSrcRemove, gridBagConstraints);
        this.jLabel2.setLabelFor(this.lDocPaths);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_JavaDocs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.lDocPaths.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lDocPaths);
        this.lDocPaths.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel_Javadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDocAdd, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Add"));
        this.bDocAdd.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_JavadocAdd"));
        this.bDocAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SrcDocPathsPanel.this.bDocAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bDocAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDocRemove, (String)NbBundle.getMessage(SrcDocPathsPanel.class, (String)"LBL_SDPathsPanel_Remove"));
        this.bDocRemove.setToolTipText(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TTT_SrcDocPathsPanel_JavadocRemove"));
        this.bDocRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SrcDocPathsPanel.this.bDocRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.bDocRemove, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACN_SrcDocPathsPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"ACD_SrcDocPathsPanel"));
    }

    private void initAccessibility() {
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bDocRemoveActionPerformed(ActionEvent evt) {
        int selected = this.lDocPaths.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.docModel.removeElementAt(selected);
        this.lDocPaths.setSelectedIndex(selected < this.docModel.size() ? selected : selected - 1);
        this.updateButtons();
    }

    private void bSrcRemoveActionPerformed(ActionEvent evt) {
        int selected = this.lSrcPaths.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.srcModel.removeElementAt(selected);
        this.lSrcPaths.setSelectedIndex(selected < this.srcModel.size() ? selected : selected - 1);
        this.updateButtons();
    }

    private void bDocAddActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browse(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_SDPathsPanel_SelectJavaDoc"));
        if (value == null) {
            return;
        }
        URL o = J2MEPlatform.localfilepath2url(value);
        if (o != null) {
            ListItem<URL> item = new ListItem<URL>(o);
            this.docModel.addElement(item);
            this.lDocPaths.setSelectedValue(item, true);
        }
        this.updateButtons();
    }

    private void bSrcAddActionPerformed(ActionEvent evt) {
        if (this.platform == null) {
            return;
        }
        String value = this.browse(NbBundle.getMessage(SrcDocPathsPanel.class, (String)"TITLE_SDPathsPanel_SelectSource"));
        if (value == null) {
            return;
        }
        FileObject o = this.platform.resolveRelativePathToFileObject(value);
        if (o != null) {
            ListItem<FileObject> item = new ListItem<FileObject>(o);
            this.srcModel.addElement(item);
            this.lSrcPaths.setSelectedValue(item, true);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.bDocRemove.setEnabled(this.lDocPaths.getSelectedIndex() >= 0);
        this.bSrcRemove.setEnabled(this.lSrcPaths.getSelectedIndex() >= 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    public static class WizardPanel
    implements WizardDescriptor.FinishablePanel {
        SrcDocPathsPanel component;
        WizardDescriptor wizard;
        ArrayList<ChangeListener> listeners = new ArrayList();
        boolean valid = false;
        boolean finishable;

        public WizardPanel(boolean finishable) {
            this.finishable = finishable;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new SrcDocPathsPanel();
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SrcDocPathsPanel.class);
        }

        public boolean isFinishPanel() {
            return this.finishable;
        }

        public void showError(String message) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object obj) {
            this.wizard = (WizardDescriptor)obj;
            ((SrcDocPathsPanel)this.getComponent()).readData(this.wizard);
        }

        public void storeSettings(Object obj) {
            this.wizard = (WizardDescriptor)obj;
            ((SrcDocPathsPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] ll;
            WizardPanel wizardPanel = this;
            synchronized (wizardPanel) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < ll.length; ++i) {
                ll[i].stateChanged(ev);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }
    }

    static class ListItem<T> {
        T o;
        String str;

        ListItem(T o) {
            this.o = o;
            if (o instanceof FileObject) {
                this.str = J2MEPlatform.getFilePath((FileObject)o);
            } else if (o instanceof URL) {
                this.str = J2MEPlatform.getFilePath(URLMapper.findFileObject((URL)((URL)o)));
            }
            if (this.str == null) {
                this.str = o != null ? o.toString() : "";
            }
        }

        T getObject() {
            return this.o;
        }

        public String toString() {
            return this.str;
        }
    }
}

