/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.cldcplatform.BrokenPlatformCustomizer;
import org.netbeans.modules.mobility.cldcplatform.CustomizerPanel;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformConvertor
implements Environment.Provider,
InstanceCookie.Of,
PropertyChangeListener,
Runnable,
InstanceContent.Convertor {
    InstanceContent cookies = new InstanceContent();
    private XMLDataObject holder;
    private Lookup lookup;
    private RequestProcessor.Task saveTask;
    protected Reference<J2MEPlatform> refPlatform = new WeakReference<Object>(null);
    private final LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
    static final int DELAY = 200;
    static final String ELEMENT_PLATFORM = "platform";
    static final String ELEMENT_DEVICE = "device";
    static final String ELEMENT_CONFIGURATION = "configuration";
    static final String ELEMENT_PROFILE = "profile";
    static final String ELEMENT_OPTIONAL = "optional";
    static final String ELEMENT_SCREEN = "screen";
    static final String ATTR_PROPERTY_NAME = "name";
    static final String ATTR_PROPERTY_HOME = "home";
    static final String ATTR_PROPERTY_TYPE = "type";
    static final String ATTR_PROPERTY_DISPLAYNAME = "displayname";
    static final String ATTR_PROPERTY_SRCPATH = "srcpath";
    static final String ATTR_PROPERTY_DOCPATH = "docpath";
    static final String ATTR_PROPERTY_DESCRIPTION = "description";
    static final String ATTR_PROPERTY_SECURITY_DOMAINS = "securitydomains";
    static final String ATTR_PROPERTY_PREVERIFYCMD = "preverifycmd";
    static final String ATTR_PROPERTY_RUNCMD = "runcmd";
    static final String ATTR_PROPERTY_DEBUGCMD = "debugcmd";
    static final String ATTR_PROPERTY_VERSION = "version";
    static final String ATTR_PROPERTY_DEPENDENCIES = "dependencies";
    static final String ATTR_PROPERTY_CLASSPATH = "classpath";
    static final String ATTR_PROPERTY_DEFAULT = "default";
    static final String ATTR_SCREEN_WIDTH = "width";
    static final String ATTR_SCREEN_HEIGHT = "height";
    static final String ATTR_SCREEN_BITDEPTH = "bitDepth";
    static final String ATTR_SCREEN_ISCOLOR = "isColor";
    static final String ATTR_SCREEN_ISTOUCH = "isTouch";
    private static final String EMPTY = "";

    private PlatformConvertor() {
    }

    public static PlatformConvertor createProvider(FileObject reg) {
        return new PlatformConvertor();
    }

    public Lookup getEnvironment(DataObject obj) {
        return new PlatformConvertor((XMLDataObject)obj).getLookup();
    }

    private PlatformConvertor(XMLDataObject object) {
        this.holder = object;
        this.holder.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(final FileEvent fe) {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws IOException {
                            String systemName = fe.getFile().getName();
                            String propPrefix = "platforms." + systemName + ".";
                            boolean changed = false;
                            EditableProperties props = PropertyUtils.getGlobalProperties();
                            Iterator it = props.keySet().iterator();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                if (!key.startsWith(propPrefix)) continue;
                                it.remove();
                                changed = true;
                            }
                            if (changed) {
                                PropertyUtils.putGlobalProperties((EditableProperties)props);
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
        this.cookies = new InstanceContent();
        this.cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.cookies);
        this.cookies.add(Node.class, (InstanceContent.Convertor)this);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public Class instanceClass() {
        return J2MEPlatform.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            J2MEPlatform o = this.refPlatform.get();
            if (o != null) {
                return o;
            }
            H handler = new H();
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(this.holder.getPrimaryFile().getInputStream());
                is.setSystemId(this.holder.getPrimaryFile().getPath());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception x = ex.getException();
                ex.printStackTrace();
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                throw new IOException(ex.getMessage());
            }
            J2MEPlatform inst = this.createPlatform(handler);
            this.refPlatform = new WeakReference<J2MEPlatform>(inst);
            PlatformConvertor.updateBuildProperties(inst);
            return inst;
        }
    }

    J2MEPlatform createPlatform(H handler) {
        J2MEPlatform p = handler.platform;
        p.addPropertyChangeListener(this);
        return p;
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public boolean instanceOf(Class type) {
        return type.isAssignableFrom(J2MEPlatform.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            if (this.saveTask == null) {
                this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
            }
        }
        platformConvertor = this;
        synchronized (platformConvertor) {
            this.keepAlive.add(evt);
        }
        this.saveTask.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PropertyChangeEvent e;
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            e = this.keepAlive.removeFirst();
        }
        J2MEPlatform plat = (J2MEPlatform)((Object)e.getSource());
        PlatformConvertor.updateBuildProperties(plat);
        try {
            this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new W(plat, (MultiDataObject)this.holder));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public Object convert(Object obj) {
        if (obj == Node.class) {
            try {
                Object p = this.instanceCreate();
                return new J2MEPlatformNode((J2MEPlatform)((Object)p), (DataObject)this.holder);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return null;
    }

    public String displayName(Object obj) {
        return ((Class)obj).getName();
    }

    public String id(Object obj) {
        return obj.toString();
    }

    public Class type(Object obj) {
        return (Class)obj;
    }

    public static DataObject create(J2MEPlatform plat, DataFolder f, String idName) throws IOException {
        W w = new W(plat, f, idName);
        f.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)w);
        return w.holder;
    }

    private static void updateBuildProperties(final J2MEPlatform p) {
        final String name = p.getName();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws Exception {
                            EditableProperties props = PropertyUtils.getGlobalProperties();
                            Iterator it = props.entrySet().iterator();
                            String prefix = PlatformConvertor.createName(name, PlatformConvertor.EMPTY);
                            while (it.hasNext()) {
                                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(prefix)) continue;
                                it.remove();
                            }
                            props.setProperty(PlatformConvertor.createName(name, PlatformConvertor.ATTR_PROPERTY_HOME), p.getHomePath());
                            props.setProperty(PlatformConvertor.createName(name, PlatformConvertor.ATTR_PROPERTY_TYPE), p.getType());
                            props.setProperty(PlatformConvertor.createName(name, "preverifycommandline"), p.getPreverifyCmd() != null ? p.getPreverifyCmd() : PlatformConvertor.EMPTY);
                            props.setProperty(PlatformConvertor.createName(name, "runcommandline"), p.getRunCmd() != null ? p.getRunCmd() : PlatformConvertor.EMPTY);
                            props.setProperty(PlatformConvertor.createName(name, "debugcommandline"), p.getDebugCmd() != null ? p.getDebugCmd() : PlatformConvertor.EMPTY);
                            PropertyUtils.putGlobalProperties((EditableProperties)props);
                            return null;
                        }
                    });
                }
                catch (MutexException me) {
                    ErrorManager.getDefault().notify((Throwable)me.getException());
                }
            }
        });
    }

    protected static String createName(String propName, String propType) {
        return "platforms." + propName + "." + propType;
    }

    public static String array2string(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer sb = null;
        for (int a = 0; a < array.length; ++a) {
            if (sb == null) {
                sb = new StringBuffer(array[a].length() * array.length);
            } else {
                sb.append(',');
            }
            sb.append(array[a]);
        }
        return sb != null ? sb.toString() : EMPTY;
    }

    public static String[] string2array(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(string, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String toJavaIdentifier(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (sb.length() == 0 && Character.isJavaIdentifierStart(ch)) {
                sb.append(ch);
                continue;
            }
            if (!Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Map<String, String> extractPlatformProperties(String prefix, J2MEPlatform platform, J2MEPlatform.Device device, String reqConfiguration, String reqProfile) {
        String type;
        String dname;
        String pdesc;
        String pname;
        HashMap<String, String> props = new HashMap<String, String>();
        J2MEPlatform.J2MEProfile configuration = null;
        J2MEPlatform.J2MEProfile profile = null;
        StringBuffer apis = new StringBuffer();
        StringBuffer classpath = new StringBuffer();
        HashMap<String, String> abilities = new HashMap<String, String>();
        if (platform == null) {
            pname = ".default";
            pdesc = EMPTY;
            dname = EMPTY;
            type = EMPTY;
        } else {
            pname = platform.getName();
            pdesc = platform.getDisplayName();
            type = platform.getType();
            if (device == null && platform.getDevices() != null && platform.getDevices().length > 0) {
                device = platform.getDevices()[0];
            }
            if (device == null) {
                dname = EMPTY;
            } else {
                J2MEPlatform.Screen scr;
                dname = device.getName();
                J2MEPlatform.J2MEProfile[] profs = device.getProfiles();
                for (int i = 0; i < profs.length; ++i) {
                    String val;
                    if (ELEMENT_CONFIGURATION.equals(profs[i].getType())) {
                        if (configuration == null || !configuration.toString().equals(reqConfiguration) && profs[i].isDefault() || profs[i].toString().equals(reqConfiguration)) {
                            configuration = profs[i];
                        }
                    } else if (ELEMENT_PROFILE.equals(profs[i].getType())) {
                        if (profile == null || !profile.toString().equals(reqProfile) && profs[i].isDefault() || profs[i].toString().equals(reqProfile)) {
                            profile = profs[i];
                        }
                    } else if (profs[i].isDefault()) {
                        if (apis.length() > 0) {
                            apis.append(',');
                        }
                        apis.append(profs[i].toString());
                        if (classpath.length() > 0) {
                            classpath.append(':');
                        }
                        classpath.append(profs[i].getClassPath());
                    }
                    String version = profs[i].getVersion() == null ? null : profs[i].getVersion().toString();
                    String ability = PlatformConvertor.toValidAbility(profs[i].getName());
                    if (ability == null || (val = (String)abilities.get(ability)) != null && (version == null || version.compareTo(val) <= 0)) continue;
                    abilities.put(ability, version);
                }
                if (configuration != null) {
                    if (classpath.length() > 0) {
                        classpath.append(':');
                    }
                    classpath.append(configuration.getClassPath());
                }
                if (profile != null) {
                    if (classpath.length() > 0) {
                        classpath.append(':');
                    }
                    classpath.append(profile.getClassPath());
                }
                if ((scr = device.getScreen()) != null) {
                    if (scr.getColor() != null && scr.getColor().booleanValue()) {
                        abilities.put("ColorScreen", null);
                    }
                    if (scr.getTouch() != null && scr.getTouch().booleanValue()) {
                        abilities.put("TouchScreen", null);
                    }
                    if (scr.getBitDepth() != null) {
                        abilities.put("ScreenColorDepth", scr.getBitDepth().toString());
                    }
                    if (scr.getWidth() != null) {
                        abilities.put("ScreenWidth", scr.getWidth().toString());
                    }
                    if (scr.getHeight() != null) {
                        abilities.put("ScreenHeight", scr.getHeight().toString());
                    }
                }
            }
        }
        props.put(prefix + "platform.active", pname);
        props.put(prefix + "platform.active.description", pdesc);
        props.put(prefix + "platform.device", dname);
        props.put(prefix + "platform.configuration", configuration == null ? "CLDC-1.0" : configuration.toString());
        props.put(prefix + "platform.profile", profile == null ? "MIDP-1.0" : profile.toString());
        props.put(prefix + "platform.apis", apis.toString());
        props.put(prefix + "platform.bootclasspath", device == null ? classpath.toString() : device.sortClasspath(classpath.toString()));
        props.put(prefix + "abilities", PlatformConvertor.encodeAbilities(abilities));
        props.put(prefix + "platform.type", type);
        props.put(prefix + "platform.trigger", "CLDC");
        return props;
    }

    private static String toValidAbility(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '/' && c != '\\') continue;
            sb.append(c);
        }
        if (sb.length() == 0) {
            return null;
        }
        if (!Character.isJavaIdentifierStart(sb.charAt(0))) {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    private static String encodeAbilities(Map<String, String> value) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> e : value.entrySet()) {
            sb.append(e.getKey());
            if (e.getValue() != null && e.getValue().length() > 0) {
                sb.append('=').append(e.getValue());
            }
            sb.append(',');
        }
        return sb.toString();
    }

    static class H
    extends DefaultHandler {
        J2MEPlatform platform;
        private String name;
        private String home;
        private String type;
        private String displayName;
        private String srcPath;
        private String docPath;
        private ArrayList<J2MEPlatform.Device> devices;
        private String devName;
        private String devDesc;
        private String[] devSecurityDomains;
        private String devPrevCmd;
        private String devRunCmd;
        private String devDebugCmd;
        private ArrayList<J2MEPlatform.J2MEProfile> profiles;
        private J2MEPlatform.Screen screen;

        H() {
        }

        public J2MEPlatform.Device[] getDevices() {
            return this.devices.toArray(new J2MEPlatform.Device[this.devices.size()]);
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        private String getMandatoryValue(Attributes attrs, String name) throws SAXException {
            String val = attrs.getValue(name);
            if (val == null || val.length() < 1) {
                throw new SAXException("Missing " + name);
            }
            return val;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (PlatformConvertor.ELEMENT_PLATFORM.equals(qName)) {
                if (this.platform != null || this.devices != null) {
                    throw new SAXException("Invalid start of element platform");
                }
                this.name = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_NAME);
                this.home = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_HOME);
                this.type = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_TYPE);
                this.displayName = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DISPLAYNAME);
                this.srcPath = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_SRCPATH);
                this.docPath = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DOCPATH);
                this.devPrevCmd = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_PREVERIFYCMD);
                this.devRunCmd = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_RUNCMD);
                this.devDebugCmd = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DEBUGCMD);
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(qName)) {
                if (this.profiles != null) {
                    throw new SAXException("Invalid start of element device");
                }
                this.devName = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_NAME);
                this.devDesc = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DESCRIPTION);
                this.devSecurityDomains = PlatformConvertor.string2array(attrs.getValue(PlatformConvertor.ATTR_PROPERTY_SECURITY_DOMAINS));
                this.profiles = new ArrayList();
                this.screen = null;
            } else if (PlatformConvertor.ELEMENT_CONFIGURATION.equals(qName) || PlatformConvertor.ELEMENT_PROFILE.equals(qName) || PlatformConvertor.ELEMENT_OPTIONAL.equals(qName)) {
                String pname = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_NAME);
                String pversion = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROPERTY_VERSION);
                String pdependencies = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DEPENDENCIES);
                String pdisplayname = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DISPLAYNAME);
                String pclasspath = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_CLASSPATH);
                boolean pdefault = Boolean.valueOf(attrs.getValue(PlatformConvertor.ATTR_PROPERTY_DEFAULT));
                this.profiles.add(new J2MEPlatform.J2MEProfile(pname, pversion, pdisplayname, qName, pdependencies, pclasspath, pdefault));
            } else if (PlatformConvertor.ELEMENT_SCREEN.equals(qName)) {
                this.screen = new J2MEPlatform.Screen(attrs.getValue(PlatformConvertor.ATTR_SCREEN_WIDTH), attrs.getValue(PlatformConvertor.ATTR_SCREEN_HEIGHT), attrs.getValue(PlatformConvertor.ATTR_SCREEN_BITDEPTH), attrs.getValue(PlatformConvertor.ATTR_SCREEN_ISCOLOR), attrs.getValue(PlatformConvertor.ATTR_SCREEN_ISTOUCH));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (PlatformConvertor.ELEMENT_PLATFORM.equals(qName)) {
                if (this.platform != null) {
                    throw new SAXException("Invalid end of element platform");
                }
                if (this.devices == null) {
                    throw new SAXException("Missing device");
                }
                this.platform = new J2MEPlatform(this.name, this.home, this.type, this.displayName, this.srcPath, this.docPath, this.devPrevCmd, this.devRunCmd, this.devDebugCmd, this.devices.toArray(new J2MEPlatform.Device[this.devices.size()]));
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(qName)) {
                if (this.devices == null) {
                    this.devices = new ArrayList();
                }
                this.devices.add(new J2MEPlatform.Device(this.devName, this.devDesc, this.devSecurityDomains, this.profiles.toArray(new J2MEPlatform.J2MEProfile[this.profiles.size()]), this.screen));
                this.profiles = null;
            }
        }
    }

    static class W
    implements FileSystem.AtomicAction {
        J2MEPlatform instance;
        MultiDataObject holder;
        String name;
        DataFolder f;

        W(J2MEPlatform instance, MultiDataObject holder) {
            this.instance = instance;
            this.holder = holder;
        }

        W(J2MEPlatform instance, DataFolder f, String n) {
            this.instance = instance;
            this.name = n;
            this.f = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.f.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.name, (String)"xml");
                this.instance.setName(fn);
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try {
                OutputStream ostm = data.getOutputStream(lck);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                this.write(writer);
                writer.flush();
                writer.close();
                ostm.close();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
            }
        }

        void write(PrintWriter pw) throws IOException {
            pw.println("<?xml version='1.0'?>");
            pw.println("<!DOCTYPE platform PUBLIC '-//NetBeans//DTD J2ME PlatformDefinition 1.0//EN' 'http://www.netbeans.org/dtds/j2me-platformdefinition-1_0.dtd'>");
            pw.print("<platform name=\"" + XMLUtil.toAttributeValue((String)this.instance.getName()) + "\" home=\"" + XMLUtil.toAttributeValue((String)this.instance.getHomePath()) + "\" type=\"" + XMLUtil.toAttributeValue((String)this.instance.getType()) + "\" displayname=\"" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "\" srcpath=\"" + XMLUtil.toAttributeValue((String)this.instance.getSourcePath()) + "\" docpath=\"" + XMLUtil.toAttributeValue((String)this.instance.getJavadocPath()));
            if (this.instance.getPreverifyCmd() != null) {
                pw.print("\" preverifycmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getPreverifyCmd()));
            }
            if (this.instance.getRunCmd() != null) {
                pw.print("\" runcmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getRunCmd()));
            }
            if (this.instance.getDebugCmd() != null) {
                pw.print("\" debugcmd=\"" + XMLUtil.toAttributeValue((String)this.instance.getDebugCmd()));
            }
            pw.println("\">");
            J2MEPlatform.Device[] devices = this.instance.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                J2MEPlatform.Device d = devices[i];
                pw.print("    <device name=\"" + XMLUtil.toAttributeValue((String)d.getName()));
                String securitydomains = PlatformConvertor.array2string(d.getSecurityDomains());
                if (securitydomains != null) {
                    pw.print("\" securitydomains=\"" + XMLUtil.toAttributeValue((String)securitydomains));
                }
                if (d.getDescription() != null) {
                    pw.print("\" description=\"" + XMLUtil.toAttributeValue((String)d.getDescription()));
                }
                pw.println("\">");
                J2MEPlatform.J2MEProfile[] profiles = d.getProfiles();
                for (int j = 0; j < profiles.length; ++j) {
                    J2MEPlatform.J2MEProfile p = profiles[j];
                    pw.print("        <" + p.getType() + " name=\"" + XMLUtil.toAttributeValue((String)p.getName()) + "\" version=\"" + XMLUtil.toAttributeValue((String)p.getVersion().toString()) + "\" displayname=\"" + XMLUtil.toAttributeValue((String)p.getDisplayName()) + "\" classpath=\"" + XMLUtil.toAttributeValue((String)p.getClassPath()));
                    if (p.getDependencies() != null) {
                        pw.print("\" dependencies=\"" + XMLUtil.toAttributeValue((String)p.getDependencies()));
                    }
                    pw.println("\" default=\"" + Boolean.toString(p.isDefault()) + "\"/>");
                }
                J2MEPlatform.Screen s = d.getScreen();
                if (s != null) {
                    Integer sw = s.getWidth();
                    Integer sh = s.getHeight();
                    Integer sd = s.getBitDepth();
                    Boolean sc = s.getColor();
                    Boolean st = s.getTouch();
                    if (sw != null || sh != null || sd != null || sc != null || st != null) {
                        pw.print("        <screen");
                        if (sw != null) {
                            pw.print(" width=\"" + sw + "\"");
                        }
                        if (sh != null) {
                            pw.print(" height=\"" + sh + "\"");
                        }
                        if (sd != null) {
                            pw.print(" bitDepth=\"" + sd + "\"");
                        }
                        if (sc != null) {
                            pw.print(" isColor=\"" + sc + "\"");
                        }
                        if (st != null) {
                            pw.print(" isTouch=\"" + st + "\"");
                        }
                        pw.println("/>");
                    }
                }
                pw.println("    </device>");
            }
            pw.println("</platform>");
        }

        void writeProperties(Map<String, String> props, PrintWriter pw) throws IOException {
            TreeSet<String> sortedProps = new TreeSet<String>(props.keySet());
            for (String n : sortedProps) {
                String val = props.get(n);
                pw.println("    <property name='" + XMLUtil.toAttributeValue((String)n) + "' value='" + XMLUtil.toAttributeValue((String)val) + "'/>");
            }
        }
    }

    static class J2MEPlatformNode
    extends AbstractNode
    implements PropertyChangeListener {
        J2MEPlatform platform;

        J2MEPlatformNode(J2MEPlatform platform, DataObject holder) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{platform, holder}));
            this.platform = platform;
            platform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)platform)));
            this.setIconBaseWithExtension("org/netbeans/modules/mobility/cldcplatform/resources/platform.gif");
        }

        public String getDisplayName() {
            return this.platform.getDisplayName();
        }

        public String getHtmlDisplayName() {
            if (this.platform.isValid()) {
                return null;
            }
            return "<font color=\"#A40000\">" + this.platform.getDisplayName() + "</font>";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2MEPlatformNode.class);
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            if (this.platform.getInstallFolders().size() == 0) {
                return new BrokenPlatformCustomizer();
            }
            return new CustomizerPanel(this.platform);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    static interface J2MEPlatformCookie
    extends Node.Cookie {
        public J2MEPlatform getPlatform();
    }
}

