/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class Util {
    private Util() {
    }

    public static void setDefaultLookAndFeel() {
        String uiClassName = Utilities.isWindows() ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (Utilities.isMac() ? "apple.laf.AquaLookAndFeel" : (Utilities.isUnix() ? "javax.swing.plaf.metal.MetalLookAndFeel" : UIManager.getSystemLookAndFeelClassName()));
        if (uiClassName.equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(uiClassName);
        }
        catch (Exception ex) {
            System.err.println("Cannot set L&F " + uiClassName);
            System.err.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void initIcons(JDialog dialog) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame.gif", (boolean)true));
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame32.gif", (boolean)true));
        images.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
        dialog.setIconImages(images);
    }

    public static JDialog createJOptionDialog(final JOptionPane pane, String title) {
        final JDialog dialog = new JDialog(null, title, Dialog.ModalityType.APPLICATION_MODAL);
        Util.initIcons(dialog);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                pane.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    pane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == pane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }
}

