/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntimeObjAlloc
extends ProfilerRuntimeMemory {
    protected static boolean objAllocProfilingDisabled = true;

    public static void enableProfiling(boolean v) {
        if (!v) {
            objAllocProfilingDisabled = true;
        }
        if (v) {
            ProfilerRuntimeObjAlloc.createNewDataStructures();
            ProfilerRuntimeMemory.enableProfiling(v);
        } else {
            ProfilerRuntimeMemory.enableProfiling(v);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerRuntimeObjAlloc.clearDataStructures();
        }
        if (v) {
            objAllocProfilingDisabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceObjAlloc(Object object, char classId) {
        if (objAllocProfilingDisabled) {
            return;
        }
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            ti.initialize(true);
        }
        ++ti.inProfilingRuntimeMethod;
        classId = classId;
        int[] nArray = allocatedInstancesCount;
        synchronized (allocatedInstancesCount) {
            char c = classId;
            allocatedInstancesCount[c] = allocatedInstancesCount[c] + 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (allocatedInstThreshold[classId] <= 0) {
                long objSize = ProfilerRuntimeObjAlloc.getCachedObjectSize(classId, object);
                ProfilerRuntimeObjAlloc.getAndSendCurrentStackTrace(classId, objSize);
                ProfilerRuntimeObjAlloc.allocatedInstThreshold[classId] = ProfilerRuntimeObjAlloc.nextRandomizedInterval();
            }
            char c2 = classId;
            allocatedInstThreshold[c2] = (short)(allocatedInstThreshold[c2] - 1);
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeMemory.clearDataStructures();
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeMemory.createNewDataStructures();
    }
}

