/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;

public class EntityMethodGenerator {
    private final WorkingCopy copy;
    private final GenerationUtils genUtils;
    private final TypeElement scope;

    public EntityMethodGenerator(WorkingCopy workingCopy, GenerationUtils generationUtils, TypeElement typeElement) {
        this.copy = workingCopy;
        this.genUtils = generationUtils;
        this.scope = typeElement;
    }

    public MethodTree createHashCodeMethod(List<VariableTree> list) {
        StringBuilder stringBuilder = new StringBuilder(20 + list.size() * 30);
        stringBuilder.append("{");
        stringBuilder.append("int hash = 0;");
        for (VariableTree variableTree : list) {
            stringBuilder.append(this.createHashCodeLineForField(variableTree));
        }
        stringBuilder.append("return hash;");
        stringBuilder.append("}");
        TreeMaker treeMaker = this.copy.getTreeMaker();
        return treeMaker.Method(treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"hashCode", (Tree)treeMaker.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), stringBuilder.toString(), null);
    }

    private String createHashCodeLineForField(VariableTree variableTree) {
        Name name = variableTree.getName();
        Tree tree = variableTree.getType();
        if (tree.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
            if (((PrimitiveTypeTree)tree).getPrimitiveTypeKind() == TypeKind.BOOLEAN) {
                return "hash += (" + name + " ? 1 : 0";
            }
            return "hash += (int)" + name + ";";
        }
        return "hash += (" + name + " != null ? " + name + ".hashCode() : 0);";
    }

    public MethodTree createEqualsMethod(String string, List<VariableTree> list) {
        StringBuilder stringBuilder = new StringBuilder(50 + list.size() * 30);
        stringBuilder.append("{");
        stringBuilder.append("// TODO: Warning - this method won't work in the case the id fields are not set\n");
        stringBuilder.append("if (!(object instanceof ");
        stringBuilder.append(string + ")) {return false;}");
        stringBuilder.append(string + " other = (" + string + ")object;");
        for (VariableTree variableTree : list) {
            stringBuilder.append(this.createEqualsLineForField(variableTree));
        }
        stringBuilder.append("return true;");
        stringBuilder.append("}");
        TreeMaker treeMaker = this.copy.getTreeMaker();
        return treeMaker.Method(treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"equals", (Tree)treeMaker.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), Collections.singletonList(this.genUtils.createVariable(this.scope, "object", "java.lang.Object")), Collections.emptyList(), stringBuilder.toString(), null);
    }

    private String createEqualsLineForField(VariableTree variableTree) {
        Name name = variableTree.getName();
        Tree tree = variableTree.getType();
        if (tree.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
            return "if (this." + name + " != other." + name + ") return false;";
        }
        return "if ((this." + name + " == null && other." + name + " != null) || " + "(this." + name + " != null && !this." + name + ".equals(other." + name + ")) return false;";
    }

    public MethodTree createToStringMethod(String string, List<VariableTree> list) {
        StringBuilder stringBuilder = new StringBuilder(30 + list.size() * 30);
        stringBuilder.append("{");
        stringBuilder.append("return \"" + string + "[");
        TreeMaker treeMaker = list.iterator();
        while (treeMaker.hasNext()) {
            String string2 = treeMaker.next().getName().toString();
            stringBuilder.append(string2 + "=\" + " + string2 + " + \"");
            stringBuilder.append(treeMaker.hasNext() ? ", " : "]\";");
        }
        stringBuilder.append("}");
        treeMaker = this.copy.getTreeMaker();
        return treeMaker.Method(treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"toString", this.genUtils.createType("java.lang.String", this.scope), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), stringBuilder.toString(), null);
    }
}

