/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.lib.profiler.ui.charts.AbstractBarChartModel;
import org.netbeans.lib.profiler.ui.charts.BarChartModel;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DecimalAxisUtils;

public class BarChart
extends JComponent
implements ComponentListener,
AncestorListener,
ChartModelListener,
Accessible {
    List horizAxisXes = new LinkedList();
    int horizAxisHeight = 0;
    int horizLegendWidth = 0;
    int vertAxisWidth = 0;
    int vertLegendHeight = 0;
    private AccessibleContext accessibleContext;
    private BarChartModel model;
    private Graphics2D offScreenGraphics;
    private Image offScreenImage;
    private Insets insets;
    private Paint axisMeshPaint = new Color(80, 80, 80, 50);
    private Paint axisPaint = Color.BLACK;
    private Paint fillPaint = Color.CYAN;
    private Paint outlinePaint = Color.BLACK;
    private Stroke axisStroke = new BasicStroke(1.0f);
    private Stroke outlineStroke = new BasicStroke(1.0f, 2, 1);
    private boolean draw3D = false;
    private boolean modelIncorrect = true;
    private boolean offScreenImageInvalid;
    private boolean offScreenImageSizeInvalid = true;
    private int drawHeight;
    private int drawWidth;
    private int leftOffset = 0;
    private int maxHeight;
    private int rightOffset = 0;
    private int topOffset = 0;
    private int xSpacing = 0;

    public BarChart() {
        this.addAncestorListener(this);
        this.addComponentListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setDraw3D(boolean draw3D) {
        if (this.draw3D != draw3D) {
            this.draw3D = draw3D;
            this.chartDataChanged();
        }
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public void setFillPaint(Paint fillPaint) {
        if (!this.fillPaint.equals(fillPaint)) {
            this.fillPaint = fillPaint;
            this.chartDataChanged();
        }
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void setFont(Font font) {
        if (!this.getFont().equals(font)) {
            super.setFont(font);
            this.chartDataChanged();
        }
    }

    public void setLeftOffset(int leftOffset) {
        if (this.leftOffset != leftOffset) {
            this.leftOffset = leftOffset;
            this.chartDataChanged();
        }
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public void setModel(BarChartModel model) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (model != null) {
            model.addChartModelListener(this);
        }
        this.model = model;
        this.chartDataChanged();
    }

    public BarChartModel getModel() {
        return this.model;
    }

    public void setOutlinePaint(Paint outlinePaint) {
        if (!this.outlinePaint.equals(outlinePaint)) {
            this.outlinePaint = outlinePaint;
            this.chartDataChanged();
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        if (!this.outlineStroke.equals(outlineStroke)) {
            this.outlineStroke = outlineStroke;
            this.chartDataChanged();
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setRightOffset(int rightOffset) {
        if (this.rightOffset != rightOffset) {
            this.rightOffset = rightOffset;
            this.chartDataChanged();
        }
    }

    public int getRightOffset() {
        return this.rightOffset;
    }

    public void setTopOffset(int topOffset) {
        if (this.topOffset != topOffset) {
            this.topOffset = topOffset;
            this.chartDataChanged();
        }
    }

    public int getTopOffset() {
        return this.topOffset;
    }

    public void setXSpacing(int xSpacing) {
        if (this.xSpacing != xSpacing) {
            this.xSpacing = xSpacing;
            this.chartDataChanged();
        }
    }

    public int getXSpacing() {
        return this.xSpacing;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.chartDataChanged();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void chartDataChanged() {
        if (this.model != null) {
            this.modelIncorrect = true;
            String[] xItems = this.model.getXLabels();
            int[] yItems = this.model.getYValues();
            if (xItems == null) {
                throw new RuntimeException("X labels cannot be null!");
            }
            if (yItems == null) {
                throw new RuntimeException("Y values cannot be null!");
            }
            if (xItems.length - 1 != yItems.length) {
                throw new RuntimeException("Incorrect x-y values count!");
            }
            this.modelIncorrect = false;
            this.maxHeight = this.getMaxY(yItems);
            if (this.getFont() != null && this.getGraphics() != null && this.getGraphics().getFontMetrics() != null) {
                this.horizAxisHeight = this.getFont().getSize() + 10;
                this.horizLegendWidth = (int)this.getGraphics().getFontMetrics().getStringBounds(this.model.getXAxisDesc(), this.getGraphics()).getWidth();
                int maxYMarkWidth = (int)this.getGraphics().getFontMetrics().getStringBounds(Integer.toString(this.maxHeight) + "0", this.getGraphics()).getWidth() + 10;
                int vertLegendWidth = (int)this.getGraphics().getFontMetrics().getStringBounds(this.model.getYAxisDesc(), this.getGraphics()).getWidth();
                this.vertLegendHeight = this.getFont().getSize();
                this.vertAxisWidth = Math.max(maxYMarkWidth, vertLegendWidth + 4);
            } else {
                this.horizAxisHeight = 0;
                this.horizLegendWidth = 0;
                this.vertAxisWidth = 0;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarChart.this.offScreenImageInvalid = true;
                BarChart.this.repaint();
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.offScreenImageSizeInvalid = true;
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public static void main(String[] args) {
        BarChart barChart = new BarChart();
        AbstractBarChartModel barChartModel = new AbstractBarChartModel(){

            @Override
            public String[] getXLabels() {
                return new String[]{"37", "41", "45", "49", "53", "57"};
            }

            @Override
            public String getXAxisDesc() {
                return "[ms]";
            }

            @Override
            public String getYAxisDesc() {
                return "[freq]";
            }

            @Override
            public int[] getYValues() {
                return new int[]{55, 60, 90, 80, 10};
            }
        };
        barChart.setModel(barChartModel);
        barChart.setBackground(Color.WHITE);
        barChart.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        barChart.setPreferredSize(new Dimension(300, 200));
        barChart.setDraw3D(true);
        barChart.setLeftOffset(20);
        barChart.setRightOffset(5);
        barChart.setTopOffset(30);
        barChart.setXSpacing(10);
        JFrame frame = new JFrame("BarChart Tester");
        frame.getContentPane().add(barChart);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model == null || this.modelIncorrect) {
            return;
        }
        if (this.offScreenImageSizeInvalid) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        g.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
    }

    protected void drawBar(Graphics2D g2, int startX, int startY, int width, int height) {
        Polygon topSide = null;
        Polygon rightSide = null;
        g2.setPaint(this.fillPaint);
        g2.fillRect(startX, startY, width, height);
        if (this.draw3D) {
            topSide = new Polygon();
            topSide.addPoint(startX, startY);
            topSide.addPoint(startX + width / 3, startY - width / 3);
            topSide.addPoint(startX + width + width / 3, startY - width / 3);
            topSide.addPoint(startX + width, startY);
            rightSide = new Polygon();
            rightSide.addPoint(startX + width, startY);
            rightSide.addPoint(startX + width + width / 3, startY - width / 3);
            rightSide.addPoint(startX + width + width / 3, startY + height - width / 3);
            rightSide.addPoint(startX + width, startY + height);
            if (this.fillPaint instanceof Color) {
                g2.setPaint(((Color)this.fillPaint).brighter());
            }
            g2.fillPolygon(topSide);
            if (this.fillPaint instanceof Color) {
                g2.setPaint(((Color)this.fillPaint).darker());
            }
            g2.fillPolygon(rightSide);
        }
        g2.setStroke(this.outlineStroke);
        g2.setPaint(this.outlinePaint);
        g2.drawRect(startX, startY, width, height);
        if (this.draw3D) {
            g2.drawPolygon(topSide);
            g2.drawPolygon(rightSide);
        }
    }

    protected void drawChart(Graphics2D g2) {
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.drawWidth + 1, this.drawHeight + 1);
        String[] xItems = this.model.getXLabels();
        int[] yItems = this.model.getYValues();
        if (yItems.length > 0 && this.drawWidth > 0 && this.drawHeight > 0) {
            int outlineStrokeWidth = 0;
            if (this.outlineStroke instanceof BasicStroke) {
                outlineStrokeWidth = (int)Math.ceil((((BasicStroke)this.outlineStroke).getLineWidth() - 1.0f) / 2.0f);
            }
            int barsCount = yItems.length;
            int drawableWidth = this.drawWidth - this.vertAxisWidth - this.horizLegendWidth - this.leftOffset - this.rightOffset - barsCount * this.xSpacing - (this.horizLegendWidth == 0 ? 0 : 5) - outlineStrokeWidth * 2;
            int drawableHeight = this.drawHeight - this.topOffset - this.horizAxisHeight - outlineStrokeWidth * 2;
            int drawnWidth = 0;
            int horizontal3DCorrection = 0;
            int vertical3DCorrection = 0;
            int currentX = this.vertAxisWidth + this.leftOffset + outlineStrokeWidth;
            this.horizAxisXes.clear();
            if (this.draw3D) {
                horizontal3DCorrection = drawableWidth / barsCount / 3;
                vertical3DCorrection = (drawableWidth -= horizontal3DCorrection) / barsCount / 3;
                drawableHeight -= vertical3DCorrection;
            }
            this.drawVerticalAxis(g2, vertical3DCorrection, yItems);
            for (int i = 0; i < barsCount; ++i) {
                int width = (drawableWidth - drawnWidth) / (barsCount - i);
                int height = (int)((float)(drawableHeight * yItems[i]) / (float)this.maxHeight);
                int horizLegendX = i == 0 ? Math.max(currentX - this.xSpacing / 2, this.vertAxisWidth) : currentX - this.xSpacing / 2;
                this.drawBar(g2, currentX, this.drawHeight - this.horizAxisHeight - height - outlineStrokeWidth, width, height);
                this.horizAxisXes.add(new Integer(horizLegendX));
                currentX += width + this.xSpacing;
                drawnWidth += width;
            }
            this.horizAxisXes.add(new Integer(Math.min(currentX - this.xSpacing / 2, this.drawWidth)));
            this.drawHorizontalAxis(g2, this.horizAxisXes, xItems);
        }
        this.offScreenImageInvalid = false;
    }

    protected void drawHorizontalAxis(Graphics2D g2, List horizAxisXes, String[] xItems) {
        g2.setPaint(this.axisPaint);
        g2.setStroke(this.axisStroke);
        g2.drawLine(this.vertAxisWidth - 3, this.drawHeight - this.horizAxisHeight, this.drawWidth, this.drawHeight - this.horizAxisHeight);
        for (int i = 0; i < horizAxisXes.size(); ++i) {
            int x = (Integer)horizAxisXes.get(i);
            g2.drawLine(x, this.drawHeight - this.horizAxisHeight + 1, x, this.drawHeight - this.horizAxisHeight + 3);
            this.drawHorizontalAxisLegendItem(g2, x, xItems[i]);
        }
        g2.drawString(this.model.getXAxisDesc(), this.drawWidth - this.horizLegendWidth - 2, this.drawHeight - 5);
    }

    protected void drawHorizontalAxisLegendItem(Graphics2D g2, int x, String string) {
        int legendWidth = (int)g2.getFontMetrics().getStringBounds(string, g2).getWidth();
        int legendX = Math.min(x - legendWidth / 2, this.drawWidth - legendWidth - this.horizLegendWidth - 3);
        g2.drawString(string, legendX, this.drawHeight - 5);
    }

    protected void drawVerticalAxis(Graphics2D g2, int vertical3DCorrection, int[] yItems) {
        long firstMark;
        g2.setPaint(this.axisPaint);
        g2.setStroke(this.axisStroke);
        g2.drawLine(this.vertAxisWidth, 0, this.vertAxisWidth, this.drawHeight - this.horizAxisHeight);
        double factor = (double)(this.drawHeight - this.horizAxisHeight - this.topOffset - vertical3DCorrection) / (double)this.maxHeight;
        long optimalUnits = DecimalAxisUtils.getOptimalUnits(factor, 30);
        long currentMark = firstMark = 0L;
        int markPosition = this.drawHeight - this.horizAxisHeight - (int)((double)currentMark * factor);
        while (markPosition >= this.vertLegendHeight + 5) {
            g2.setPaint(this.axisPaint);
            g2.setStroke(this.axisStroke);
            g2.drawLine(this.vertAxisWidth - 3, markPosition, this.vertAxisWidth - 1, markPosition);
            this.drawVerticalAxisLegendItem(g2, markPosition, Long.toString(currentMark));
            g2.setPaint(this.axisMeshPaint);
            g2.drawLine(this.vertAxisWidth, markPosition, this.vertAxisWidth + this.drawWidth, markPosition);
            markPosition = this.drawHeight - this.horizAxisHeight - (int)((double)(currentMark += optimalUnits) * factor);
        }
        g2.setPaint(this.axisPaint);
        g2.drawString(this.model.getYAxisDesc(), 2, this.vertLegendHeight);
    }

    protected void drawVerticalAxisLegendItem(Graphics2D g2, int y, String string) {
        int legendWidth = (int)g2.getFontMetrics().getStringBounds(string, g2).getWidth();
        int legendHeight = this.vertLegendHeight;
        int legendX = this.vertAxisWidth - legendWidth - 5;
        int legendY = Math.max(y + legendHeight / 2 - 2, 2 * legendHeight + 3);
        g2.drawString(string, legendX, legendY);
    }

    protected void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        this.offScreenImage = this.createImage(this.drawWidth + 1, this.drawHeight + 1);
        this.offScreenGraphics = (Graphics2D)this.offScreenImage.getGraphics();
        this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.offScreenImageSizeInvalid = false;
        this.offScreenImageInvalid = true;
    }

    private int getMaxY(int[] yItems) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < yItems.length; ++i) {
            if (max >= yItems[i]) continue;
            max = yItems[i];
        }
        return max;
    }
}

