/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class WebParamDuplicity
extends Rule<VariableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(VariableElement variableElement, ProblemContext problemContext) {
        Object object;
        AnnotationValue annotationValue;
        AnnotationMirror annotationMirror = Utilities.findAnnotation(variableElement, "javax.jws.WebParam");
        if (annotationMirror != null && (annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "name")) != null && (object = annotationValue.getValue()) != null && this.isDuplicate(variableElement, object)) {
            String string = NbBundle.getMessage(WebParamDuplicity.class, (String)"MSG_WebParam_Duplicity");
            RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), variableElement, annotationMirror, "name");
            AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(variableElement, annotationMirror);
            ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "name");
            problemContext.setElementToAnnotate(expressionTree);
            ErrorDescription errorDescription = WebParamDuplicity.createProblem((Element)variableElement, problemContext, string, removeAnnotationArgument);
            problemContext.setElementToAnnotate(null);
            return new ErrorDescription[]{errorDescription};
        }
        return null;
    }

    @Override
    protected boolean isApplicable(VariableElement variableElement, ProblemContext problemContext) {
        return Utilities.hasAnnotation(variableElement, "javax.jws.WebParam");
    }

    private boolean isDuplicate(VariableElement variableElement, Object object) {
        Element element = variableElement.getEnclosingElement();
        if (ElementKind.METHOD == element.getKind()) {
            for (VariableElement variableElement2 : ((ExecutableElement)element).getParameters()) {
                AnnotationValue annotationValue;
                AnnotationMirror annotationMirror;
                Name name = variableElement2.getSimpleName();
                if (name.contentEquals(variableElement.getSimpleName()) || !((annotationMirror = Utilities.findAnnotation(variableElement2, "javax.jws.WebParam")) != null ? ((annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "name")) != null ? object.equals(annotationValue.getValue()) : name.contentEquals(object.toString())) : name.contentEquals(object.toString()))) continue;
                return true;
            }
        }
        return false;
    }
}

