/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidExcludeAttribute
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(ExecutableElement executableElement, ProblemContext problemContext) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(executableElement, "javax.jws.WebMethod");
        AnnotationValue annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "exclude");
        Element element = executableElement.getEnclosingElement();
        if (annotationValue != null && annotationValue.getValue() == Boolean.TRUE) {
            if (element != null && element.getKind() == ElementKind.INTERFACE) {
                String string = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_ExcludeNotAllowed");
                RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), executableElement, annotationMirror, "exclude");
                AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(executableElement, annotationMirror);
                ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "exclude");
                problemContext.setElementToAnnotate(expressionTree);
                ErrorDescription errorDescription = InvalidExcludeAttribute.createProblem((Element)executableElement, problemContext, string, removeAnnotationArgument);
                problemContext.setElementToAnnotate(null);
                return new ErrorDescription[]{errorDescription};
            }
            if (element != null && element.getKind() == ElementKind.CLASS) {
                AnnotationValue annotationValue2 = Utilities.getAnnotationAttrValue(annotationMirror, "operationName");
                if (annotationValue2 != null) {
                    String string = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_OperationNameNotAllowed");
                    RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), executableElement, annotationMirror, "operationName");
                    AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(executableElement, annotationMirror);
                    ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "operationName");
                    problemContext.setElementToAnnotate(expressionTree);
                    ErrorDescription errorDescription = InvalidExcludeAttribute.createProblem((Element)executableElement, problemContext, string, removeAnnotationArgument);
                    problemContext.setElementToAnnotate(null);
                    return new ErrorDescription[]{errorDescription};
                }
                AnnotationValue annotationValue3 = Utilities.getAnnotationAttrValue(annotationMirror, "action");
                if (annotationValue3 != null) {
                    String string = NbBundle.getMessage(InvalidExcludeAttribute.class, (String)"MSG_WebMethod_ActionNotAllowed");
                    RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), executableElement, annotationMirror, "action");
                    AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(executableElement, annotationMirror);
                    ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "action");
                    problemContext.setElementToAnnotate(expressionTree);
                    ErrorDescription errorDescription = InvalidExcludeAttribute.createProblem((Element)executableElement, problemContext, string, removeAnnotationArgument);
                    problemContext.setElementToAnnotate(null);
                    return new ErrorDescription[]{errorDescription};
                }
            }
        }
        return null;
    }

    @Override
    protected boolean isApplicable(ExecutableElement executableElement, ProblemContext problemContext) {
        return Utilities.hasAnnotation(executableElement, "javax.jws.WebMethod");
    }
}

