/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.xml.Alternatives;
import org.netbeans.modules.web.beans.xml.BeanClass;
import org.netbeans.modules.web.beans.xml.BeanClassContainer;
import org.netbeans.modules.web.beans.xml.Beans;
import org.netbeans.modules.web.beans.xml.Decorators;
import org.netbeans.modules.web.beans.xml.Interceptors;
import org.netbeans.modules.web.beans.xml.Stereotype;
import org.netbeans.modules.web.beans.xml.WebBeansModel;
import org.netbeans.modules.web.beans.xml.WebBeansModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class BeansModelImpl
implements BeansModel {
    private static final String META_INF = "META-INF/";
    private static final String BEANS_XML = "beans.xml";
    private static final String WEB_INF = "WEB-INF/";
    private ModelUnit myUnit;
    private Object myLock;
    private List<WebBeansModel> myModels;
    private Map<FileObject, List<WebBeansModel>> myCompileRootToModel = new HashMap<FileObject, List<WebBeansModel>>();
    private FileChangeListener myListener;

    public BeansModelImpl(ModelUnit modelUnit) {
        this.myUnit = modelUnit;
        this.myLock = new Object();
        this.registerChangeListeners();
        this.initModels();
    }

    @Override
    public Set<String> getAlternativeClasses() {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebBeansModel webBeansModel : this.getModels()) {
            Beans beans = webBeansModel.getBeans();
            if (beans == null) continue;
            List list = beans.getChildren(Alternatives.class);
            for (Alternatives alternatives : list) {
                List list2 = alternatives.getChildren(BeanClass.class);
                for (BeanClass beanClass : list2) {
                    hashSet.add(beanClass.getBeanClass());
                }
            }
        }
        return hashSet;
    }

    @Override
    public Set<String> getAlternativeStereotypes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebBeansModel webBeansModel : this.getModels()) {
            Beans beans = webBeansModel.getBeans();
            if (beans == null) continue;
            List list = beans.getChildren(Alternatives.class);
            for (Alternatives alternatives : list) {
                List list2 = alternatives.getChildren(Stereotype.class);
                for (Stereotype stereotype : list2) {
                    hashSet.add(stereotype.getStereotype());
                }
            }
        }
        return hashSet;
    }

    @Override
    public Set<String> getDecoratorClasses() {
        return this.getBeanClasses(Decorators.class);
    }

    @Override
    public Set<String> getIntercetorClasses() {
        return this.getBeanClasses(Interceptors.class);
    }

    public Set<String> getBeanClasses(Class<? extends BeanClassContainer> clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebBeansModel webBeansModel : this.getModels()) {
            Beans beans = webBeansModel.getBeans();
            if (beans == null) continue;
            List list = beans.getChildren(clazz);
            for (BeanClassContainer beanClassContainer : list) {
                List<BeanClass> list2 = beanClassContainer.getBeansClasses();
                for (BeanClass beanClass : list2) {
                    hashSet.add(beanClass.getBeanClass());
                }
            }
        }
        return hashSet;
    }

    private void registerChangeListeners() {
        ClassPath classPath = this.getUnit().getCompilePath();
        classPath.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = BeansModelImpl.this.myLock;
                synchronized (object) {
                    if (BeansModelImpl.this.myModels == null) {
                        return;
                    }
                    FileObject[] fileObjectArray = BeansModelImpl.this.getUnit().getCompilePath().getRoots();
                    HashSet<FileObject> hashSet = new HashSet<FileObject>(Arrays.asList(fileObjectArray));
                    HashSet hashSet2 = new HashSet(BeansModelImpl.this.myCompileRootToModel.keySet());
                    HashSet<FileObject> hashSet3 = new HashSet<FileObject>(hashSet);
                    hashSet3.retainAll(hashSet2);
                    hashSet2.removeAll(hashSet);
                    for (FileObject fileObject : hashSet2) {
                        List list = (List)BeansModelImpl.this.myCompileRootToModel.remove(fileObject);
                        BeansModelImpl.this.myModels.removeAll(list);
                    }
                    hashSet.remove(hashSet3);
                    for (FileObject fileObject : hashSet) {
                        BeansModelImpl.this.addCompileModels(fileObject, BeansModelImpl.this.myModels);
                    }
                }
            }
        });
        this.myListener = new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            }

            public void fileChanged(FileEvent fileEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDataCreated(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (!this.checkBeansFile(fileObject)) {
                    return;
                }
                ModelSource modelSource = BeansModelImpl.this.getModelSource(fileObject, true);
                if (modelSource != null) {
                    WebBeansModel webBeansModel = WebBeansModelFactory.getInstance().getModel(modelSource);
                    Object object = BeansModelImpl.this.myLock;
                    synchronized (object) {
                        if (BeansModelImpl.this.myModels == null) {
                            return;
                        }
                        BeansModelImpl.this.myModels.add(webBeansModel);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(FileEvent fileEvent) {
                FileObject fileObject = fileEvent.getFile();
                if (!this.wasBeansFile(fileObject)) {
                    return;
                }
                WebBeansModel webBeansModel = null;
                Object object = BeansModelImpl.this.myLock;
                synchronized (object) {
                    if (BeansModelImpl.this.myModels == null) {
                        return;
                    }
                    for (WebBeansModel webBeansModel2 : BeansModelImpl.this.myModels) {
                        FileObject fileObject2 = (FileObject)webBeansModel2.getModelSource().getLookup().lookup(FileObject.class);
                        if (!fileObject2.equals(fileEvent.getFile())) continue;
                        webBeansModel = webBeansModel2;
                        break;
                    }
                    if (webBeansModel != null) {
                        BeansModelImpl.this.myModels.remove(webBeansModel);
                    }
                }
            }

            public void fileFolderCreated(FileEvent fileEvent) {
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
            }

            private boolean checkBeansFile(FileObject fileObject) {
                FileObject[] fileObjectArray;
                if (fileObject == null) {
                    return false;
                }
                for (FileObject fileObject2 : fileObjectArray = BeansModelImpl.this.getUnit().getSourcePath().getRoots()) {
                    FileObject fileObject3 = fileObject2.getFileObject("META-INF/beans.xml");
                    if (fileObject.equals(fileObject3)) {
                        return true;
                    }
                    FileObject fileObject4 = fileObject2.getFileObject("WEB-INF/beans.xml");
                    if (!fileObject.equals(fileObject4)) continue;
                    return true;
                }
                return false;
            }

            private boolean wasBeansFile(FileObject fileObject) {
                if (fileObject == null) {
                    return false;
                }
                String string = fileObject.getNameExt();
                if (string.equals(BeansModelImpl.BEANS_XML)) {
                    FileObject fileObject2 = fileObject.getParent();
                    if (!fileObject2.getName().equals(BeansModelImpl.META_INF) && !fileObject2.getName().equals(BeansModelImpl.WEB_INF)) {
                        return false;
                    }
                    for (FileObject fileObject3 : BeansModelImpl.this.getUnit().getSourcePath().getRoots()) {
                        if (!fileObject2.equals(fileObject3.getFileObject(BeansModelImpl.META_INF)) && !fileObject2.equals(fileObject3.getFileObject(BeansModelImpl.WEB_INF))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        FileUtil.addFileChangeListener((FileChangeListener)this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModels() {
        Object object = this.myLock;
        synchronized (object) {
            FileObject[] fileObjectArray;
            LinkedList<WebBeansModel> linkedList = new LinkedList<WebBeansModel>();
            FileObject[] fileObjectArray2 = fileObjectArray = this.getUnit().getSourcePath().getRoots();
            int n = fileObjectArray2.length;
            for (int i = 0; i < n; ++i) {
                FileObject fileObject = fileObjectArray2[i];
                this.addModels(fileObject, linkedList);
            }
            for (FileObject fileObject : fileObjectArray2 = this.getUnit().getCompilePath().getRoots()) {
                this.addCompileModels(fileObject, linkedList);
            }
            this.myModels = new CopyOnWriteArrayList<WebBeansModel>(linkedList);
        }
    }

    private void addCompileModels(FileObject fileObject, List<WebBeansModel> list) {
        FileObject fileObject2 = fileObject.getFileObject("META-INF/beans.xml");
        if (fileObject2 != null) {
            this.addCompileModel(fileObject2, fileObject, list);
        }
        if ((fileObject2 = fileObject.getFileObject("WEB-INF/beans.xml")) != null) {
            this.addCompileModel(fileObject2, fileObject, list);
        }
    }

    void addCompileModel(FileObject fileObject, FileObject fileObject2, List<WebBeansModel> list) {
        WebBeansModel webBeansModel = WebBeansModelFactory.getInstance().getModel(this.getModelSource(fileObject, false));
        if (webBeansModel != null) {
            list.add(webBeansModel);
            List<WebBeansModel> list2 = this.myCompileRootToModel.get(fileObject2);
            if (list2 == null) {
                list2 = new ArrayList<WebBeansModel>(2);
                this.myCompileRootToModel.put(fileObject2, list2);
            }
            list2.add(webBeansModel);
        }
    }

    private void addModels(FileObject fileObject, List<WebBeansModel> list) {
        FileObject fileObject2 = fileObject.getFileObject("META-INF/beans.xml");
        if (fileObject2 != null) {
            this.addModel(fileObject2, list);
        }
        if ((fileObject2 = fileObject.getFileObject("WEB-INF/beans.xml")) != null) {
            this.addModel(fileObject2, list);
        }
    }

    void addModel(FileObject fileObject, List<WebBeansModel> list) {
        WebBeansModel webBeansModel = WebBeansModelFactory.getInstance().getModel(this.getModelSource(fileObject, true));
        if (webBeansModel != null) {
            list.add(webBeansModel);
        }
    }

    private ModelSource getModelSource(FileObject fileObject, boolean bl) {
        try {
            return Utilities.createModelSource((FileObject)fileObject, (boolean)bl);
        }
        catch (CatalogModelException catalogModelException) {
            Logger.getLogger("global").log(Level.SEVERE, catalogModelException.getMessage(), catalogModelException);
            return null;
        }
    }

    private List<WebBeansModel> getModels() {
        return this.myModels;
    }

    private ModelUnit getUnit() {
        return this.myUnit;
    }
}

