/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.iocontainer;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.terminal.iocontainer.TerminalContainerCommon;
import org.openide.windows.TopComponent;

public final class TerminalContainerMuxable
extends TerminalContainerCommon {
    private final JPanel cardContainer = new JPanel();
    private final CardLayout cardLayout = new CardLayout();
    private final Set<JComponent> components = new HashSet<JComponent>();
    private volatile JComponent currentComponent;

    public TerminalContainerMuxable(TopComponent owner, String originalName) {
        super(owner, originalName);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.add((Component)this.cardContainer, "Center");
        this.cardContainer.setLayout(this.cardLayout);
    }

    @Override
    protected boolean contains(JComponent comp) {
        return this.components.contains(comp);
    }

    @Override
    protected void restoreAttrsFor(JComponent comp) {
    }

    @Override
    protected final void addTabWork(JComponent comp) {
        String cardName = TerminalContainerMuxable.cardName(comp);
        this.cardContainer.add(cardName, comp);
        this.cardLayout.addLayoutComponent(comp, cardName);
        this.components.add(comp);
        this.notify(comp);
    }

    @Override
    protected final void removeTabWork(JComponent comp) {
        this.cardContainer.remove(comp);
        this.cardLayout.removeLayoutComponent(comp);
        this.components.remove(comp);
        JComponent vc = this.figureVisibleComponent();
        this.notify(vc);
    }

    @Override
    protected void selectLite(JComponent comp) {
        this.cardLayout.show(this.cardContainer, TerminalContainerMuxable.cardName(comp));
        this.notify(comp);
    }

    @Override
    public JComponent getSelected() {
        return this.currentComponent;
    }

    @Override
    public void setTitleWork(JComponent comp, String title) {
        this.updateWindowName(title);
    }

    private static String cardName(JComponent comp) {
        return Integer.toString(comp.hashCode());
    }

    private void notify(JComponent comp) {
        this.currentComponent = comp;
        if (this.currentComponent == null) {
            this.updateWindowName(null);
        } else {
            this.updateWindowName(this.currentComponent.getName());
        }
        this.checkSelectionChange();
    }

    private JComponent figureVisibleComponent() {
        int n = this.cardContainer.getComponentCount();
        if (n == 0) {
            assert (this.components.isEmpty());
            return null;
        }
        assert (!this.components.isEmpty());
        for (int i = 0; i < n; ++i) {
            JComponent candidate = (JComponent)this.cardContainer.getComponent(i);
            if (!candidate.isVisible()) continue;
            return candidate;
        }
        assert (false) : "No component is visible";
        return null;
    }
}

