/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.jruby.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.openide.util.NbBundle;

public class JRubyServerCustomizer
extends JPanel {
    public static final String DEFAULT_RUBY_PLATFORM_ID = "ruby.platform.id";
    private GlassfishModule commonSupport;
    private boolean useRootContextChanged = false;
    private AtomicBoolean modelChanging = new AtomicBoolean(false);
    private JComboBox comboJRubyPlatform;
    private JLabel labelJRubyPlatform;
    private JCheckBox useRootContextCheckBox;

    public JRubyServerCustomizer(GlassfishModule commonSupport) {
        this.commonSupport = commonSupport;
        this.initComponents();
    }

    private void initFields() {
        this.setFilterModel(this.comboJRubyPlatform.getModel());
        Map ip = this.commonSupport.getInstanceProperties();
        RubyPlatform defaultPlatform = this.getDefaultPlatform((String)ip.get(DEFAULT_RUBY_PLATFORM_ID));
        this.comboJRubyPlatform.setSelectedItem(defaultPlatform);
        boolean useRootContextEnabled = Boolean.parseBoolean((String)ip.get("jruby.useRootContext"));
        this.useRootContextCheckBox.setSelected(useRootContextEnabled);
    }

    private RubyPlatform getDefaultPlatform(String savedPlatformId) {
        RubyPlatform result = RubyPlatformManager.getPlatformByID((String)savedPlatformId);
        if (!(result != null && result.isJRuby() || null != (result = RubyPlatformManager.getDefaultPlatform()) && result.isJRuby())) {
            result = null;
            Iterator iter = RubyPlatformManager.platformIterator();
            while (iter.hasNext()) {
                RubyPlatform p = (RubyPlatform)iter.next();
                if (!p.isJRuby()) continue;
                result = p;
                break;
            }
        }
        return result;
    }

    private void persistFields() {
        Object o = this.comboJRubyPlatform.getSelectedItem();
        if (o instanceof RubyPlatform) {
            RubyPlatform p = (RubyPlatform)o;
            this.commonSupport.setEnvironmentProperty(DEFAULT_RUBY_PLATFORM_ID, p.getID(), true);
            this.commonSupport.setEnvironmentProperty("jruby.home", p.getHome().getAbsolutePath(), true);
        }
        if (this.useRootContextChanged) {
            String useRootContextEnabled = Boolean.toString(this.useRootContextCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("jruby.useRootContext", useRootContextEnabled, true);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.labelJRubyPlatform = new JLabel();
        this.comboJRubyPlatform = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.useRootContextCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"JRubyServerCustomizer.name"));
        this.labelJRubyPlatform.setText(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"JRubyServerCustomizer.labelJRubyPlatform.text"));
        this.comboJRubyPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRubyServerCustomizer.this.comboJRubyPlatformActionPerformed(evt);
            }
        });
        this.comboJRubyPlatform.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JRubyServerCustomizer.this.comboJRubyPlatformPropertyChange(evt);
            }
        });
        this.useRootContextCheckBox.setText(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"LBL_UseRootContext"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.useRootContextCheckBox, -1, 392, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.labelJRubyPlatform).addPreferredGap(0).add((Component)this.comboJRubyPlatform, 0, 244, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labelJRubyPlatform).add((Component)this.comboJRubyPlatform, -2, -1, -2)).add(18, 18, 18).add((Component)this.useRootContextCheckBox).addContainerGap(166, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboJRubyPlatformPropertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName()) && !this.modelChanging.getAndSet(true)) {
            try {
                ComboBoxModel model = (ComboBoxModel)evt.getNewValue();
                this.setFilterModel(model);
            }
            finally {
                this.modelChanging.set(false);
            }
        }
    }

    private void comboJRubyPlatformActionPerformed(ActionEvent evt) {
        this.useRootContextChanged = true;
    }

    private void setFilterModel(ComboBoxModel model) {
        if (model != null && (model.getSize() == 0 || model.getElementAt(0) instanceof RubyPlatform)) {
            model = new FilterModel(model);
            this.comboJRubyPlatform.setModel(model);
        }
    }

    private static class FilterModel
    implements ComboBoxModel {
        private ComboBoxModel delegate;
        private Map<RubyPlatform, Integer> data;

        FilterModel(ComboBoxModel delegate) {
            this.delegate = delegate;
            this.updateModel();
        }

        private synchronized void updateModel() {
            this.data = new HashMap<RubyPlatform, Integer>();
            int size = this.delegate.getSize();
            for (int i = 0; i < size; ++i) {
                RubyPlatform p;
                Object o = this.delegate.getElementAt(i);
                if (!(o instanceof RubyPlatform) || !(p = (RubyPlatform)o).isJRuby()) continue;
                this.data.put(p, i);
            }
        }

        @Override
        public synchronized void setSelectedItem(Object anItem) {
            Integer mappedIndex = this.data.get(anItem);
            if (mappedIndex != null) {
                this.delegate.setSelectedItem(anItem);
            }
        }

        @Override
        public synchronized Object getSelectedItem() {
            RubyPlatform p;
            Object o = this.delegate.getSelectedItem();
            if (o instanceof RubyPlatform && (p = (RubyPlatform)o).isJRuby()) {
                return p;
            }
            return null;
        }

        @Override
        public synchronized int getSize() {
            return this.data.size();
        }

        @Override
        public synchronized Object getElementAt(int index) {
            Iterator<RubyPlatform> iter = this.data.keySet().iterator();
            while (index-- > 0 && iter.hasNext()) {
                iter.next();
            }
            return iter.hasNext() ? iter.next() : null;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.delegate.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.delegate.removeListDataListener(l);
        }
    }
}

