/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanelGUI;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;

public class PlatformSelectionPanel
implements WizardDescriptor.FinishablePanel {
    public static final String REQUIRED_CONFIGURATION = "RequiredConfiguration";
    public static final String REQUIRED_PROFILE = "RequiredProfile";
    public static final String PLATFORM_DESCRIPTION = "PlatformDescription";
    private PlatformSelectionPanelGUI gui;
    private String reqCfg;
    private String reqProf;
    private boolean first = true;

    public boolean isFinishPanel() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public synchronized Component getComponent() {
        if (this.gui == null) {
            this.gui = new PlatformSelectionPanelGUI();
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PlatformSelectionPanel.class);
    }

    public boolean isValid() {
        return true;
    }

    public void readSettings(Object settings) {
        if (this.first) {
            Profile prof;
            this.first = false;
            this.getComponent();
            TemplateWizard wiz = (TemplateWizard)settings;
            this.reqCfg = (String)wiz.getProperty(REQUIRED_CONFIGURATION);
            this.reqProf = (String)wiz.getProperty(REQUIRED_PROFILE);
            ArrayList<Profile> l = new ArrayList<Profile>();
            Profile cfg = PlatformSelectionPanel.parseProfile(this.reqCfg);
            if (cfg != null) {
                l.add(cfg);
            }
            if ((prof = PlatformSelectionPanel.parseProfile(this.reqProf)) != null) {
                l.add(prof);
            }
            J2MEPlatform p = PlatformSelectionPanel.findTheBestPlatform(l.toArray(new Profile[l.size()]));
            assert (p != null);
            this.gui.setValues(wiz, p, this.findDevice(p, l), this.reqCfg, this.reqProf);
        } else {
            this.gui.updateErrorMessage();
        }
    }

    private static Profile parseProfile(String profile) {
        if (profile != null) {
            try {
                int j = profile.lastIndexOf(45);
                return j > 0 ? new Profile(profile.substring(0, j).trim(), new SpecificationVersion(profile.substring(j + 1).trim())) : new Profile(profile.trim(), null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean compareProfiles(Profile p, Profile req) {
        if (!p.getName().equalsIgnoreCase(req.getName())) {
            return false;
        }
        return req.getVersion() == null || p.getVersion() != null && p.getVersion().compareTo((Object)req.getVersion()) >= 0;
    }

    private static int ratePlatform(J2MEPlatform platform, Profile[] profiles) {
        int rating = 0;
        if (platform.getName().startsWith("J2ME_Wireless_Toolkit")) {
            ++rating;
        }
        if (platform.getName().startsWith("J2ME_Wireless_Toolkit_2")) {
            ++rating;
        }
        if (profiles == null) {
            return rating;
        }
        Profile[] pp = platform.getSpecification().getProfiles();
        for (int j = 0; j < profiles.length; ++j) {
            for (int i = 0; i < pp.length; ++i) {
                if (!PlatformSelectionPanel.compareProfiles(pp[i], profiles[j])) continue;
                rating += 3;
                i = pp.length;
            }
        }
        return rating;
    }

    private static J2MEPlatform findTheBestPlatform(Profile[] profiles) {
        JavaPlatform[] plat = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, null));
        J2MEPlatform best = null;
        int bestRating = -1;
        for (int i = 0; i < plat.length; ++i) {
            int rating;
            if (!(plat[i] instanceof J2MEPlatform) || (rating = PlatformSelectionPanel.ratePlatform((J2MEPlatform)plat[i], profiles)) <= bestRating) continue;
            bestRating = rating;
            best = (J2MEPlatform)plat[i];
        }
        return best;
    }

    private J2MEPlatform.Device findDevice(J2MEPlatform p, ArrayList<Profile> profiles) {
        J2MEPlatform.Device[] d = p.getDevices();
        for (int i = 0; i < d.length; ++i) {
            if (!new HashSet<J2MEPlatform.J2MEProfile>(Arrays.asList(d[i].getProfiles())).containsAll(profiles)) continue;
            return d[i];
        }
        return null;
    }

    public void storeSettings(Object settings) {
        PlatformDescription desc = new PlatformDescription();
        this.getComponent();
        J2MEPlatform pl = this.gui.getPlatform();
        J2MEPlatform.Device dev = this.gui.getDevice();
        J2MEPlatform.J2MEProfile conf = this.gui.getConfiguration();
        J2MEPlatform.J2MEProfile prof = this.gui.getProfile();
        desc.platform = pl;
        if (conf != null) {
            desc.configuration = conf.toString();
        }
        if (prof != null) {
            desc.profile = prof.toString();
        }
        desc.device = dev;
        TemplateWizard wiz = (TemplateWizard)settings;
        wiz.putProperty(PLATFORM_DESCRIPTION, (Object)desc);
    }

    public static class PlatformDescription {
        public J2MEPlatform platform;
        public J2MEPlatform.Device device;
        public String configuration;
        public String profile;
    }
}

