/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.jam;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JAMServlet
extends HttpServlet {
    private static final long serialVersionUID = 5518842704648404246L;

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return NbBundle.getMessage(JAMServlet.class, (String)"LAB_ServletInfo");
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRepositoryRequest(request, response);
    }

    protected boolean handleRepositoryRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathI = request.getPathInfo();
        if (pathI == null) {
            return false;
        }
        if ("status".equals(pathI)) {
            return false;
        }
        try {
            pathI = URLDecoder.decode(pathI, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            pathI = URLDecoder.decode(pathI);
        }
        File f = new File(pathI);
        if (!f.isFile()) {
            return false;
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
        if (fo == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p instanceof J2MEProject) {
            return this.sendFile(response, f);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFile(HttpServletResponse response, File file) throws IOException {
        String encoding = "content/unknown";
        if (file.getName().endsWith(".jad")) {
            encoding = "text/vnd.sun.j2me.app-descriptor";
        } else if (file.getName().endsWith(".jar")) {
            encoding = "application/java-archive";
        } else {
            return false;
        }
        response.setContentType(encoding);
        int len = (int)file.length();
        response.setContentLength(len);
        response.setDateHeader("Last-Modified", file.lastModified());
        FileInputStream in = new FileInputStream(file);
        try {
            ServletOutputStream os = response.getOutputStream();
            try {
                JAMServlet.copyStream(in, (OutputStream)os);
            }
            finally {
                os.close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 8000;
        try {
            byte[] buffer = new byte[8000];
            int len = 8000;
            while ((len = in.read(buffer, 0, 8000)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.flush();
        }
    }
}

