/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NonProjectJ2eeModule
implements J2eeModuleImplementation2 {
    private static final String WAR = "war";
    private static final String EAR = "ear";
    private static final String EJB = "ejb";
    private String moduleVersion;
    private Artifact artifact;
    private String url;
    private EarModuleProviderImpl provider;
    private MetadataModel<EjbJarMetadata> ejbJarMetadataModel;
    private MetadataModel<WebAppMetadata> webAppAnnMetadataModel;

    public NonProjectJ2eeModule(Artifact artifact, String string, EarModuleProviderImpl earModuleProviderImpl) {
        this.artifact = artifact;
        this.moduleVersion = string;
        this.provider = earModuleProviderImpl;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public J2eeModule.Type getModuleType() {
        String string = this.artifact.getType();
        if (WAR.equals(string)) {
            return J2eeModule.Type.WAR;
        }
        if (EJB.equals(string)) {
            return J2eeModule.Type.EJB;
        }
        if (EAR.equals(string)) {
            return J2eeModule.Type.EAR;
        }
        return J2eeModule.Type.CAR;
    }

    public String getUrl() {
        String string = this.url == null ? this.artifact.getFile().getName() : this.url;
        return string;
    }

    public FileObject getArchive() throws IOException {
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.artifact.getFile()));
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fileObject = this.getArchive();
        return new ContentIterator(FileUtil.getArchiveRoot((FileObject)fileObject));
    }

    public FileObject getContentDirectory() throws IOException {
        return null;
    }

    public RootInterface getDeploymentDescriptor(String string) {
        if ("application.xml".equals(string)) {
            string = "META-INF/application.xml";
        }
        if ("ejb-jar.xml".equals(string)) {
            string = "META-INF/ejb-jar.xml";
        }
        if ("web.xml".equals(string)) {
            string = "WEB-INF/web.xml";
        }
        try {
            JarFile jarFile = new JarFile(this.artifact.getFile());
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                return this.readBaseBean(inputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private RootInterface readBaseBean(InputStream inputStream) {
        block12: {
            String string = this.artifact.getType();
            if (WAR.equals(string)) {
                try {
                    FileObject fileObject = FileUtil.getArchiveRoot((FileObject)this.getArchive());
                    return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(fileObject.getFileObject("WEB-INF/web.xml"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                if (EJB.equals(string)) {
                    try {
                        return DDProvider.getDefault().getDDRoot(new InputSource(inputStream));
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                        break block12;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        break block12;
                    }
                }
                if (EAR.equals(string)) {
                    try {
                        return org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(new InputSource(inputStream));
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public File getResourceDirectory() {
        return null;
    }

    public File getDeploymentConfigurationFile(String string) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public synchronized MetadataModel<EjbJarMetadata> getMetadataModel() {
        return this.ejbJarMetadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
        if (clazz == EjbJarMetadata.class) {
            MetadataModel<EjbJarMetadata> metadataModel = this.getMetadataModel();
            return metadataModel;
        }
        if (clazz == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> metadataModel = this.getAnnotationMetadataModel();
            return metadataModel;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        if (this.webAppAnnMetadataModel == null) {
            // empty if block
        }
        return this.webAppAnnMetadataModel;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject fileObject, FileObject fileObject2) {
            this.f = fileObject2;
            this.root = fileObject;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject fileObject) {
            this.ch.add(fileObject);
            this.root = fileObject;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject fileObject = this.ch.get(0);
            this.ch.remove(0);
            if (fileObject.isFolder()) {
                fileObject.refresh();
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.ch.add(fileObjectArray[i]);
                }
            }
            return new FSRootRE(this.root, fileObject);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

