/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.awt.Rectangle;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class LayoutTestUtils
implements LayoutConstants {
    static void writeString(List<String> list, String string, String string2) {
        if (string2 != null) {
            list.add("String " + string + "= \"" + string2 + "\";");
        } else {
            list.add("String " + string + " = null;");
        }
    }

    static void writeLayoutComponentArray(List<String> list, String string, String string2) {
        list.add("LayoutComponent[] " + string + " = new LayoutComponent[] { " + string2 + " };");
    }

    static void writeCollection(List<String> list, String string, Collection collection) {
        list.add("Collection " + string + " = new ArrayList();");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            list.add(string + ".add(\"" + (String)iterator.next() + "\");");
        }
    }

    static void writeStringArray(List<String> list, String string, String[] stringArray) {
        list.add("String[] " + string + " = new String[] {");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add("\"" + stringArray[i] + "\"" + (i + 1 < stringArray.length ? "," : ""));
        }
        list.add("};");
    }

    static void writeIntArray(List<String> list, String string, int[] nArray) {
        list.add("int[] " + string + " = new int[] {");
        for (int i = 0; i < nArray.length; ++i) {
            list.add(Integer.toString(nArray[i]) + (i + 1 < nArray.length ? "," : ""));
        }
        list.add("};");
    }

    static void writeRectangleArray(List<String> list, String string, Rectangle[] rectangleArray) {
        list.add("Rectangle[] " + string + " = new Rectangle[] {");
        for (int i = 0; i < rectangleArray.length; ++i) {
            list.add("new Rectangle(" + rectangleArray[i].x + ", " + rectangleArray[i].y + ", " + rectangleArray[i].width + ", " + rectangleArray[i].height + (i + 1 < rectangleArray.length ? "), " : ")"));
        }
        list.add("};");
    }

    static void dumpTestcode(List list, DataObject dataObject, final int n) {
        FileWriter fileWriter = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (dataObject == null) {
            return;
        }
        try {
            String string;
            String string22;
            FileObject fileObject = dataObject.getPrimaryFile();
            InputStream inputStream = LayoutTestUtils.class.getResourceAsStream("/org/netbeans/modules/form/resources/LayoutModelAutoTest_template");
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            while (lineNumberReader.ready()) {
                stringBuilder.append(lineNumberReader.readLine()).append('\n');
            }
            lineNumberReader.close();
            final StringBuffer stringBuffer = new StringBuffer();
            for (String string22 : list) {
                stringBuffer.append(string22).append('\n');
            }
            string22 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            final String string3 = string22.getResourceName(fileObject, '.', false);
            final boolean[] blArray = new boolean[1];
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string3);
                    blArray[0] = typeElement != null;
                }
            }, true);
            if (!blArray[0]) {
                return;
            }
            String string4 = fileObject.getName() + "Test";
            FileObject fileObject2 = fileObject.getParent().getFileObject(string4, "java");
            if (fileObject2 == null) {
                fileObject2 = fileObject.getParent().createData(string4, "java");
                string = stringBuilder.toString().replace("${CLASS_NAME}", fileObject2.getName());
                fileWriter = new FileWriter(FileUtil.toFile((FileObject)fileObject2));
                fileWriter.write(string);
                fileWriter.close();
            }
            string = "org.netbeans.modules.form.layoutdesign." + fileObject2.getName();
            javaSource = JavaSource.forFileObject((FileObject)fileObject2);
            javaSource.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)("doChanges" + n), (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{\n" + stringBuffer.toString() + "}", null);
                        ClassTree classTree2 = treeMaker.addClassMember(classTree, (Tree)methodTree);
                        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                    }
                }
            }).commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static FileObject getTargetFolder(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        try {
            FileObject fileObject3 = fileObject.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getFileObject("data/goldenfiles");
            if (fileObject3 != null) {
                fileObject2 = fileObject3;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTest(FormDesigner formDesigner, FormDataObject formDataObject, Map<String, String> map, LayoutModel layoutModel) {
        FileObject fileObject = formDataObject.getFormFile();
        formDesigner.getLayoutDesigner().dumpTestcode((DataObject)formDataObject);
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileObject fileObject2 = LayoutTestUtils.getTargetFolder(fileObject);
            FileObject fileObject3 = fileObject2.createData(fileObject.getName() + "Test-ExpectedEndModel" + Integer.toString(formDesigner.getLayoutDesigner().getModelCounter()), "txt");
            outputStreamWriter = new FileWriter(FileUtil.toFile((FileObject)fileObject3));
            outputStreamWriter.write(layoutModel.dump(map));
            StatusDisplayer.getDefault().setStatusText("The test was successfully written: " + FileUtil.getFileDisplayName((FileObject)fileObject3));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

