/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyEditor;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FormCustomEditor
extends JPanel
implements PropertyChangeListener {
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 350;
    private FormPropertyEditor editor;
    private PropertyEditor[] allEditors;
    private Component[] allCustomEditors;
    private boolean[] validValues;
    private int originalEditorIndex;
    private JPanel cardPanel;
    private JComboBox editorsCombo;

    public FormCustomEditor(FormPropertyEditor editor, Component currentCustomEditor) {
        JLabel modeLabel = new JLabel();
        this.editorsCombo = new JComboBox();
        this.editorsCombo.setRenderer(new EditorComboRenderer());
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 2, 2)));
        borderPanel.setLayout(new BorderLayout());
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        borderPanel.add((Component)this.cardPanel, "Center");
        FormProperty property = editor.getProperty();
        String selectModeText = property instanceof RADProperty ? FormUtils.getFormattedBundleString("FMT_EditingModeLabel1", new Object[]{((RADProperty)property).getRADComponent().getName(), property.getName()}) : FormUtils.getFormattedBundleString("FMT_EditingModeLabel2", new Object[]{property.getName()});
        Mnemonics.setLocalizedText((JLabel)modeLabel, (String)selectModeText);
        this.editorsCombo.setToolTipText(FormUtils.getBundleString("EditingMode_Hint"));
        modeLabel.setLabelFor(this.editorsCombo);
        this.editor = editor;
        this.allEditors = editor.getAllEditors();
        PropertyEditor currentEditor = editor.getCurrentEditor();
        this.allCustomEditors = new Component[this.allEditors.length];
        this.validValues = new boolean[this.allEditors.length];
        PropertyEnv env = editor.getPropertyEnv();
        Object currentValue = editor.getValue();
        for (int i = 0; i < this.allEditors.length; ++i) {
            String editorName;
            PropertyEditor prEd = this.allEditors[i];
            boolean current = currentEditor == prEd;
            boolean valueSet = false;
            Component custEd = null;
            if (current) {
                valueSet = true;
                custEd = currentCustomEditor;
            } else {
                Object defaultValue;
                editor.getPropertyContext().initPropertyEditor(prEd, property);
                if (env != null && prEd instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)prEd).attachEnv(env);
                }
                if (currentValue != null) {
                    try {
                        Object realValue;
                        boolean isFormDesignValue = currentValue instanceof FormDesignValue;
                        if (editor.getPropertyType().isAssignableFrom(currentValue.getClass()) && !isFormDesignValue) {
                            prEd.setValue(currentValue);
                            valueSet = true;
                        } else if (isFormDesignValue && (realValue = ((FormDesignValue)currentValue).getDesignValue()) != FormDesignValue.IGNORED_VALUE) {
                            prEd.setValue(realValue);
                            valueSet = true;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                if (!valueSet && (defaultValue = property.getDefaultValue()) != BeanSupport.NO_VALUE) {
                    prEd.setValue(defaultValue);
                    valueSet = true;
                }
                if (prEd.supportsCustomEditor()) {
                    custEd = prEd.getCustomEditor();
                }
            }
            this.validValues[i] = valueSet;
            if (prEd instanceof NamedPropertyEditor) {
                editorName = ((NamedPropertyEditor)prEd).getDisplayName();
            } else {
                String string = editorName = i == 0 ? FormUtils.getBundleString("CTL_DefaultEditor_DisplayName") : Utilities.getShortClassName(prEd.getClass());
            }
            if (custEd == null || custEd instanceof Window) {
                JPanel p = new JPanel(new GridBagLayout());
                JLabel label = new JLabel(FormUtils.getBundleString("CTL_PropertyEditorDoesNot"));
                p.add(label);
                p.getAccessibleContext().setAccessibleDescription(label.getText());
                custEd = p;
            }
            this.allCustomEditors[i] = custEd;
            this.cardPanel.add(editorName, custEd);
            this.editorsCombo.addItem(editorName);
            if (!current) continue;
            this.originalEditorIndex = i;
            this.editorsCombo.setSelectedIndex(i);
            this.updateAccessibleDescription(custEd);
        }
        if (env != null) {
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addPropertyChangeListener((PropertyChangeListener)this);
        }
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)borderPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)modeLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.editorsCombo, -2, this.editorsCombo.getPreferredSize().width * 5 / 4, -2))).addContainerGap());
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)modeLabel).add((Component)this.editorsCombo, -2, -1, -2)).addPreferredGap(1).add((Component)borderPanel, -1, -1, Short.MAX_VALUE));
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, (String)this.editorsCombo.getSelectedItem());
        this.editorsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CardLayout cl2 = (CardLayout)FormCustomEditor.this.cardPanel.getLayout();
                cl2.show(FormCustomEditor.this.cardPanel, (String)FormCustomEditor.this.editorsCombo.getSelectedItem());
                FormCustomEditor.this.updateHelpAndAccessibleDescription();
            }
        });
        this.updateHelpAndAccessibleDescription();
        this.editorsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_EditingMode"));
    }

    private void updateHelpAndAccessibleDescription() {
        int i = this.editorsCombo.getSelectedIndex();
        HelpCtx helpCtx = i < 0 ? null : HelpCtx.findHelp((Component)this.cardPanel.getComponent(i));
        String helpID = helpCtx != null ? helpCtx.getHelpID() : "";
        HelpCtx.setHelpIDString((JComponent)this, (String)helpID);
        this.updateAccessibleDescription(i < 0 ? null : this.cardPanel.getComponent(i));
    }

    private void updateAccessibleDescription(Component comp) {
        if (comp instanceof Accessible && comp.getAccessibleContext().getAccessibleDescription() != null) {
            this.getAccessibleContext().setAccessibleDescription(FormUtils.getFormattedBundleString("ACSD_FormCustomEditor", new Object[]{comp.getAccessibleContext().getAccessibleDescription()}));
        } else {
            this.getAccessibleContext().setAccessibleDescription(null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension inh = super.getPreferredSize();
        return new Dimension(Math.max(inh.width, 350), Math.max(inh.height, 350));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            Object value = this.commitChanges0();
            this.editor.setEditedValue(value);
        }
    }

    public Object commitChanges() throws PropertyVetoException {
        PropertyEditor currentEditor;
        int currentIndex = this.editorsCombo.getSelectedIndex();
        PropertyEditor propertyEditor = currentEditor = currentIndex > -1 ? this.allEditors[currentIndex] : null;
        if (currentEditor instanceof ExPropertyEditor) {
            Component currentCustEd;
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "state", null, PropertyEnv.STATE_VALID);
            if (currentEditor instanceof VetoableChangeListener) {
                ((VetoableChangeListener)((Object)currentEditor)).vetoableChange(evt);
            }
            Component component = currentCustEd = currentIndex > -1 ? this.allCustomEditors[currentIndex] : null;
            if (currentCustEd instanceof VetoableChangeListener) {
                ((VetoableChangeListener)((Object)currentCustEd)).vetoableChange(evt);
            }
            if (currentEditor instanceof PropertyChangeListener) {
                ((PropertyChangeListener)((Object)currentEditor)).propertyChange(evt);
            }
            if (currentCustEd instanceof PropertyChangeListener) {
                ((PropertyChangeListener)((Object)currentCustEd)).propertyChange(evt);
            }
        }
        return this.commitChanges0();
    }

    private Object commitChanges0() {
        PropertyEditor currentEditor;
        int currentIndex = this.editorsCombo.getSelectedIndex();
        PropertyEditor propertyEditor = currentEditor = currentIndex > -1 ? this.allEditors[currentIndex] : null;
        if (currentEditor != null) {
            Object value;
            Object object = value = this.validValues[currentIndex] ? currentEditor.getValue() : BeanSupport.NO_VALUE;
            if (this.editor.getProperty().canWrite()) {
                Object[] nodes;
                value = this.editor.getPropertyEnv() == null ? new FormProperty.ValueWithEditor(value, currentEditor, true) : ((nodes = this.editor.getPropertyEnv().getBeans()) == null || nodes.length <= 1 ? new FormProperty.ValueWithEditor(value, currentEditor, true) : new FormProperty.ValueWithEditor(value, currentIndex, true));
            }
            return value;
        }
        return BeanSupport.NO_VALUE;
    }

    private class EditorComboRenderer
    extends DefaultListCellRenderer {
        private EditorComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index == FormCustomEditor.this.originalEditorIndex && FormCustomEditor.this.editorsCombo.isPopupVisible()) {
                this.setFont(list.getFont().deriveFont(1));
            }
            return this;
        }
    }
}

