/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.multiview;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ClientOptionsPanel
extends SectionInnerPanel {
    private final transient E2EDataObject dataObject;
    private transient Properties properties;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private JCheckBox clientCreateStubs;
    private JCheckBox clientDataBinding;
    private JCheckBox clientFloatingPoint;

    public ClientOptionsPanel(SectionView sectionView, E2EDataObject e2EDataObject) {
        super(sectionView);
        this.dataObject = e2EDataObject;
        e2EDataObject.addSaveCallback(new SaveCallbackImpl());
        this.initComponents();
        this.initValues();
    }

    private void initValues() {
        Configuration configuration = this.dataObject.getConfiguration();
        ClientConfiguration clientConfiguration = configuration.getClientConfiguration();
        this.properties = clientConfiguration.getProperties();
        if (TRUE.equals(this.properties.getProperty("DataBinding"))) {
            this.clientDataBinding.setSelected(true);
        } else {
            this.clientDataBinding.setSelected(false);
        }
        if (TRUE.equals(this.properties.getProperty("createStubs"))) {
            this.clientCreateStubs.setSelected(true);
        } else {
            this.clientCreateStubs.setSelected(false);
        }
        if (TRUE.equals(this.properties.getProperty("floatingPoint"))) {
            this.clientFloatingPoint.setSelected(true);
        } else {
            this.clientFloatingPoint.setSelected(false);
        }
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    private void initComponents() {
        this.clientCreateStubs = new JCheckBox();
        this.clientFloatingPoint = new JCheckBox();
        this.clientDataBinding = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.clientCreateStubs.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.clientCreateStubs, (String)NbBundle.getMessage(ClientOptionsPanel.class, (String)"LBL_Generate_Stubs"));
        this.clientCreateStubs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientCreateStubs.setMargin(new Insets(0, 0, 0, 0));
        this.clientCreateStubs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClientOptionsPanel.this.clientCreateStubsActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.clientCreateStubs, gridBagConstraints);
        this.clientFloatingPoint.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.clientFloatingPoint, (String)NbBundle.getMessage(ClientOptionsPanel.class, (String)"LABEL_Floating_Point"));
        this.clientFloatingPoint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientFloatingPoint.setMargin(new Insets(0, 0, 0, 0));
        this.clientFloatingPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClientOptionsPanel.this.clientFloatingPointActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.clientFloatingPoint, gridBagConstraints);
        this.clientDataBinding.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.clientDataBinding, (String)NbBundle.getMessage(ClientOptionsPanel.class, (String)"LABEL_Client_DataBinding"));
        this.clientDataBinding.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientDataBinding.setMargin(new Insets(0, 0, 0, 0));
        this.clientDataBinding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClientOptionsPanel.this.clientDataBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.clientDataBinding, gridBagConstraints);
    }

    private void clientDataBindingActionPerformed(ActionEvent actionEvent) {
        this.dataObject.setModified(true);
    }

    private void clientCreateStubsActionPerformed(ActionEvent actionEvent) {
        this.dataObject.setModified(true);
    }

    private void clientFloatingPointActionPerformed(ActionEvent actionEvent) {
        this.dataObject.setModified(true);
    }

    private class SaveCallbackImpl
    implements E2EDataObject.SaveCallback {
        private static final String ID = "ClientOptionsPanelSaveCallback";

        SaveCallbackImpl() {
        }

        @Override
        public void save() {
            if (ClientOptionsPanel.this.clientDataBinding.getSelectedObjects() == null) {
                ClientOptionsPanel.this.properties.setProperty("DataBinding", ClientOptionsPanel.FALSE);
            } else {
                ClientOptionsPanel.this.properties.setProperty("DataBinding", ClientOptionsPanel.TRUE);
            }
            if (ClientOptionsPanel.this.clientCreateStubs.getSelectedObjects() == null) {
                ClientOptionsPanel.this.properties.setProperty("createStubs", ClientOptionsPanel.FALSE);
            } else {
                ClientOptionsPanel.this.properties.setProperty("createStubs", ClientOptionsPanel.TRUE);
            }
            if (ClientOptionsPanel.this.clientFloatingPoint.getSelectedObjects() == null) {
                ClientOptionsPanel.this.properties.setProperty("floatingPoint", ClientOptionsPanel.FALSE);
            } else {
                ClientOptionsPanel.this.properties.setProperty("floatingPoint", ClientOptionsPanel.TRUE);
            }
        }

        public int hashCode() {
            return ID.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof SaveCallbackImpl;
        }
    }
}

