/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.javon.JavonSerializer;

public class ClassData {
    private String packageName;
    private String className;
    private boolean primitive;
    private boolean array;
    private boolean generics;
    private ClassData parent;
    private JavonSerializer supportingSerializer = null;
    private List<FieldData> fields = new ArrayList<FieldData>();
    private List<MethodData> methods = new ArrayList<MethodData>();
    private ClassData componentType;
    private List<ClassData> typeParameters = new ArrayList<ClassData>();
    private List<MethodData> myInvalidMethods;
    private Map<String, String> myInvalidFields;
    public static final ClassData java_lang_Object = new ClassData("java.lang", "Object", false, false);

    private ClassData(String packageName, String className, boolean primitive, boolean array) {
        this.packageName = packageName;
        this.className = className;
        this.primitive = primitive;
        this.array = array;
        this.parent = java_lang_Object;
        this.myInvalidFields = new HashMap<String, String>();
    }

    public ClassData(ClassData cd) {
        this.packageName = cd.getPackage();
        this.className = cd.getName();
        this.primitive = cd.isPrimitive();
        this.array = cd.isArray();
        this.generics = cd.getParameterTypes().isEmpty();
        this.componentType = cd.getComponentType();
        this.parent = cd.getParent();
        this.supportingSerializer = cd.getSerializer();
        this.fields = cd.getFields();
        this.methods = cd.getMethods();
        this.typeParameters = cd.getParameterTypes();
        this.myInvalidFields = new HashMap<String, String>();
    }

    public ClassData(String packageName, String className, boolean primitive, boolean array, JavonSerializer serializer) {
        this(packageName, className, primitive, array);
        this.generics = false;
        this.supportingSerializer = serializer;
    }

    public ClassData(String packageName, String className, boolean array, List<FieldData> fields, List<MethodData> methods, JavonSerializer serializer) {
        this(packageName, className, false, array, serializer);
        this.generics = false;
        this.fields = fields;
        this.methods = methods;
    }

    public ClassData(String packageName, String className, boolean array, List<FieldData> fields, List<MethodData> methods, JavonSerializer serializer, List<MethodData> invalidMethods) {
        this(packageName, className, array, fields, methods, serializer);
        this.myInvalidMethods = invalidMethods;
    }

    public ClassData(String packageName, String className, boolean array, List<ClassData> typeParams, JavonSerializer serializer) {
        this(packageName, className, false, array, serializer);
        this.generics = true;
        this.typeParameters = typeParams;
    }

    public ClassData(String packageName, String className, boolean array, List<FieldData> fields, List<MethodData> methods, List<ClassData> typeParams, JavonSerializer serializer) {
        this(packageName, className, array, fields, methods, serializer);
        this.generics = true;
        this.typeParameters = typeParams;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        int arrayDepth = 0;
        ClassData t = this;
        while (t.isArray()) {
            t = t.getComponentType();
            ++arrayDepth;
        }
        String arrayBrackets = "";
        if (arrayDepth > 0) {
            for (int i = 0; i < arrayDepth; ++i) {
                arrayBrackets = arrayBrackets + "[]";
            }
        }
        return this.className + arrayBrackets;
    }

    public String getFullyQualifiedName() {
        if (this.packageName == "") {
            return this.getName();
        }
        return this.packageName + "." + this.getName();
    }

    public void setParent(ClassData parent) {
        this.parent = parent;
    }

    public ClassData getParent() {
        return this.parent;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setComponentType(ClassData type) {
        this.componentType = type;
    }

    public ClassData getComponentType() {
        return this.componentType;
    }

    public void addField(FieldData field) {
        this.fields.add(field);
    }

    public List<FieldData> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<FieldData> getAllFields() {
        ArrayList<FieldData> f = new ArrayList<FieldData>();
        for (ClassData p = this; p != null; p = p.getParent()) {
            f.addAll(p.getFields());
        }
        return Collections.unmodifiableList(f);
    }

    public void addMethod(MethodData method) {
        this.methods.add(method);
    }

    public List<MethodData> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public List<MethodData> getInvalidMethods() {
        if (this.myInvalidMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.myInvalidMethods);
    }

    public void addInvalidField(VariableElement e) {
        String name = e.getSimpleName().toString();
        String type = ((Object)e.asType()).toString();
        this.myInvalidFields.put(name, type);
    }

    public Map<String, String> getInvaidFields() {
        return new HashMap<String, String>(this.myInvalidFields);
    }

    public List<ClassData> getParameterTypes() {
        return Collections.unmodifiableList(this.typeParameters);
    }

    public void setParameterTypes(List<ClassData> parameters) {
        this.typeParameters = parameters;
    }

    public String toString() {
        String result = this.getName();
        if (this.typeParameters.size() > 0) {
            result = result + "<";
            Iterator<ClassData> it = this.typeParameters.iterator();
            while (it.hasNext()) {
                result = result + it.next().toString();
                if (!it.hasNext()) continue;
                result = result + ", ";
            }
            result = result + ">";
        }
        if (this.fields.size() > 0) {
            result = result + "[";
            for (FieldData field : this.fields) {
                result = result + field.getType().toString() + ", ";
            }
            result = result + "]";
        }
        return result;
    }

    public JavonSerializer getSerializer() {
        return this.supportingSerializer;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassData) {
            ClassData cd = (ClassData)o;
            if (!this.getFullyQualifiedName().equals(cd.getFullyQualifiedName())) {
                return false;
            }
            if (this.primitive != cd.isPrimitive()) {
                return false;
            }
            if (this.array != cd.isArray()) {
                return false;
            }
            if (this.typeParameters.size() != cd.getParameterTypes().size()) {
                return false;
            }
            for (int i = 0; i < this.typeParameters.size(); ++i) {
                if (this.typeParameters.get(i).equals(cd.getParameterTypes().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode() * 37 + this.className.hashCode() * 37 + (this.primitive ? 7 : 3) + (this.array ? 7 : 3);
    }

    public static enum Modifier {
        PUBLIC,
        PRIVATE;

    }
}

