/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.Set;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.WeakSet;

public class MakeContext {
    private final Kind kind;
    private final Project project;
    private final ExecutionEnvironment env;
    private final Configuration[] selectedConfigurations;
    private SharedItemConfiguration item;
    private Folder folder;
    private JPanel container;
    private ConfigurationDescriptor configurationDescriptor;
    private Set<Savable> listeners = new WeakSet();

    public MakeContext(Kind kind, Project project, ExecutionEnvironment env, Configuration[] selectedConfigurations) {
        this.project = project;
        this.kind = kind;
        this.env = env;
        this.selectedConfigurations = selectedConfigurations;
    }

    public MakeContext setPanel(JPanel container) {
        this.container = container;
        return this;
    }

    public MakeContext setConfigurationDescriptor(ConfigurationDescriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
        return this;
    }

    public MakeContext setFolder(Folder folder) {
        this.folder = folder;
        return this;
    }

    MakeContext setSharedItem(SharedItemConfiguration item) {
        this.item = item;
        return this;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Project getProject() {
        return this.project;
    }

    public ExecutionEnvironment getEnv() {
        return this.env;
    }

    public Configuration[] getSelectedConfigurations() {
        return this.selectedConfigurations;
    }

    SharedItemConfiguration getItem() {
        return this.item;
    }

    Folder getFolder() {
        return this.folder;
    }

    public JPanel getContainer() {
        return this.container;
    }

    public ConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void registerSavable(Savable listener) {
        this.listeners.add(listener);
    }

    public void save() {
        for (Savable listener : this.listeners) {
            listener.save();
        }
    }

    public boolean isCompilerConfiguration() {
        return ((MakeConfiguration)this.selectedConfigurations[0]).isCompileConfiguration();
    }

    public PredefinedToolKind getItemTool() {
        PredefinedToolKind tool = PredefinedToolKind.UnknownTool;
        int compilerSet = -1;
        for (int i = 0; i < this.selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.selectedConfigurations[i];
            int compilerSet2 = makeConfiguration.getCompilerSet().getValue();
            ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
            if (itemConfiguration == null) continue;
            PredefinedToolKind tool2 = itemConfiguration.getTool();
            if (tool == PredefinedToolKind.UnknownTool && compilerSet == -1) {
                tool = tool2;
                compilerSet = compilerSet2;
            }
            if (tool != tool2 || compilerSet != compilerSet2) {
                tool = PredefinedToolKind.UnknownTool;
                break;
            }
            if ((!this.isCompilerConfiguration() || makeConfiguration.isCompileConfiguration()) && (this.isCompilerConfiguration() || !makeConfiguration.isCompileConfiguration())) continue;
            tool = PredefinedToolKind.UnknownTool;
            break;
        }
        return tool;
    }

    public boolean isQtMode() {
        boolean isQtMode = false;
        for (int i = 0; i < this.selectedConfigurations.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.selectedConfigurations[i];
            isQtMode |= makeConfiguration.isQmakeConfiguration();
        }
        return isQtMode;
    }

    public static interface Savable {
        public void save();
    }

    public static enum Kind {
        Project,
        Folder,
        Item;

    }
}

