/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.util.NbBundle;

public class TarPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "Tar";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return TarPackager.getString(PACKAGER_NAME);
    }

    @Override
    public boolean hasInfoList() {
        return false;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public List<String> getOptionalInfoList() {
        return null;
    }

    @Override
    public String getDefaultOptions() {
        return "-v";
    }

    @Override
    public String getDefaultTool() {
        return "tar";
    }

    @Override
    public boolean isOutputAFolder() {
        return false;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.getOutputName();
    }

    @Override
    public String getOutputFileSuffix() {
        return "tar";
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String topDir = CndPathUtilitities.getBaseName((String)packagingConfiguration.getOutputValue());
        int i = topDir.lastIndexOf(".");
        if (i > 0) {
            topDir = topDir.substring(0, i);
        }
        return topDir;
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return false;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(TarPackager.class, (String)s);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bw, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyTarZip(bw, makeConfiguration);
        }

        private void writePackagingScriptBodyTarZip(BufferedWriter bw, MakeConfiguration conf) throws IOException {
            PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            String output = packagingConfiguration.getOutputValue();
            String outputRelToTmp = CndPathUtilitities.isPathAbsolute((String)output) ? output : "../../../../" + output;
            bw.write("# Copy files and create directories and links\n");
            for (PackagerFileElement elem : fileList) {
                String toDir;
                bw.write("cd \"${TOP}\"\n");
                if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    toDir = CndPathUtilitities.getDirName((String)conf.getPackagingConfiguration().expandMacros(elem.getTo()));
                    if (toDir != null && toDir.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"\n");
                    }
                    bw.write("copyFileToTmpDir \"" + elem.getFrom() + "\" \"${NBTMPDIR}/" + elem.getTo() + "\" 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bw.write("makeDirectory  \"${NBTMPDIR}/" + elem.getTo() + "\"" + " 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    toDir = CndPathUtilitities.getDirName((String)elem.getTo());
                    String toName = CndPathUtilitities.getBaseName((String)elem.getTo());
                    if (toDir != null && toDir.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    }
                    bw.write("cd \"${NBTMPDIR}/" + toDir + "\"" + "\n");
                    bw.write("ln -s \"" + elem.getFrom() + "\"" + " " + "\"" + toName + "\"" + "\n");
                } else if (elem.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bw.write("\n");
            }
            bw.write("\n");
            bw.write("# Generate tar file\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("rm -f " + output + "\n");
            bw.write("cd ${NBTMPDIR}\n");
            String options = packagingConfiguration.getOptionsValue() + "cf";
            if (options.charAt(0) != '-') {
                options = "-" + options;
            }
            bw.write(packagingConfiguration.getToolValue() + " " + options + " " + outputRelToTmp + " *\n");
            bw.write("checkReturnCode\n");
            bw.write("\n");
        }
    }
}

