/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;

public final class ConfigurationSupport {
    private ConfigurationSupport() {
    }

    public static String appendConfName(String oldConfs, Configuration newConf) {
        return oldConfs + "," + newConf.getDisplayName();
    }

    public static String removeConfName(String oldConfs, Configuration oldConf) {
        StringBuilder newConfs = new StringBuilder();
        StringTokenizer st = new StringTokenizer(oldConfs, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String displayName = token;
            if (displayName.equals(oldConf.getDisplayName())) continue;
            if (newConfs.length() > 0) {
                newConfs.append(",");
            }
            newConfs.append(displayName);
        }
        return newConfs.toString();
    }

    public static String renameConfName(String oldConfs, String oldDisplayName, String newDisplayName) {
        int i = oldConfs.indexOf(oldDisplayName);
        if (i < 0) {
            // empty if block
        }
        String newConfs = oldConfs.substring(0, i) + newDisplayName + oldConfs.substring(i + oldDisplayName.length());
        return newConfs;
    }

    public static String makeNameLegal(String displayName) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < displayName.length(); ++i) {
            if (i == 0 && (ConfigurationSupport.isLetterOrDigit(displayName.charAt(i)) || displayName.charAt(i) == '_')) {
                tmp.append(displayName.charAt(i));
                continue;
            }
            if (i != 0 && (ConfigurationSupport.isLetterOrDigit(displayName.charAt(i)) || displayName.charAt(i) == '_' || displayName.charAt(i) == '-' || displayName.charAt(i) == '.')) {
                tmp.append(displayName.charAt(i));
                continue;
            }
            tmp.append("_");
        }
        if (tmp.length() == 0) {
            return "Configuration";
        }
        return tmp.toString();
    }

    private static boolean isLetterOrDigit(char ch) {
        if (ch < '0' || ch > 'z') {
            return false;
        }
        return Character.isLetterOrDigit(ch);
    }

    public static String getNameFromDisplayName(String displayName) {
        return displayName;
    }

    public static String getUniqueName(Configuration[] cs, String baseName) {
        String newDisplayName;
        int number = 1;
        while (!ConfigurationSupport.isNameUnique(cs, newDisplayName = number == 1 ? baseName : baseName + "-" + number)) {
            ++number;
        }
        return newDisplayName;
    }

    public static String getUniqueNewName(Configuration[] cs) {
        return ConfigurationSupport.getUniqueName(cs, "NewConfiguration");
    }

    public static String getUniqueCopyName(Configuration[] cs, Configuration copy) {
        String newName;
        int number = 1;
        String newBaseName = "Copy";
        while (!ConfigurationSupport.isNameUnique(cs, newName = number == 1 ? newBaseName + "_of_" + copy.getName() : newBaseName + "-" + number + "_of_" + copy.getName())) {
            ++number;
        }
        return newName;
    }

    public static boolean isNameUnique(Configuration[] cs, String displayName) {
        boolean unique = true;
        String name = ConfigurationSupport.getNameFromDisplayName(displayName);
        for (int i = 0; i < cs.length; ++i) {
            if (!cs[i].getName().equals(name)) continue;
            unique = false;
            break;
        }
        return unique;
    }

    public static String getConfsPropertyValue(Configuration[] cs) {
        StringBuilder configurationProperty = new StringBuilder();
        for (int i = 0; i < cs.length; ++i) {
            if (configurationProperty.length() > 0) {
                configurationProperty.append(",");
            }
            configurationProperty.append(cs[i].getDisplayName());
        }
        return configurationProperty.toString();
    }

    public static String getDefaultConfPropertyValue(Configuration conf) {
        return conf.getDisplayName();
    }

    public static MakeConfiguration getProjectActiveConfiguration(Project project) {
        MakeConfigurationDescriptor cd;
        ConfigurationDescriptorProvider pdp;
        if (project != null && (pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && (cd = pdp.getConfigurationDescriptor()) != null) {
            return cd.getActiveConfiguration();
        }
        return null;
    }
}

