/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class NativeProjectProvider
implements NativeProject,
PropertyChangeListener {
    private static final boolean TRACE = false;
    private Project project;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private final Set<NativeProjectItemsListener> listeners = new HashSet<NativeProjectItemsListener>();
    private Reference<List<NativeProject>> cachedDependency = new SoftReference<Object>(null);

    public NativeProjectProvider(Project project, ConfigurationDescriptorProvider projectDescriptorProvider) {
        this.project = project;
        this.projectDescriptorProvider = projectDescriptorProvider;
    }

    public void runOnProjectReadiness(NamedRunnable task) {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getConfs().runOnProjectReadiness(task);
        }
    }

    private void addMyListeners() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getConfs().addPropertyChangeListener(this);
        }
    }

    private void removeMyListeners() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            descriptor.getConfs().removePropertyChangeListener(this);
        }
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.projectDescriptorProvider.getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getActiveConfiguration();
        }
        return null;
    }

    public Object getProject() {
        return this.project;
    }

    public List<String> getSourceRoots() {
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null) {
            return descriptor.getAbsoluteSourceRoots();
        }
        return Collections.emptyList();
    }

    public String getProjectRoot() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getPath();
    }

    public String getProjectDisplayName() {
        return ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public List<NativeFileItem> getAllFiles() {
        MakeConfiguration conf;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (descriptor != null && (conf = descriptor.getActiveConfiguration()) != null) {
            Item[] items;
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
            for (Item item : items = descriptor.getProjectItems()) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null) continue;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    list.add(item);
                    continue;
                }
                if (!item.hasHeaderOrSourceExtension(true, true)) continue;
                list.add(item);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<NativeProject> getDependences() {
        List<Object> cachedList = this.cachedDependency.get();
        if (cachedList == null) {
            cachedList = new ArrayList<NativeProject>(0);
            MakeConfiguration makeConfiguration = this.getMakeConfiguration();
            int size = 0;
            NativeProject oneOf = null;
            if (makeConfiguration != null) {
                for (Project lib : makeConfiguration.getSubProjects()) {
                    Project prj = lib;
                    NativeProject nativeProject = (NativeProject)prj.getLookup().lookup(NativeProject.class);
                    if (nativeProject == null) continue;
                    cachedList.add(nativeProject);
                    ++size;
                    oneOf = nativeProject;
                }
            }
            cachedList = size == 0 ? Collections.emptyList() : (size == 1 ? Collections.singletonList(oneOf) : Collections.unmodifiableList(cachedList));
            this.cachedDependency = new SoftReference<List<NativeProject>>(cachedList);
        }
        return cachedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                this.addMyListeners();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsListener(NativeProjectItemsListener listener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.removeMyListeners();
            }
        }
    }

    public void fireFilesAdded(List<NativeFileItem> nativeFileIetms) {
        ArrayList<NativeFileItem> actualList = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileIetm : nativeFileIetms) {
            PredefinedToolKind tool = ((Item)nativeFileIetm).getDefaultTool();
            if (tool == PredefinedToolKind.CustomTool && !"text/x-h".equals(((Item)nativeFileIetm).getMIMEType())) continue;
            actualList.add(nativeFileIetm);
        }
        if (actualList.size() > 0) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                if (actualList.size() == 1) {
                    listener.fileAdded((NativeFileItem)actualList.get(0));
                    continue;
                }
                listener.filesAdded(actualList);
            }
        }
    }

    public void fireFilesRemoved(List<NativeFileItem> nativeFileItems) {
        ArrayList<NativeFileItem> actualList = new ArrayList<NativeFileItem>();
        MakeConfiguration conf = this.getMakeConfiguration();
        for (NativeFileItem nativeFileItem : nativeFileItems) {
            ItemConfiguration itemConfiguration = ((Item)nativeFileItem).getItemConfiguration(conf);
            if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration() && !"text/x-h".equals(((Item)nativeFileItem).getMIMEType())) continue;
            actualList.add(nativeFileItem);
        }
        if (actualList.size() > 0) {
            for (NativeProjectItemsListener listener : this.getListenersCopy()) {
                if (actualList.size() == 1) {
                    listener.fileRemoved((NativeFileItem)actualList.get(0));
                    continue;
                }
                listener.filesRemoved(actualList);
            }
        }
    }

    public void fireFileRenamed(String oldPath, NativeFileItem newNativeFileIetm) {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.fileRenamed(oldPath, newNativeFileIetm);
        }
    }

    public void fireFilePropertiesChanged(NativeFileItem nativeFileIetm) {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.filePropertiesChanged(nativeFileIetm);
        }
    }

    public void fireFilesPropertiesChanged(List<NativeFileItem> fileItems) {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.filesPropertiesChanged(fileItems);
        }
    }

    public void fireFilesPropertiesChanged() {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.filesPropertiesChanged();
        }
    }

    public void fireProjectDeleted() {
        for (NativeProjectItemsListener listener : this.getListenersCopy()) {
            listener.projectDeleted((NativeProject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NativeProjectItemsListener> getListenersCopy() {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<NativeProjectItemsListener>(this.listeners);
        }
    }

    public NativeFileItem findFileItem(File file) {
        MakeConfigurationDescriptor descr = this.getMakeConfigurationDescriptor();
        if (descr != null) {
            return descr.findItemByFile(file);
        }
        return null;
    }

    private void checkConfigurationChanged(final Configuration oldConf, final Configuration newConf) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NativeProjectProvider.this.checkConfigurationChangedWorker(oldConf, newConf);
                }
            });
        } else {
            this.checkConfigurationChangedWorker(oldConf, newConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigurationChangedWorker(Configuration oldConf, Configuration newConf) {
        MakeConfiguration oldMConf = (MakeConfiguration)oldConf;
        MakeConfiguration newMConf = (MakeConfiguration)newConf;
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> added = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> deleted = new ArrayList<NativeFileItem>();
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
        }
        if (newConf == null) {
            System.err.println("Nativeprojectprovider - checkConfigurationChanged - newConf is null!");
            return;
        }
        if (!newConf.isDefault()) {
            return;
        }
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        Item[] items = descriptor.getProjectItems();
        Project proj = descriptor.getProject();
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_CONFIG_CND", descriptor);
        if (oldConf == null) {
            this.firePropertiesChanged(items, true, true, true);
            MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, null);
            MakeLogicalViewProvider.checkForChangedName(proj);
            return;
        }
        if (!oldMConf.getCompilerSet().getName().equals(newMConf.getCompilerSet().getName()) || !oldMConf.getDevelopmentHost().getExecutionEnvironment().equals(newMConf.getDevelopmentHost().getExecutionEnvironment())) {
            this.fireFilesPropertiesChanged();
            MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, null);
            if (!oldMConf.getDevelopmentHost().getExecutionEnvironment().equals(newMConf.getDevelopmentHost().getExecutionEnvironment())) {
                MakeLogicalViewProvider.checkForChangedName(proj);
            }
            return;
        }
        CompilerSet oldCompilerSet = oldMConf.getCompilerSet().getCompilerSet();
        CompilerSet newCompilerSet = newMConf.getCompilerSet().getCompilerSet();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration oldItemConf = items[i].getItemConfiguration(oldMConf);
            ItemConfiguration newItemConf = items[i].getItemConfiguration(newMConf);
            if (oldItemConf == null || newItemConf == null) continue;
            if (newItemConf.getExcluded().getValue() ^ oldItemConf.getExcluded().getValue() && (newItemConf.getTool() == PredefinedToolKind.CCompiler || newItemConf.getTool() == PredefinedToolKind.CCCompiler || items[i].hasHeaderOrSourceExtension(true, true))) {
                if (newItemConf.getExcluded().getValue()) {
                    deleted.add(items[i]);
                } else {
                    added.add(items[i]);
                }
                MakeLogicalViewProvider.checkForChangedViewItemNodes(proj, null, items[i]);
            }
            if (newItemConf.getExcluded().getValue()) continue;
            if (newItemConf.getTool() == PredefinedToolKind.CCompiler) {
                if (oldItemConf.getTool() != PredefinedToolKind.CCompiler) {
                    list.add(items[i]);
                    continue;
                }
                if (oldCompilerSet == null || newCompilerSet == null) {
                    if (oldCompilerSet == null && newCompilerSet == null) continue;
                    list.add(items[i]);
                    continue;
                }
                if (!oldItemConf.getCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                    list.add(items[i]);
                    continue;
                }
                if (!oldItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) {
                    list.add(items[i]);
                    continue;
                }
            }
            if (newItemConf.getTool() != PredefinedToolKind.CCCompiler) continue;
            if (oldItemConf.getTool() != PredefinedToolKind.CCCompiler) {
                list.add(items[i]);
                continue;
            }
            if (oldCompilerSet == null || newCompilerSet == null) {
                if (oldCompilerSet == null && newCompilerSet == null) continue;
                list.add(items[i]);
                continue;
            }
            if (!oldItemConf.getCCCompilerConfiguration().getPreprocessorOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getPreprocessorOptions(newCompilerSet))) {
                list.add(items[i]);
                continue;
            }
            if (oldItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(oldCompilerSet).equals(newItemConf.getCCCompilerConfiguration().getIncludeDirectoriesOptions(newCompilerSet))) continue;
            list.add(items[i]);
        }
        this.fireFilesRemoved(deleted);
        this.fireFilesAdded(added);
        this.firePropertiesChanged(list, true);
    }

    public void checkForChangedItems(final Folder folder, final Item item) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NativeProjectProvider.this.checkForChangedItemsWorker(folder, item);
                }
            });
        } else {
            this.checkForChangedItemsWorker(folder, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangedItemsWorker(Folder folder, Item item) {
        Item[] items;
        this.clearCache();
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
        }
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        boolean cFiles = false;
        boolean ccFiles = false;
        boolean libsChanged = false;
        boolean projectChanged = false;
        VectorConfiguration<String> cIncludeDirectories = null;
        BooleanConfiguration cInheritIncludes = null;
        VectorConfiguration<String> cPpreprocessorOption = null;
        BooleanConfiguration cInheritMacros = null;
        VectorConfiguration<String> ccIncludeDirectories = null;
        BooleanConfiguration ccInheritIncludes = null;
        VectorConfiguration<String> ccPreprocessorOption = null;
        BooleanConfiguration ccInheritMacros = null;
        MakeConfigurationDescriptor descriptor = this.getMakeConfigurationDescriptor();
        if (makeConfiguration.getDevelopmentHost().getDirty()) {
            makeConfiguration.getDevelopmentHost().setDirty(false);
            Item[] items2 = descriptor.getProjectItems();
            this.firePropertiesChanged(items2, true, true, true);
            return;
        }
        if (makeConfiguration.getCompilerSet().getDirty()) {
            makeConfiguration.getCompilerSet().setDirty(false);
            Item[] items3 = descriptor.getProjectItems();
            this.firePropertiesChanged(items3, true, true, true);
            return;
        }
        if (folder != null) {
            FolderConfiguration folderConfiguration = folder.getFolderConfiguration(makeConfiguration);
            cIncludeDirectories = folderConfiguration.getCCompilerConfiguration().getIncludeDirectories();
            cInheritIncludes = folderConfiguration.getCCompilerConfiguration().getInheritIncludes();
            cPpreprocessorOption = folderConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration();
            cInheritMacros = folderConfiguration.getCCompilerConfiguration().getInheritPreprocessor();
            ccIncludeDirectories = folderConfiguration.getCCCompilerConfiguration().getIncludeDirectories();
            ccInheritIncludes = folderConfiguration.getCCCompilerConfiguration().getInheritIncludes();
            ccPreprocessorOption = folderConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration();
            ccInheritMacros = folderConfiguration.getCCCompilerConfiguration().getInheritPreprocessor();
            items = folder.getAllItemsAsArray();
        } else if (item != null) {
            ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
            if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                cIncludeDirectories = itemConfiguration.getCCompilerConfiguration().getIncludeDirectories();
                cInheritIncludes = itemConfiguration.getCCompilerConfiguration().getInheritIncludes();
                cInheritMacros = itemConfiguration.getCCompilerConfiguration().getInheritPreprocessor();
                cPpreprocessorOption = itemConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration();
                if (itemConfiguration.getCCompilerConfiguration().getCommandLineConfiguration().getDirty()) {
                    itemConfiguration.getCCompilerConfiguration().getCommandLineConfiguration().setDirty(false);
                    cFiles = true;
                }
            }
            if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                ccIncludeDirectories = itemConfiguration.getCCCompilerConfiguration().getIncludeDirectories();
                ccInheritIncludes = itemConfiguration.getCCCompilerConfiguration().getInheritIncludes();
                ccPreprocessorOption = itemConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration();
                ccInheritMacros = itemConfiguration.getCCCompilerConfiguration().getInheritPreprocessor();
                if (itemConfiguration.getCCCompilerConfiguration().getCommandLineConfiguration().getDirty()) {
                    itemConfiguration.getCCCompilerConfiguration().getCommandLineConfiguration().setDirty(false);
                    ccFiles = true;
                }
            }
            if (itemConfiguration.getExcluded().getDirty()) {
                itemConfiguration.getExcluded().setDirty(false);
                ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
                list.add(item);
                if (itemConfiguration.getExcluded().getValue()) {
                    this.fireFilesRemoved(list);
                } else {
                    this.fireFilesAdded(list);
                }
            }
            items = new Item[]{item};
        } else {
            libsChanged = makeConfiguration.getRequiredProjectsConfiguration().getDirty() || makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration().getDirty();
            cIncludeDirectories = makeConfiguration.getCCompilerConfiguration().getIncludeDirectories();
            cInheritIncludes = makeConfiguration.getCCompilerConfiguration().getInheritIncludes();
            cPpreprocessorOption = makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration();
            if (makeConfiguration.getCCompilerConfiguration().getCommandLineConfiguration().getDirty()) {
                makeConfiguration.getCCompilerConfiguration().getCommandLineConfiguration().setDirty(false);
                cFiles = true;
            }
            cInheritMacros = makeConfiguration.getCCompilerConfiguration().getInheritPreprocessor();
            ccIncludeDirectories = makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories();
            ccInheritIncludes = makeConfiguration.getCCCompilerConfiguration().getInheritIncludes();
            ccPreprocessorOption = makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration();
            ccInheritMacros = makeConfiguration.getCCCompilerConfiguration().getInheritPreprocessor();
            if (makeConfiguration.getCCCompilerConfiguration().getCommandLineConfiguration().getDirty()) {
                makeConfiguration.getCCCompilerConfiguration().getCommandLineConfiguration().setDirty(false);
                ccFiles = true;
            }
            items = descriptor.getProjectItems();
            projectChanged = true;
        }
        if (cIncludeDirectories != null && (cIncludeDirectories.getDirty() || cPpreprocessorOption.getDirty() || cInheritIncludes.getDirty() || cInheritMacros.getDirty())) {
            cFiles = true;
            cIncludeDirectories.setDirty(false);
            cPpreprocessorOption.setDirty(false);
            cInheritIncludes.setDirty(false);
            cInheritMacros.setDirty(false);
        }
        if (ccIncludeDirectories != null && (ccIncludeDirectories.getDirty() || ccPreprocessorOption.getDirty() || ccInheritIncludes.getDirty() || ccInheritMacros.getDirty())) {
            ccFiles = true;
            ccIncludeDirectories.setDirty(false);
            ccPreprocessorOption.setDirty(false);
            ccInheritIncludes.setDirty(false);
            ccInheritMacros.setDirty(false);
        }
        if (libsChanged) {
            makeConfiguration.getRequiredProjectsConfiguration().setDirty(false);
            makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration().setDirty(false);
            cFiles = true;
            ccFiles = true;
        }
        if (cFiles || ccFiles) {
            this.firePropertiesChanged(items, cFiles, ccFiles, projectChanged);
        }
    }

    private void firePropertiesChanged(Item[] items, boolean cFiles, boolean ccFiles, boolean projectChanged) {
        ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> deleted = new ArrayList<NativeFileItem>();
        MakeConfiguration conf = this.getMakeConfiguration();
        for (int i = 0; i < items.length; ++i) {
            ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
            if (itemConfiguration == null) continue;
            if (itemConfiguration.getExcluded().getValue()) {
                deleted.add(items[i]);
                continue;
            }
            if (!(cFiles && itemConfiguration.getTool() == PredefinedToolKind.CCompiler || ccFiles && itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) && !items[i].hasHeaderOrSourceExtension(cFiles, ccFiles)) continue;
            list.add(items[i]);
        }
        if (deleted.size() > 0) {
            this.fireFilesRemoved(deleted);
        }
        this.firePropertiesChanged(list, projectChanged);
    }

    private void firePropertiesChanged(List<NativeFileItem> list, boolean projectChanged) {
        if (list.size() > 1 || projectChanged && list.size() == 1) {
            this.fireFilesPropertiesChanged(list);
        } else if (list.size() == 1) {
            this.fireFilePropertiesChanged(list.get(0));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("activeconfiguration")) {
            this.checkConfigurationChanged((Configuration)evt.getOldValue(), (Configuration)evt.getNewValue());
        }
    }

    public List<String> getSystemIncludePaths() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (compiler != null) {
                vec.addAll(compiler.getSystemIncludeDirectories());
            }
        }
        return vec;
    }

    public List<String> getUserIncludePaths() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            ArrayList<String> vec2 = new ArrayList<String>();
            vec2.addAll(cccCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iter = vec2.iterator();
            while (iter.hasNext()) {
                vec.add(CndPathUtilitities.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)((String)iter.next())));
            }
        }
        return vec;
    }

    public List<String> getSystemMacroDefinitions() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return vec;
            }
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            if (compiler != null) {
                vec.addAll(compiler.getSystemPreprocessorSymbols());
            }
        }
        return vec;
    }

    public List<String> getUserMacroDefinitions() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            vec.addAll(cccCompilerConfiguration.getPreprocessorConfiguration().getValue());
        }
        return vec;
    }

    public String toString() {
        return this.getProjectDisplayName() + " " + this.getProjectRoot();
    }

    private void clearCache() {
        this.cachedDependency.clear();
    }

    public NativeExitStatus execute(String executable, String[] env, String ... args) throws IOException {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ExecutionEnvironment ev = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        if (ev.isLocal()) {
            String line;
            String exePath = Path.findCommand((String)executable);
            if (exePath == null) {
                throw new IOException(NativeProjectProvider.getString("NOT_FOUND", executable));
            }
            String arguments = "";
            for (String s : args) {
                arguments = arguments + " " + s;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StringBuilder output = new StringBuilder();
            Process p0 = Runtime.getRuntime().exec(exePath + " " + arguments, env);
            InputStream is = p0.getInputStream();
            InputStreamReader ist = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(ist);
            while ((line = br.readLine()) != null) {
                output.append(line).append("\n");
            }
            br.close();
            ist.close();
            is.close();
            bos.close();
            return new NativeExitStatus(0, output.toString(), "");
        }
        ServerRecord record = ServerList.get((ExecutionEnvironment)ev);
        if (!record.isOnline()) {
            return new NativeExitStatus(-1, "", NativeProjectProvider.getString("HOST_OFFLINE", ev.getHost()));
        }
        try {
            ProcessUtils.ExitStatus exitStatus = ProcessUtils.execute((ExecutionEnvironment)ev, (String)executable, (String[])args);
            return new NativeExitStatus(exitStatus.exitCode, exitStatus.output, exitStatus.error);
        }
        catch (Exception e) {
            return new NativeExitStatus(-1, "", e.getMessage());
        }
    }

    public String getPlatformName() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        String platformName = makeConfiguration.getDevelopmentHost().getBuildPlatformName();
        return platformName;
    }

    private static String getString(String s, String s2) {
        return NbBundle.getMessage(NativeProjectProvider.class, (String)s, (Object)s2);
    }
}

