/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.add.AddExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SwitchBranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_SwitchBranch";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 1208;
    }

    @Override
    public void performCvsAction(final Node[] nodes) {
        final Context context = this.getContext(nodes);
        String title = MessageFormat.format(NbBundle.getBundle(SwitchBranchAction.class).getString("CTL_SwitchBranchDialog_Title"), this.getContextDisplayName(nodes));
        final SwitchBranchPanel settings = new SwitchBranchPanel(context.getFiles());
        JButton swich = new JButton(NbBundle.getMessage(SwitchBranchAction.class, (String)"CTL_SwitchBranchDialog_Action_Switch"));
        swich.setToolTipText(NbBundle.getMessage(SwitchBranchAction.class, (String)"TT_SwitchBranchDialog_Action_Switch"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, title, true, new Object[]{swich, DialogDescriptor.CANCEL_OPTION}, (Object)swich, 0, new HelpCtx(SwitchBranchAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchBranchAction.class, (String)"ACSD_SwitchBranchDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != swich) {
            return;
        }
        settings.saveSettings();
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                SwitchBranchAction.this.switchBranch(nodes, context, settings);
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    private void switchBranch(Node[] nodes, Context context, final SwitchBranchPanel settings) {
        GlobalOptions options;
        ArrayList<File> newFolders = new ArrayList<File>();
        ArrayList<File> others = new ArrayList<File>();
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        ExecutorGroup group = new ExecutorGroup(this.getRunningName(nodes));
        File[][] flatRecursive = Utils.splitFlatOthers((File[])context.getRootFiles());
        if (flatRecursive[0].length > 0) {
            File[] flat = flatRecursive[0];
            UpdateCommand cmd = new UpdateCommand();
            if (settings.isSwitchToTrunk()) {
                cmd.setResetStickyOnes(true);
            } else {
                cmd.setUpdateByRevision(settings.getBranchName());
            }
            cmd.setBuildDirectories(true);
            cmd.setPruneDirectories(true);
            cmd.setRecursive(false);
            cmd.setFiles(flat);
            options = CvsVersioningSystem.createGlobalOptions();
            if (context.getExclusions().size() > 0) {
                options.setExclusions(context.getExclusions().toArray(new File[context.getExclusions().size()]));
            }
            group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options, this.getContextDisplayName(nodes)));
        }
        if (flatRecursive[1].length > 0) {
            File[] roots = flatRecursive[1];
            for (int i = 0; i < roots.length; ++i) {
                File root = roots[i];
                if (root.isDirectory() && cache.getStatus(root).getStatus() == 4) {
                    newFolders.add(root);
                    continue;
                }
                others.add(root);
            }
            if (newFolders.size() > 0) {
                AddCommand acmd = new AddCommand();
                final File[] files = newFolders.toArray(new File[newFolders.size()]);
                acmd.setFiles(files);
                group.addExecutors(AddExecutor.splitCommand(acmd, CvsVersioningSystem.getInstance(), null));
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        if (settings.isSwitchToTrunk()) {
                            SwitchBranchAction.this.setSticky(files, null);
                        } else {
                            SwitchBranchAction.this.setSticky(files, settings.getBranchName());
                        }
                    }
                };
                group.addBarrier(action);
                others.addAll(newFolders);
            }
            if (others.size() > 0) {
                UpdateCommand cmd = new UpdateCommand();
                if (settings.isSwitchToTrunk()) {
                    cmd.setResetStickyOnes(true);
                } else {
                    cmd.setUpdateByRevision(settings.getBranchName());
                }
                cmd.setBuildDirectories(true);
                cmd.setPruneDirectories(true);
                cmd.setFiles(others.toArray(new File[others.size()]));
                options = CvsVersioningSystem.createGlobalOptions();
                if (context.getExclusions().size() > 0) {
                    options.setExclusions(context.getExclusions().toArray(new File[context.getExclusions().size()]));
                }
                group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options, this.getContextDisplayName(nodes)));
            }
        }
        group.execute();
    }

    private void setSticky(File[] files, String sticky) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                this.setSticky(file, sticky);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void setSticky(File file, String sticky) throws IOException {
        File tag = new File(file, "CVS/Tag");
        tag.delete();
        if ("HEAD".equals(sticky)) {
            return;
        }
        if (sticky != null) {
            FileWriter w = new FileWriter(tag);
            w.write("T");
            w.write(sticky);
            w.write(System.getProperty("line.separator"));
            w.close();
        }
    }
}

