/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi.impl;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.Cards;
import org.netbeans.modules.javacard.spi.DeviceManagerDialogProvider;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.PlatformAndDeviceProvider;
import org.netbeans.modules.javacard.spi.impl.SettableProxyLookup;
import org.netbeans.swing.layouts.SharedLayoutPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DevicePanel
extends SharedLayoutPanel
implements ExplorerManager.Provider,
ActionListener,
PropertyChangeListener {
    private final ExplorerManager mgr = new ExplorerManager();
    private ExplorerManager parentManager;
    private PlatformAndDeviceProvider props;
    private final SettableProxyLookup lkp = new SettableProxyLookup();
    private final ChoiceView choice = new ChoiceView();
    private final JButton button = new JButton(NbBundle.getMessage(DevicePanel.class, (String)"LBL_MANAGE_DEVICES"));
    private final JLabel lbl = new JLabel(NbBundle.getMessage(DevicePanel.class, (String)"LBL_DEVICES"));

    public DevicePanel() {
        this(null);
    }

    public DevicePanel(PlatformAndDeviceProvider props) {
        this.add(this.lbl);
        this.add((Component)this.choice);
        this.add(this.button);
        this.button.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.button.getText());
        Mnemonics.setLocalizedText((JLabel)this.lbl, (String)this.lbl.getText());
        this.lbl.setLabelFor((Component)this.choice);
        this.mgr.setRootContext(this.noPlatformNode());
        this.mgr.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    DevicePanel.this.updateLookup();
                    Lookup b = DevicePanel.this.mgr.getSelectedNodes().length > 0 ? DevicePanel.this.mgr.getSelectedNodes()[0].getLookup() : Lookup.EMPTY;
                    Card card = (Card)b.lookup(Card.class);
                    if (DevicePanel.this.props != null && card != null) {
                        DevicePanel.this.props.setActiveDevice(card.getSystemId());
                    }
                }
            }
        });
        if (props != null) {
            this.setPlatformAndDevice(props);
        }
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    void setRoot(Node n) {
        this.mgr.setRootContext(n);
    }

    void setSelectedNode(Node n) {
        try {
            if (n != null) {
                this.mgr.setSelectedNodes(new Node[]{n});
            } else {
                this.mgr.setSelectedNodes(new Node[0]);
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    private Node noPlatformNode() {
        AbstractNode result = new AbstractNode(Children.LEAF);
        result.setIconBaseWithExtension("org/netbeans/modules/javacard/resources/empty.png");
        result.setDisplayName(NbBundle.getMessage(DevicePanel.class, (String)"LBL_NO_PLATFORM_SELECTED"));
        return result;
    }

    private Node invalidPlatformNode() {
        AbstractNode result = new AbstractNode(Children.LEAF);
        result.setIconBaseWithExtension("org/netbeans/modules/javacard/resources/empty.png");
        result.setDisplayName(NbBundle.getMessage(DevicePanel.class, (String)"LBL_INVALID_PLATFORM_SELECTED"));
        return result;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager.Provider prov = (ExplorerManager.Provider)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, (Component)((Object)this));
        if (prov != null) {
            this.parentManager = prov.getExplorerManager();
            this.parentManager.addPropertyChangeListener((PropertyChangeListener)this);
            this.propertyChange(null);
        }
    }

    public void removeNotify() {
        if (this.parentManager != null) {
            this.parentManager.removePropertyChangeListener((PropertyChangeListener)this);
            this.parentManager = null;
        }
        super.removeNotify();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataObject dob = Utils.findPlatformDataObjectNamed((String)this.props.getPlatformName());
        assert (dob != null) : "Button invoked w/o any selected platform";
        DeviceManagerDialogProvider prov = (DeviceManagerDialogProvider)dob.getLookup().lookup(DeviceManagerDialogProvider.class);
        assert (prov != null);
        prov.showManageDevicesDialog((Component)((Object)this));
    }

    private void updateLookup() {
        Lookup a = this.parentManager == null || this.parentManager.getSelectedNodes().length == 0 ? Lookup.EMPTY : this.parentManager.getSelectedNodes()[0].getLookup();
        Lookup b = this.mgr.getSelectedNodes().length > 0 ? this.mgr.getSelectedNodes()[0].getLookup() : Lookup.EMPTY;
        this.lkp.setFirstLookup(a);
        this.lkp.setSecondLookup(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || "rootContext".equals(evt.getPropertyName()) || "selectedNodes".equals(evt.getPropertyName())) {
            JavacardPlatform pform;
            Node[] sel = this.parentManager.getSelectedNodes();
            final String cardName = this.props.getActiveDevice();
            JavacardPlatform javacardPlatform = pform = sel == null || sel.length == 0 ? null : (JavacardPlatform)((Object)sel[0].getLookup().lookup(JavacardPlatform.class));
            if (pform == null || !pform.isValid()) {
                this.setRoot(this.invalidPlatformNode());
                this.button.setEnabled(false);
                this.choice.setEnabled(false);
            } else {
                Cards cards = pform.getCards();
                this.setRoot((Node)new AbstractNode(cards.createChildren(cardName)));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Node n;
                        Node[] nds;
                        Node selNode = null;
                        for (Node n2 : nds = DevicePanel.this.mgr.getRootContext().getChildren().getNodes(true)) {
                            Card card = (Card)n2.getLookup().lookup(Card.class);
                            if (card == null || !cardName.equals(card.getSystemId())) continue;
                            selNode = n2;
                            break;
                        }
                        if ((n = DevicePanel.this.mgr.getRootContext().getChildren().findChild(cardName)) != null) {
                            boolean enableButton;
                            DevicePanel.this.setSelectedNode(n);
                            Card c = (Card)n.getLookup().lookup(Card.class);
                            boolean bl = enableButton = c != null && c.isValid();
                            if (enableButton) {
                                enableButton = DevicePanel.this.parentManager.getSelectedNodes()[0].getLookup().lookup(DeviceManagerDialogProvider.class) != null;
                            }
                            DevicePanel.this.button.setEnabled(enableButton);
                            DevicePanel.this.choice.setEnabled(true);
                        } else {
                            DevicePanel.this.button.setEnabled(false);
                            DevicePanel.this.choice.setEnabled(true);
                        }
                    }
                });
            }
        }
        this.updateLookup();
    }

    public void setPlatformAndDevice(PlatformAndDeviceProvider props) {
        this.props = props;
    }
}

