/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class JavacardPlatformChildren
extends ChildFactory.Detachable<FileObject>
implements FileChangeListener,
Runnable {
    private final FileObject folder;
    protected List<Node> nodes = new ArrayList<Node>();
    private int createNodeCount;
    private volatile int keysCount;

    public static Children createChildren() {
        return Children.create((ChildFactory)new JavacardPlatformChildren(), (boolean)false);
    }

    private FileObject getFolder() {
        return this.folder;
    }

    private JavacardPlatformChildren(FileObject folder) {
        this.folder = folder;
    }

    public JavacardPlatformChildren() {
        this((String)null);
    }

    public JavacardPlatformChildren(String expectedName) {
        this(Utils.sfsFolderForRegisteredJavaPlatforms((String)expectedName));
    }

    protected void addNotify() {
        super.addNotify();
        FileObject fld = this.getFolder();
        if (fld != null) {
            fld.addFileChangeListener((FileChangeListener)this);
        }
    }

    protected void removeNotify() {
        super.removeNotify();
        this.keysCount = 0;
        this.createNodeCount = 0;
        FileObject fld = this.getFolder();
        if (fld != null) {
            fld.removeFileChangeListener((FileChangeListener)this);
        }
        this.nodes.clear();
    }

    protected Node findNodeNamed(String name) {
        for (Node n : this.nodes) {
            String nm = ((DataObject)n.getLookup().lookup(DataObject.class)).getName();
            if (!name.equals(nm)) continue;
            return n;
        }
        return this.nodes.isEmpty() ? null : this.nodes.get(0);
    }

    protected Node createNodeForKey(FileObject key) {
        try {
            FilterNode result = new FilterNode(DataObject.find((FileObject)key).getNodeDelegate(), this.createChildren(key));
            ++this.createNodeCount;
            if (this.createNodeCount == this.keysCount) {
                EventQueue.invokeLater(this);
            }
            this.nodes.add((Node)result);
            return result;
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Node.EMPTY;
        }
    }

    protected boolean createKeys(List<FileObject> files) {
        this.keysCount = 0;
        FileObject fld = this.getFolder();
        if (fld != null) {
            for (FileObject f : fld.getChildren()) {
                try {
                    if (!"jcplatform".equals(f.getExt()) && DataObject.find((FileObject)f).getNodeDelegate().getLookup().lookup(JavacardPlatform.class) == null) continue;
                    ++this.keysCount;
                    files.add(f);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return true;
    }

    protected Children createChildren(FileObject key) {
        return Children.LEAF;
    }

    public void fileFolderCreated(FileEvent arg0) {
        this.queueRefresh();
    }

    public void fileDataCreated(FileEvent arg0) {
        this.queueRefresh();
    }

    public void fileChanged(FileEvent arg0) {
        this.queueRefresh();
    }

    public void fileDeleted(FileEvent arg0) {
        this.queueRefresh();
    }

    public void fileRenamed(FileRenameEvent arg0) {
        this.queueRefresh();
    }

    private void queueRefresh() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavacardPlatformChildren.this.refresh(false);
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent arg0) {
    }

    @Override
    public void run() {
        this.onAllNodesCreated();
    }

    void onAllNodesCreated() {
    }
}

