/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public class NbinstURLMapper
extends URLMapper {
    public static final String PROTOCOL = "nbinst";
    private static final Logger LOG = Logger.getLogger(NbinstURLMapper.class.getName());

    public FileObject[] getFileObjects(URL url) {
        return PROTOCOL.equals(url.getProtocol()) ? NbinstURLMapper.decodeURL(url) : null;
    }

    public URL getURL(FileObject fo, int type) {
        return null;
    }

    static FileObject[] decodeURL(URL url) {
        assert (url != null);
        try {
            URI uri = new URI(url.toExternalForm());
            String protocol = uri.getScheme();
            if (PROTOCOL.equals(protocol)) {
                String module = uri.getHost();
                String path = uri.getPath();
                if (path.length() > 0) {
                    String relpath = path.substring(1).replaceFirst("/$", "");
                    File file = InstalledFileLocator.getDefault().locate(relpath, module, false);
                    if (file != null) {
                        try {
                            FileObject fo = URLMapper.findFileObject((URL)file.toURI().toURL());
                            if (fo != null) {
                                return new FileObject[]{fo};
                            }
                            LOG.log(Level.WARNING, "could find no FileObject for {0}", file);
                        }
                        catch (MalformedURLException x) {
                            LOG.log(Level.WARNING, null, x);
                        }
                    }
                }
            }
        }
        catch (URISyntaxException x) {
            LOG.log(Level.WARNING, null, x);
        }
        return null;
    }
}

