/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorString
extends PropertyEditorUserCode
implements PropertyEditorElement {
    public static final int DEPENDENCE_NONE = 0;
    public static final int DEPENDENCE_TEXT_BOX = 1;
    public static final int DEPENDENCE_TEXT_FIELD = 2;
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private int dependence;
    private String comment;
    private String defaultValue;
    private boolean useTextArea;
    private TypeID parentTypeID;
    private String label;
    private DatabindingElement databindingElement;
    private boolean databinding;

    protected PropertyEditorString(String comment, int dependence, boolean useTextArea, String label, TypeID parentTypeID, boolean databinding) {
        super(NbBundle.getMessage(PropertyEditorString.class, (String)"LBL_STRING_STR"));
        this.comment = comment;
        this.dependence = dependence;
        this.useTextArea = useTextArea;
        this.label = label;
        this.parentTypeID = parentTypeID;
        this.databinding = databinding;
    }

    private PropertyEditorString(String comment, int dependence, String defaultValue, String label, boolean databinding) {
        this(comment, dependence, true, label, null, databinding);
        this.defaultValue = defaultValue;
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String comment, int dependence, String defaultValue, String label) {
        return new PropertyEditorString(comment, dependence, defaultValue, label, true);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String comment, int dependence, boolean useTextArea, String label, TypeID parentTypeID) {
        return new PropertyEditorString(comment, dependence, useTextArea, label, parentTypeID, true);
    }

    public static final PropertyEditorString createInstance(String label) {
        return new PropertyEditorString(null, 0, true, label, null, false);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String label) {
        return new PropertyEditorString(null, 0, true, label, null, true);
    }

    public static final PropertyEditorString createInstance(int dependence, String label) {
        return new PropertyEditorString(null, dependence, true, label, null, false);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(int dependence, String label) {
        return new PropertyEditorString(null, dependence, true, label, null, true);
    }

    public static final PropertyEditorString createInstance(String label, TypeID parentTypeID) {
        return new PropertyEditorString(null, 0, true, label, parentTypeID, false);
    }

    public static final PropertyEditorString createTextFieldInstance(String label) {
        return new PropertyEditorString(null, 0, false, label, null, false);
    }

    public static final PropertyEditorString createInstanceWithDefaultValue(String defaultValue, String label) {
        return new PropertyEditorString(null, 0, defaultValue, label, false);
    }

    public static final PropertyEditorString createInstanceWithComment(String comment, String label) {
        return new PropertyEditorString(comment, 0, null, label, false);
    }

    @Override
    public void cleanUp(DesignComponent component) {
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
        if (this.databindingElement != null) {
            this.databindingElement.clean(component);
            this.databindingElement = null;
        }
        super.cleanUp(component);
    }

    @Override
    public final Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            if (this.databinding) {
                LinkedHashMap<PropertyEditorElement, Integer> elements = new LinkedHashMap<PropertyEditorElement, Integer>(2);
                this.databindingElement = new DatabindingElement(this);
                elements.put(this, null);
                elements.put(this.databindingElement, new Integer(-1));
                this.initElements(elements);
            } else {
                this.initElements(Collections.singleton(this));
            }
        } else {
            PropertyValue value = (PropertyValue)this.getValue();
            this.updateState(value);
        }
        return super.getCustomEditor();
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor(this.comment);
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return super.getDefaultValue();
        }
        return MidpTypes.createStringValue(this.defaultValue);
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor.getComponent();
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return this.useTextArea;
    }

    @Override
    public String getAsText() {
        if (this.component == null || this.getPropertyNames() == null) {
            return null;
        }
        String databinding = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (databinding != null) {
            return databinding;
        }
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return (String)value.getPrimitiveValue();
    }

    @Override
    public void setAsText(String text) {
        this.saveValue(text);
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    @Override
    public Boolean canEditAsText() {
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            return false;
        }
        return super.canEditAsText();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    @Override
    public void updateState(PropertyValue value) {
        DesignComponent c = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(c);
        }
        boolean updateCustomEditor = true;
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setText(null);
            updateCustomEditor = false;
        }
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(c);
            updateCustomEditor = false;
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(c);
        }
        if (updateCustomEditor) {
            this.customEditor.setText((String)value.getPrimitiveValue());
        }
        if (!this.isCurrentValueAUserCodeType() && this.databindingElement == null) {
            this.radioButton.setSelected(true);
            this.radioButton.requestFocus();
        }
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return true;
        }
        DesignComponent component_ = (DesignComponent)this.component.get();
        DesignComponent connector = MidpDatabindingSupport.getConnector(component_, (String)this.getPropertyNames().get(0));
        if (this.databindingElement != null && connector != null) {
            return false;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    @Override
    public boolean isExecuteInsideWriteTransactionUsed() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent component_ = (DesignComponent)this.component.get();
        DesignComponent connector = MidpDatabindingSupport.getConnector(component_, (String)this.getPropertyNames().get(0));
        if (this.databindingElement != null && connector != null) {
            return true;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    private void saveValue(String text) {
        super.setValue((Object)MidpTypes.createStringValue(text));
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent _component = (DesignComponent)this.component.get();
        final int length = text.length();
        switch (this.dependence) {
            case 1: {
                _component.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        PropertyValue value = _component.readProperty("maxSize");
                        if (MidpTypes.getInteger(value) < length) {
                            _component.writeProperty("maxSize", MidpTypes.createIntegerValue(length));
                        }
                    }
                });
                break;
            }
            case 2: {
                _component.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        PropertyValue value = _component.readProperty("maxSize");
                        if (MidpTypes.getInteger(value) < length) {
                            _component.writeProperty("maxSize", MidpTypes.createIntegerValue(length));
                        }
                    }
                });
            }
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
        DesignComponent _component = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(_component);
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(_component);
        }
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            final DesignComponent[] parent = new DesignComponent[1];
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    parent[0] = _component.getParentComponent();
                }
            });
            if (parent[0] != null && this.parentTypeID.equals((Object)parent[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    implements DocumentListener {
        private JPanel panel;
        private JTextComponent editorPane;
        private String comment;

        public CustomEditor(String comment) {
            this.comment = comment;
            this.initComponents();
        }

        void cleanUp() {
            if (this.editorPane != null && this.editorPane.getDocument() != null) {
                this.editorPane.getDocument().removeDocumentListener(this);
            }
            this.editorPane = null;
            this.panel.removeAll();
            this.panel = null;
        }

        private void initComponents() {
            JComponent textComponent;
            this.panel = new JPanel(new GridBagLayout());
            if (PropertyEditorString.this.useTextArea) {
                this.editorPane = new JTextArea();
                textComponent = new JScrollPane();
                ((JScrollPane)textComponent).setViewportView(this.editorPane);
                ((JScrollPane)textComponent).setPreferredSize(new Dimension(400, 100));
            } else {
                this.editorPane = new JTextField();
                textComponent = this.editorPane;
            }
            JLabel tempLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)tempLabel, (String)PropertyEditorString.this.label);
            this.editorPane.getAccessibleContext().setAccessibleName(tempLabel.getText());
            this.editorPane.getAccessibleContext().setAccessibleDescription(tempLabel.getText());
            tempLabel = null;
            this.editorPane.getDocument().addDocumentListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.panel.add((Component)textComponent, gridBagConstraints);
            if (this.comment != null) {
                JLabel label = new JLabel(this.comment);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.ipadx = 1;
                gridBagConstraints.ipady = 10;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.panel.add((Component)label, gridBagConstraints);
            }
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public void setText(String text) {
            this.editorPane.setText(text);
        }

        public String getText() {
            return this.editorPane.getText();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

