/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;

public class DocOffsPositionImpl
implements CsmOffsetable.Position {
    private int line;
    private int col;
    private final int offset;
    private final BaseDocument doc;

    public DocOffsPositionImpl(BaseDocument doc, int offset) {
        this(-1, -1, offset, doc);
    }

    public DocOffsPositionImpl(CsmOffsetable.Position pos) {
        if (pos != null) {
            this.line = pos.getLine();
            this.col = pos.getColumn();
            this.offset = pos.getOffset();
        } else {
            this.line = -1;
            this.col = -1;
            this.offset = 0;
        }
        this.doc = null;
    }

    public DocOffsPositionImpl(int line, int col, int offset, BaseDocument doc) {
        this.line = line;
        this.col = col;
        this.offset = offset;
        this.doc = doc;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLine() {
        return this.getLine(true);
    }

    public int getColumn() {
        return this.getColumn(true);
    }

    public int getLine(boolean create) {
        if (create && this.line == -1 && this.doc != null) {
            try {
                this.line = Utilities.getLineOffset((BaseDocument)this.doc, (int)this.offset) + 1;
            }
            catch (BadLocationException ex) {
                this.line = -1;
            }
        }
        return this.line;
    }

    public int getColumn(boolean create) {
        if (create && this.col == -1 && this.doc != null) {
            try {
                this.col = Utilities.getVisualColumn((BaseDocument)this.doc, (int)this.offset) + 1;
            }
            catch (BadLocationException ex) {
                this.col = -1;
            }
        }
        return this.col;
    }

    BaseDocument getDocument() {
        return this.doc;
    }

    public String toString() {
        return "" + this.getLine(true) + ':' + this.getColumn(true) + '/' + this.getOffset();
    }
}

