/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.FunctionCallsProvider;
import org.openide.text.NbDocument;

public class CsmFunctionCallsProviderImpl
implements FunctionCallsProvider {
    public List<CsmReference> getFunctionCalls(StyledDocument document, int line) {
        if (line < 0 || document == null) {
            return Collections.emptyList();
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false, (boolean)false);
        if (csmFile == null || !csmFile.isParsed()) {
            return Collections.emptyList();
        }
        Element lineRootElement = NbDocument.findLineRootElement((StyledDocument)document);
        return CsmFunctionCallsProviderImpl.getFunctionCalls(csmFile, lineRootElement, line);
    }

    private static List<CsmReference> getFunctionCalls(CsmFile csmFile, Element lineRootElement, int line) {
        int lineEndOffset;
        CsmOffsetable statementEnd;
        Element lineElem = lineRootElement.getElement(line);
        if (lineElem == null) {
            return Collections.emptyList();
        }
        int lineStartOffset = lineElem.getStartOffset();
        CsmOffsetable statementStart = CsmFunctionCallsProviderImpl.getStatement(csmFile, lineStartOffset);
        if (statementStart != null) {
            lineStartOffset = statementStart.getStartOffset();
        }
        if ((statementEnd = CsmFunctionCallsProviderImpl.getStatement(csmFile, lineEndOffset = lineElem.getEndOffset())) != null) {
            lineEndOffset = statementEnd.getEndOffset();
        }
        final int startOffset = lineStartOffset;
        final int endOffset = lineEndOffset;
        final ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext context) {
                CsmFunction function;
                CsmObject referencedObject;
                if (cancelled.get()) {
                    return;
                }
                CsmReference reference = context.getReference();
                if (startOffset <= reference.getStartOffset() && reference.getEndOffset() <= endOffset && CsmKindUtilities.isFunction((CsmObject)(referencedObject = reference.getReferencedObject())) && !CsmFunctionCallsProviderImpl.fromStd((CsmScopeElement)(function = (CsmFunction)referencedObject))) {
                    CsmScope scope = function.getScope();
                    if (!CsmKindUtilities.isNamespace((Object)scope) || !((CsmNamespace)scope).isGlobal()) {
                        cancelled.set(true);
                        return;
                    }
                    res.add(reference);
                }
            }
        });
        if (cancelled.get()) {
            return Collections.emptyList();
        }
        return res;
    }

    private static CsmOffsetable getStatement(CsmFile csmFile, int offset) {
        CsmContext context = CsmOffsetResolver.findContext(csmFile, offset, null);
        CsmScope scope = context.getLastScope();
        for (CsmScopeElement csmScopeElement : scope.getScopeElements()) {
            CsmOffsetable offs;
            if (!CsmKindUtilities.isOffsetable((Object)csmScopeElement) || (offs = (CsmOffsetable)csmScopeElement).getEndOffset() < offset) continue;
            if (offs.getStartOffset() > offset || CsmKindUtilities.isCompoundStatement((CsmObject)offs)) {
                return null;
            }
            return offs;
        }
        return null;
    }

    private static boolean fromStd(CsmScopeElement object) {
        CsmScope scope = object.getScope();
        return CsmKindUtilities.isNamespace((Object)scope) && "std".equals(((Object)((CsmNamespace)scope).getQualifiedName()).toString());
    }
}

