/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.util;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class ServerUtils {
    private static final Logger logger = Logger.getLogger(Util.class.getName());
    public static final String DEVNULL = "DEV-NULL";
    public static final String BUNDLED_TOMCAT_SETTING = "J2EE/BundledTomcat/Setting";

    public static J2eePlatform getJ2eePlatform(Project project) {
        String string = ServerUtils.getServerInstanceID(project);
        if (string != null && string.length() > 0 && !DEVNULL.equals(string)) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Exceptions.printStackTrace((Throwable)instanceRemovedException);
            }
        }
        return null;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider j2eeModuleProvider;
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            return j2eeModuleProvider.getServerInstanceID();
        }
        return null;
    }

    public static String getServerName(Project project) {
        String string = ServerUtils.getServerInstanceID(project);
        if (string != null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                return j2eePlatform.getDisplayName();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Exceptions.printStackTrace((Throwable)instanceRemovedException);
            }
        }
        return null;
    }

    public static final boolean isTomcat(Project project) {
        String string = ServerUtils.getServerInstanceID(project);
        return string != null && string != null && string.toLowerCase().contains("tomcat");
    }

    public static final boolean isGlassfish(Project project) {
        if (project != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null) {
                return false;
            }
            return ServerUtils.isGlassfish(j2eeModuleProvider.getServerInstanceID());
        }
        return false;
    }

    public static final boolean isGlassfish(String string) {
        return string != null && (string.toLowerCase().contains("appserv") || string.toLowerCase().contains("gfv3"));
    }

    public static J2eeModuleProvider getProvider(Project project) {
        if (project != null) {
            return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        }
        return null;
    }

    public static FileObject getTomcatLocation(Project project) {
        InstalledFileLocator installedFileLocator;
        String string = null;
        String string2 = null;
        File file = null;
        File file2 = null;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = null;
        if (j2eeModuleProvider != null) {
            instanceProperties = j2eeModuleProvider.getInstanceProperties();
        }
        String string3 = instanceProperties.getProperty("url");
        int n = string3.indexOf("http://");
        int n2 = string3.indexOf("home=") + "home=".length();
        int n3 = string3.indexOf(":base=", n2);
        if (n2 >= "home=".length()) {
            FileObject fileObject;
            int n4 = n3 > 0 ? n3 : (n > 0 ? n - 1 : string3.length());
            int n5 = n > 0 ? n - 1 : string3.length();
            string = string3.substring(n2, n4);
            if (n3 > 0) {
                string2 = string3.substring(n3 + ":base=".length(), n5);
            }
            if (string.length() > 0 && string.charAt(0) == '$' && (fileObject = FileUtil.getConfigFile((String)BUNDLED_TOMCAT_SETTING)) != null) {
                string = fileObject.getAttribute(string.substring(1)).toString();
                if (string2 != null && string2.length() > 0 && string2.charAt(0) == '$') {
                    string2 = fileObject.getAttribute(string2.substring(1)).toString();
                }
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("CATALINA_HOME must not be null.");
        }
        file = new File(string);
        if (!file.isAbsolute()) {
            InstalledFileLocator installedFileLocator2 = InstalledFileLocator.getDefault();
            file = installedFileLocator2.locate(string, null, false);
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("CATALINA_HOME directory does not exist.");
        }
        if (string2 != null && !(file2 = new File(string2)).isAbsolute() && (file2 = (installedFileLocator = InstalledFileLocator.getDefault()).locate(string2, null, false)) == null) {
            file2 = new File(System.getProperty("netbeans.user"), string2);
        }
        return file2 == null ? (file == null ? null : FileUtil.toFileObject((File)file)) : FileUtil.toFileObject(file2);
    }

    public static FileObject getServerXml(Project project) {
        String string = "conf/server.xml";
        FileObject fileObject = ServerUtils.getTomcatLocation(project);
        return fileObject == null ? null : fileObject.getFileObject(string);
    }

    public static FileObject getTomcatLocation(String string) {
        if (string == null) {
            return null;
        }
        FileObject fileObject = null;
        try {
            String string2;
            File file;
            int n = string.indexOf("home=") + 5;
            int n2 = string.indexOf(":", string.indexOf("home=") + 1);
            if (n2 <= n) {
                n2 = string.length();
            }
            if ((file = new File(string2 = string.substring(n, n2))) != null) {
                fileObject = FileUtil.toFileObject((File)file);
            }
        }
        catch (Exception exception) {
            logger.log(Level.INFO, string, exception);
        }
        return fileObject;
    }

    public static String getStoreLocation(Project project, boolean bl, boolean bl2) {
        String string = null;
        if (project == null) {
            return string;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            String string2 = j2eeModuleProvider.getServerInstanceID();
            InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
            if (instanceProperties == null || "".equals(instanceProperties.getProperty("LOCATION"))) {
                return "";
            }
            string = ServerUtils.getStoreLocation(string2, bl, bl2);
        }
        return string;
    }

    static String getStoreLocation(String string, boolean bl, boolean bl2) {
        String string2 = null;
        J2eePlatform j2eePlatform = null;
        File[] fileArray = null;
        String string3 = null;
        try {
            j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            Exceptions.printStackTrace((Throwable)instanceRemovedException);
        }
        string3 = bl2 ? (bl ? "truststoreClient" : "keystoreClient") : (bl ? "truststore" : "keystore");
        fileArray = j2eePlatform.getToolClasspathEntries(string3);
        if (fileArray != null && fileArray.length > 0) {
            string2 = fileArray[0].getAbsolutePath();
        }
        return string2;
    }
}

