/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class STSClientPanel
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private JaxWsModel jaxwsmodel;
    private Project project;
    private JLabel endpointLabel;
    private JTextField endpointTextField;
    private JTextField metadataField;
    private JLabel metadataLabel;
    private JLabel namespaceLabel;
    private JTextField namespaceTextField;
    private JLabel portNameLabel;
    private JTextField portNameTextField;
    private JLabel serviceNameLabel;
    private JTextField serviceNameTextField;
    private JCheckBox shareTokenChBox;
    private JComboBox trustVersionCombo;
    private JLabel trustVersionLabel;
    private JLabel wsdlLocationLabel;
    private JTextField wsdlLocationTextField;

    public STSClientPanel(SectionView sectionView, Node node, Binding binding, JaxWsModel jaxWsModel) {
        super(sectionView);
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        this.initComponents();
        this.endpointLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.endpointTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.metadataLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.metadataField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.namespaceLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.namespaceTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.portNameLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.portNameTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.serviceNameLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.serviceNameTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.wsdlLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.wsdlLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.trustVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.trustVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.shareTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.shareTokenChBox.setToolTipText(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ShareToken_Tooltip"));
        this.inSync = true;
        this.trustVersionCombo.addItem(ComboConstants.TRUST_10);
        this.trustVersionCombo.addItem(ComboConstants.TRUST_13);
        this.inSync = false;
        this.addImmediateModifier(this.endpointTextField);
        this.addImmediateModifier(this.namespaceTextField);
        this.addImmediateModifier(this.portNameTextField);
        this.addImmediateModifier(this.serviceNameTextField);
        this.addImmediateModifier(this.wsdlLocationTextField);
        this.addImmediateModifier(this.metadataField);
        this.addImmediateModifier(this.trustVersionCombo);
        this.addImmediateModifier(this.shareTokenChBox);
        this.sync();
    }

    public void sync() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.inSync = true;
        String string7 = ProprietarySecurityPolicyModelHelper.getPreSTSEndpoint(this.binding);
        if (string7 != null) {
            this.setEndpoint(string7);
        }
        if ((string6 = ProprietarySecurityPolicyModelHelper.getPreSTSMetadata(this.binding)) != null) {
            this.setMetadata(string6);
        }
        if ((string5 = ProprietarySecurityPolicyModelHelper.getPreSTSNamespace(this.binding)) != null) {
            this.setNamespace(string5);
        }
        if ((string4 = ProprietarySecurityPolicyModelHelper.getPreSTSPortName(this.binding)) != null) {
            this.setPortName(string4);
        }
        if ((string3 = ProprietarySecurityPolicyModelHelper.getPreSTSServiceName(this.binding)) != null) {
            this.setServiceName(string3);
        }
        if ((string2 = ProprietarySecurityPolicyModelHelper.getPreSTSWsdlLocation(this.binding)) != null) {
            this.setWsdlLocation(string2);
        }
        if ((string = ProprietarySecurityPolicyModelHelper.getPreSTSWstVersion(this.binding)) != null) {
            this.setWstVersion(string);
        }
        boolean bl = ProprietarySecurityPolicyModelHelper.isPreSTSShareToken(this.binding);
        this.setShareToken(bl);
        this.inSync = false;
    }

    private String getEndpoint() {
        return this.endpointTextField.getText();
    }

    private void setEndpoint(String string) {
        this.endpointTextField.setText(string);
    }

    private String getMetadata() {
        return this.metadataField.getText();
    }

    private void setMetadata(String string) {
        this.metadataField.setText(string);
    }

    private boolean isShareToken() {
        return this.shareTokenChBox.isSelected();
    }

    private void setShareToken(boolean bl) {
        this.shareTokenChBox.setSelected(bl);
    }

    private String getNamespace() {
        return this.namespaceTextField.getText();
    }

    private void setNamespace(String string) {
        this.namespaceTextField.setText(string);
    }

    private String getServiceName() {
        return this.serviceNameTextField.getText();
    }

    private void setServiceName(String string) {
        this.serviceNameTextField.setText(string);
    }

    private String getPortName() {
        return this.portNameTextField.getText();
    }

    private void setPortName(String string) {
        this.portNameTextField.setText(string);
    }

    private String getWsdlLocation() {
        return this.wsdlLocationTextField.getText();
    }

    private void setWsdlLocation(String string) {
        this.wsdlLocationTextField.setText(string);
    }

    private String getWstVersion() {
        if (ComboConstants.TRUST_13.equals(this.trustVersionCombo.getSelectedItem())) {
            return ComboConstants.TRUST_13_POLICYSTR;
        }
        return ComboConstants.TRUST_10_POLICYSTR;
    }

    private void setWstVersion(String string) {
        if (ComboConstants.TRUST_13_POLICYSTR.equals(string)) {
            this.trustVersionCombo.setSelectedItem(ComboConstants.TRUST_13);
        } else {
            this.trustVersionCombo.setSelectedItem(ComboConstants.TRUST_10);
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (!this.inSync) {
            String string;
            Util.checkMetroLibrary(this.project);
            if (jComponent.equals(this.endpointTextField)) {
                string = this.getEndpoint();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSEndpoint(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSEndpoint(this.binding, string);
                }
            }
            if (jComponent.equals(this.metadataField)) {
                string = this.getMetadata();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSMetadata(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSMetadata(this.binding, string);
                }
            }
            if (jComponent.equals(this.namespaceTextField)) {
                string = this.getNamespace();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSNamespace(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSNamespace(this.binding, string);
                }
            }
            if (jComponent.equals(this.serviceNameTextField)) {
                string = this.getServiceName();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSServiceName(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSServiceName(this.binding, string);
                }
            }
            if (jComponent.equals(this.portNameTextField)) {
                string = this.getPortName();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSPortName(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSPortName(this.binding, string);
                }
            }
            if (jComponent.equals(this.wsdlLocationTextField)) {
                string = this.getWsdlLocation();
                if (string != null && string.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSWsdlLocation(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSWsdlLocation(this.binding, string);
                }
            }
            if (jComponent.equals(this.trustVersionCombo)) {
                string = this.getWstVersion();
                ProprietarySecurityPolicyModelHelper.setPreSTSWstVersion(this.binding, string);
            }
            if (jComponent.equals(this.shareTokenChBox)) {
                ProprietarySecurityPolicyModelHelper.setPreSTSShareToken(this.binding, this.isShareToken());
            }
            this.enableDisable();
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        this.enableDisable();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    private void enableDisable() {
        WSStackVersion wSStackVersion = WSITConfigProvider.getDefault().getHighestWSStackVersion(this.project);
        boolean bl = ConfigVersion.CONFIG_2_0.isSupported(wSStackVersion);
        boolean bl2 = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        this.endpointLabel.setEnabled(!bl2);
        this.endpointTextField.setEnabled(!bl2);
        this.metadataField.setEnabled(!bl2);
        this.metadataLabel.setEnabled(!bl2);
        this.namespaceLabel.setEnabled(!bl2);
        this.namespaceLabel.setEnabled(!bl2);
        this.portNameLabel.setEnabled(!bl2);
        this.portNameTextField.setEnabled(!bl2);
        this.serviceNameLabel.setEnabled(!bl2);
        this.serviceNameTextField.setEnabled(!bl2);
        this.shareTokenChBox.setEnabled(!bl2 && bl);
        this.shareTokenChBox.setEnabled(!bl2 && bl);
        this.wsdlLocationLabel.setEnabled(!bl2);
        this.wsdlLocationTextField.setEnabled(!bl2);
    }

    private void initComponents() {
        this.endpointLabel = new JLabel();
        this.wsdlLocationLabel = new JLabel();
        this.endpointTextField = new JTextField();
        this.wsdlLocationTextField = new JTextField();
        this.serviceNameLabel = new JLabel();
        this.serviceNameTextField = new JTextField();
        this.portNameLabel = new JLabel();
        this.namespaceLabel = new JLabel();
        this.portNameTextField = new JTextField();
        this.namespaceTextField = new JTextField();
        this.metadataLabel = new JLabel();
        this.metadataField = new JTextField();
        this.trustVersionLabel = new JLabel();
        this.trustVersionCombo = new JComboBox();
        this.shareTokenChBox = new JCheckBox();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                STSClientPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                STSClientPanel.this.formAncestorAdded(ancestorEvent);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.endpointLabel.setLabelFor(this.endpointTextField);
        Mnemonics.setLocalizedText((JLabel)this.endpointLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint"));
        this.endpointLabel.setToolTipText("The maximum number of seconds the time stamp remains valid.");
        this.wsdlLocationLabel.setLabelFor(this.wsdlLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.wsdlLocationLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation"));
        this.wsdlLocationLabel.setToolTipText("The maximum number of seconds the sending clock can deviate from the receiving clock.");
        this.endpointTextField.setHorizontalAlignment(2);
        this.wsdlLocationTextField.setHorizontalAlignment(2);
        this.serviceNameLabel.setLabelFor(this.serviceNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.serviceNameLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName"));
        this.serviceNameTextField.setHorizontalAlignment(2);
        this.portNameLabel.setLabelFor(this.portNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.portNameLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName"));
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace"));
        this.portNameTextField.setHorizontalAlignment(2);
        this.namespaceTextField.setHorizontalAlignment(2);
        this.metadataLabel.setLabelFor(this.metadataField);
        Mnemonics.setLocalizedText((JLabel)this.metadataLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata"));
        Mnemonics.setLocalizedText((JLabel)this.trustVersionLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PolicyVersion"));
        Mnemonics.setLocalizedText((AbstractButton)this.shareTokenChBox, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ShareToken"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.namespaceLabel).add((Component)this.endpointLabel).add((Component)this.wsdlLocationLabel).add((Component)this.metadataLabel).add((Component)this.serviceNameLabel).add((Component)this.portNameLabel).add((Component)this.trustVersionLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.namespaceTextField, -1, 383, Short.MAX_VALUE).add((Component)this.portNameTextField, -1, 383, Short.MAX_VALUE).add((Component)this.serviceNameTextField, -1, 383, Short.MAX_VALUE).add((Component)this.wsdlLocationTextField, -1, 383, Short.MAX_VALUE).add((Component)this.endpointTextField, -1, 383, Short.MAX_VALUE).add((Component)this.metadataField, -1, 383, Short.MAX_VALUE).add((Component)this.trustVersionCombo, -2, 63, -2))).add((Component)this.shareTokenChBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.endpointLabel).add((Component)this.endpointTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.wsdlLocationLabel).add((Component)this.wsdlLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.metadataLabel).add((Component)this.metadataField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serviceNameLabel).add((Component)this.serviceNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.portNameLabel).add((Component)this.portNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.namespaceLabel).add((Component)this.namespaceTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.trustVersionLabel).add((Component)this.trustVersionCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.shareTokenChBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.endpointLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint_ACSN"));
        this.endpointLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint_ACSD"));
        this.wsdlLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation_ACSN"));
        this.wsdlLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation_ACSD"));
        this.serviceNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName_ACSN"));
        this.serviceNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName_ACSD"));
        this.portNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName_ACSN"));
        this.portNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName_ACSD"));
        this.namespaceLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace_ACSN"));
        this.namespaceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace_ACSD"));
        this.metadataLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata_ACSN"));
        this.metadataLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata_ACSD"));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }
}

