/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.projects;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificSecurity;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectSpecificSecurity
extends ProjectSpecificSecurity {
    private static final Logger logger = Logger.getLogger(WebProjectSpecificSecurity.class.getName());

    @Override
    public boolean unsetSSLAttributes(WSDLComponent wSDLComponent) {
        SecurityConstraint securityConstraint = WebProjectSpecificSecurity.getSecurityConstraint(wSDLComponent);
        if (securityConstraint != null) {
            try {
                FileObject fileObject = WebProjectSpecificSecurity.getDDFO(wSDLComponent);
                if (fileObject == null) {
                    return false;
                }
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    webApp.removeSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                }
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    @Override
    public boolean setSSLAttributes(WSDLComponent wSDLComponent) {
        if (WebProjectSpecificSecurity.getSecurityConstraint(wSDLComponent) == null) {
            FileObject fileObject = WebProjectSpecificSecurity.getDDFO(wSDLComponent);
            if (fileObject == null) {
                return false;
            }
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    Collection collection;
                    SecurityConstraint securityConstraint = (SecurityConstraint)webApp.createBean("SecurityConstraint");
                    AuthConstraint authConstraint = (AuthConstraint)webApp.createBean("AuthConstraint");
                    authConstraint.addRoleName("EMPLOYEE");
                    securityConstraint.setAuthConstraint(authConstraint);
                    UserDataConstraint userDataConstraint = (UserDataConstraint)webApp.createBean("UserDataConstraint");
                    userDataConstraint.setTransportGuarantee("CONFIDENTIAL");
                    securityConstraint.setUserDataConstraint(userDataConstraint);
                    String string = null;
                    String string2 = "/";
                    boolean bl = false;
                    if (wSDLComponent instanceof Binding) {
                        collection = wSDLComponent.getModel().getDefinitions().getServices();
                        for (Service service : collection) {
                            Collection collection2 = service.getPorts();
                            for (Port port : collection2) {
                                QName qName = port.getBinding().getQName();
                                String string3 = ((Binding)wSDLComponent).getName();
                                if (!string3.equals(qName.getLocalPart())) continue;
                                string = service.getName();
                                string2 = string2.concat(string + "/*");
                                bl = true;
                                break;
                            }
                            if (!bl) continue;
                            break;
                        }
                    }
                    securityConstraint.setDisplayName(NbBundle.getMessage(WebProjectSpecificSecurity.class, (String)"LBL_SECCONSTRAINT_DNAME", string));
                    collection = (WebResourceCollection)webApp.createBean("WebResourceCollection");
                    collection.setHttpMethod(new String[]{"POST"});
                    collection.setUrlPattern(new String[]{string2});
                    collection.setWebResourceName("Secure Area");
                    securityConstraint.addWebResourceCollection((WebResourceCollection)collection);
                    webApp.addSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                    return true;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return false;
    }

    private static SecurityConstraint getSecurityConstraint(WSDLComponent wSDLComponent) {
        FileObject fileObject = WebProjectSpecificSecurity.getDDFO(wSDLComponent);
        if (fileObject != null) {
            Object object;
            WebResourceCollection webResourceCollection;
            SecurityConstraint[] securityConstraintArray;
            WebApp webApp = null;
            try {
                webApp = DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, null, iOException);
            }
            String string = null;
            if (wSDLComponent instanceof Binding) {
                securityConstraintArray = wSDLComponent.getModel().getDefinitions().getServices();
                for (Service service : securityConstraintArray) {
                    Collection collection = service.getPorts();
                    SecurityConstraint securityConstraint = collection.iterator();
                    while (securityConstraint.hasNext()) {
                        webResourceCollection = (Port)securityConstraint.next();
                        object = webResourceCollection.getBinding().getQName();
                        String string2 = ((Binding)wSDLComponent).getName();
                        if (!string2.equals(((QName)object).getLocalPart())) continue;
                        string = service.getName();
                    }
                }
            }
            if (webApp != null && webApp.getStatus() != 2) {
                for (SecurityConstraint securityConstraint : securityConstraintArray = webApp.getSecurityConstraint()) {
                    webResourceCollection = securityConstraint.getWebResourceCollection(0);
                    if (webResourceCollection == null || (object = webResourceCollection.getUrlPattern(0)) == null || !((String)object).contains(string)) continue;
                    return securityConstraint;
                }
            }
        }
        return null;
    }

    private static FileObject getDDFO(WSDLComponent wSDLComponent) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        FileObject fileObject = Util.getFOForModel(wSDLModel);
        if (fileObject != null) {
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            return webModule.getDeploymentDescriptor();
        }
        return null;
    }
}

