/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.web.core.syntax.JspUtils;

public class JspEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy<CharSequence> th = JspUtils.createJspTokenHierarchy(snapshot);
        TokenSequence sequence = th.tokenSequence(JspTokenId.language());
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        boolean lastEmbeddingIsVirtual = false;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == JspTokenId.TEXT) {
                embeddings.add(snapshot.create(sequence.offset(), t.length(), "text/html"));
                lastEmbeddingIsVirtual = false;
                continue;
            }
            if (lastEmbeddingIsVirtual) continue;
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, "text/html"));
            lastEmbeddingIsVirtual = true;
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 100;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new JspEmbeddingProvider());
        }
    }
}

